//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.gssapi;

import java.io.InputStream;
import java.io.IOException;
import java.io.ByteArrayOutputStream;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Oid;

class PerMessageToken extends Token
{
  private byte[] innerToken;

  /**
   * Constructs a Token from an encoded token as per RFC1964.
   * The encoding is _NOT_ Asn1 because of the token-id preceding
   * the kerberos message in the innerContextToken
   */
  PerMessageToken(byte encoded[]) throws Asn1Exception
  {
    int marks[] = new int[2];
    marks[0] = decodeLengthOctets(encoded, marks);

    //Return if there are no contents
    if (marks[0] < 0) return;

    //Get the mechType oid
    Oid mechTypeOid = (Oid)Oid.decode(encoded, marks);

    //Get the tokenid
    this.tokenId = new byte[2];
    System.arraycopy(encoded, marks[1], this.tokenId, 0, 2);

    //Get the innerToken
    //Asn1 der = Asn1.decode(encoded, marks);
    this.innerToken = new byte[encoded.length - marks[1]];
    System.arraycopy(encoded, marks[1], this.innerToken, 0, innerToken.length);
  }

  /**
   * Constructs a Token from a tokenId and the innerToken
   */
  PerMessageToken(byte[] tokenId, byte[] innerToken)
  {
    this.tokenId = tokenId;
    this.innerToken = innerToken;
    this.setTagClass(TAG_CLASS_APPLICATION);
    this.setTagNumber(0);
  }

  /**
   * Returns the innerToken
   */
  byte[] getInnerToken() 
  {
    return this.innerToken;
  }

  protected byte[] doContents()
  {
    try
    {
      ByteArrayOutputStream bos = new ByteArrayOutputStream();
      bos.write((new Oid(kerberosMechType)).encode());
      bos.write(innerToken);
      return bos.toByteArray();
    }
    catch (Exception e)
    {
      e.printStackTrace();
      return null;
    }
  }
}
