//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.v5.base;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;

/**
 * <p>A class representing the Kerberos ASN.1 structure APOptions.
 *
 * <pre>
 * APOptions :== BIT STRING {
 *                 reserved(0),
 *                 use-session-key(1),
 *                 mutual-required(2)
 * }
 * </pre>
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public final class APOptions extends BitString 
{
  /**
   * Constructs an APOptions
   *
   * @param session true if use-session-key should be set
   * @param mutual  true if mutual-required should be set
   */
  public APOptions(boolean session, boolean mutual)
  {
    super();
    contents = new byte[5];

    if (session)
      contents[1] |= (byte) 0x40;    
    if (mutual)
      contents[1] |= (byte) 0x20;
  }

  /**
   * Constructs an APOptions from a DER encoding
   */
  public APOptions(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);
  }

  /**
   * Check if the use-session-key option is set for this request
   */
  public boolean isUsingSessionKey() 
  {
    return (contents[1] & (byte)0x40) != 0;
  }

  /**
   * Check if the mutual-required option is set for this request
   */
  public boolean isMutualAuthRequired() 
  {
    return (contents[1] & (byte)0x20) != 0;
  }
}
