//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.v5.base;

import java.util.Date;
import java.util.Calendar;
import java.util.TimeZone;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.GeneralizedTime;

/**
 * <p>A class representing the Kerberos ASN.1 structure KerberosTime.
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public final class KerberosTime extends GeneralizedTime
{
  /**
   * Constructs a KerberosTime for the current time
   */
  public KerberosTime()
  {
    contents = this.getTime(null, 0).getBytes();
  }

  /**
   * Constructs a KerberosTime with an offset wrt current time
   */
  public KerberosTime(int hourOffset)
  {
    contents = this.getTime(null, hourOffset).getBytes();
  }

  /**
   * Constructs a KerberosTime from a Date
   */
  public KerberosTime(Date date) 
  {
    contents = this.getTime(date, 0).getBytes();
  }

  /**
   * Constructs a KerberosTime with an offset from a Date
   */
  public KerberosTime(Date date, int hourOffset) 
  {
    contents = this.getTime(date, hourOffset).getBytes();
  }

  /**
   * Constructs a KerberosTime from a DER encoding
   */
  public KerberosTime(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);
  }

  /**
   * Returns a KerberosTime for the current time
   */
  public static KerberosTime getCurrent()
  {
    return new KerberosTime(0);
  }

  /**
   * Returns the Date for this KerberosTime
   */
  public Date getDate()
  {
    Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    //Calendar cal = Calendar.getInstance();
    cal.set(Integer.parseInt(new String(contents, 0, 4)), 
            Integer.parseInt(new String(contents, 4, 2)) - 1,
            Integer.parseInt(new String(contents, 6, 2)),
            Integer.parseInt(new String(contents, 8, 2)),
            Integer.parseInt(new String(contents, 10, 2)),
            Integer.parseInt(new String(contents, 12, 2)));
    return cal.getTime();
  }

  private String getTime(Date date, int hourOffset) 
  {
    Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    //Calendar cal = Calendar.getInstance();
    if (date != null) cal.setTime(date);

    cal.add(Calendar.HOUR_OF_DAY, hourOffset);

    StringBuffer now = new StringBuffer();
    now.append(cal.get(Calendar.YEAR));

    append(now, cal.get(Calendar.MONTH) + 1);
    append(now, cal.get(Calendar.DATE));
    append(now, cal.get(Calendar.HOUR_OF_DAY));
    append(now, cal.get(Calendar.MINUTE));
    append(now, cal.get(Calendar.SECOND));

    now.append("Z");
    return now.toString();
  }

  private void append(StringBuffer sb, int number)
  {
    if (number < 10)
      sb.append("0" + number);
    else
      sb.append(number);
  }
}
