//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.v5.crypto;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.OctetString;

/**
 * <p>A class representing the Kerberos ASN.1 structure Checksum.
 *
 * <pre>
 * Checksum ::=  SEQUENCE {
 *                 cksumtype[0]    INTEGER,
 *                 checksum[1]     OCTET STRING
 * }
 * </pre>
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public final class Checksum extends Sequence
{
  private int cksumType;
  private byte[] cksum;

  /**
   * Constructs a Checksum from the type and the checksum bytes
   */
  public Checksum(int cksumType, byte cksum[])
  {
    this.cksumType = cksumType;
    Explicit exp = new Explicit(Asn1.TAG_CLASS_CONTEXT, 0);
    exp.addComponent(new com.dstc.security.asn1.Integer(cksumType));
    addComponent(exp);

    this.cksum = cksum;
    exp = new Explicit(Asn1.TAG_CLASS_CONTEXT, 1);
    exp.addComponent(new OctetString(cksum));
    addComponent(exp);
  }

  /**
   * Constructs a Checksum from a DER encoding
   */
  public Checksum(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);

    Explicit exp = (Explicit)components.elementAt(0);
    if (exp.getTagNumber() != 0)
      throw new Asn1Exception("Bad Tag number");
    this.cksumType 
      = ((com.dstc.security.asn1.Integer)exp.getComponent()).getInt();

    exp = (Explicit)components.elementAt(1);
    if (exp.getTagNumber() != 1)
      throw new Asn1Exception("Bad Tag number");
    this.cksum = ((OctetString)exp.getComponent()).getBytes();
  }

  /**
   * Returns the checksum type
   */
  public int getType()
  {
    return cksumType;
  }

  /**
   * Returns the checksum bytes
   */
  public byte[] getBytes()
  {
    return cksum;
  }
}
