//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.v5.crypto;

import java.util.Vector;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;

/**
 * <p>A class representing the ASN.1 structure EncrptionType.
 *
 * <pre>
 * EncryptionType ::=  SEQUENCE OF INTEGER
 * </pre>
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public final class EncryptionType extends Sequence
{
  private Vector types = new Vector();

  /**
   * Constructs an EncryptionType from a Vector of Integers
   */
  public EncryptionType(Vector types)
  {
    for (int i=0; i<types.size(); i++)
    {
      addComponent(new com.dstc.security.asn1.Integer(
        ((Integer)types.elementAt(i)).intValue()));
    }
  }

  /**
   * Constructs an EncryptionType from a DER encoding
   */
  public EncryptionType(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);
   
    for (int i=0; i<components.size(); i++)
    { 
      types.addElement(new Integer(
        ((com.dstc.security.asn1.Integer)components.elementAt(i)).getInt()));
    }
  }

  public Vector getTypes()
  {
    return this.types;
  }
}
