//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.pkcs8;

import java.io.FileOutputStream;
import java.util.Vector;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Security;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;
import com.dstc.security.provider.PBEKey;
import com.dstc.security.provider.OID;
import com.dstc.security.asn1.*;
import com.dstc.security.x509.AlgorithmId;

/**
 * <p>A class representing the PKCS#8 ASN.1 structure EncryptedPrivateKeyInfo.
 *
 * <pre>
 * EncryptedPrivateKeyInfo  ::= SEQUENCE  {
 *       algorithm            AlgorithmIdentifier,
 *       subjectPrivateKey     OCTET STRING  }
 * </pre>
 *
 * @see com.dstc.security.pkcs.PrivateKeyInfo
 * @see com.dstc.security.x509.AlgorithmId
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public class EncryptedPrivateKeyInfo extends Sequence
{
  //Encryption Algorithm
  private AlgorithmId encAlgo;

  //Encryped Key
  private byte encryptedKey[];

  /**
   *  Constructs an EncryptedPrivateKeyInfo from the encryption
   *  AlgorithmId and encrypted private key
   */
  public EncryptedPrivateKeyInfo(AlgorithmId sAlgo, byte encryptedKey[]) 
  {
    this.encAlgo = sAlgo;
    this.addComponent(sAlgo);

    this.encryptedKey = encryptedKey;
    this.addComponent(new OctetString(encryptedKey));
  }

  /**
   * Constructs a EncryptedPrivateKeyInfo from a DER encoding
   */
  public EncryptedPrivateKeyInfo(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);
    this.encAlgo = new AlgorithmId(
                    ((Sequence)components.elementAt(0)).encode());
    this.encryptedKey = ((OctetString)components.elementAt(1)).getBytes();
  }

  /**
   * Returns the encrypted Private Key
   */
  public byte[] getEncryptedKey() 
  {
    return this.encryptedKey;
  }

  /**
   * Returns the encryption AlgorithmId
   */
  public AlgorithmId getEncryptionAlgorithm() 
  {
    return this.encAlgo;
  }
}
