//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.provider;

import java.io.IOException;
import java.math.BigInteger;

import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Asn1Exception;

/**
 * <p>Implements java.security.AlgorithmParameters for the DESede
 * encryption algorithm
 *
 * @see java.security.AlgorithmParameters
 * @see com.dstc.security.provider.DESede
 * @see javax.crypto.Cipher
 *
 * @version 0.99, 99/03/01
 * @author Ming Yung
 */
public final class DESedeParameters extends AlgorithmParametersSpi
{
  private CBCParameter params;
  private IvParameterSpec paramsSpec;

  protected void engineInit(AlgorithmParameterSpec paramSpec) 
    throws InvalidParameterSpecException
  {
    if (!(paramSpec instanceof IvParameterSpec))
      throw new InvalidParameterSpecException("Not an IV param spec");

    this.paramsSpec = (IvParameterSpec)paramSpec;
    this.params = new CBCParameter(this.paramsSpec);
  }

  protected void engineInit(byte[] encoded) throws IOException
  {
    try
    {
      this.params = new CBCParameter(encoded);
      this.paramsSpec = this.params.ivSpec;
    }
    catch (Exception e)
    {
      throw new IOException(e.toString());
    }
  }

  protected void engineInit(byte[] params, String format) throws IOException
  {
    engineInit(params);
  }

  protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) 
    throws InvalidParameterSpecException
  {
    if (!paramSpec.getName().equals("javax.crypto.spec.IvParameterSpec"))
      throw new InvalidParameterSpecException(paramSpec.getName()
        + " not supported");
    return this.paramsSpec;
  }

  protected byte[] engineGetEncoded() throws IOException
  {
    return params.encode();
  }

  protected byte[] engineGetEncoded(String format) throws IOException
  {
    return engineGetEncoded();
  }

  protected String engineToString()
  {
    return "DESede Parameters";
  }

  /**
   * <p>An Inner class representing the ASN.1 structure CBCParameter.
   */
  protected class CBCParameter extends OctetString
  {
    private IvParameterSpec ivSpec;

    /**
     * Constructs a CBCParameter from an IvParameterSpec
     */
    protected CBCParameter(IvParameterSpec iv)
    {
      this.ivSpec = iv;
      contents = iv.getIV();
    }

    /**
     * Constructs a CBCParameter from a DER encoding
     */
    protected CBCParameter(byte encoded[]) throws Asn1Exception
    {
      doDecode(encoded);

      this.ivSpec = new IvParameterSpec(contents);
    }
  }
}
