//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.provider;

import java.math.BigInteger;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.AlgorithmParameters;
import javax.crypto.Cipher;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.x509.AlgorithmId;
import com.dstc.security.pkcs8.PrivateKeyInfo;
import com.dstc.security.pkcs8.EncryptedPrivateKeyInfo;

/**
 * <p>Implements a private key for use with the Diffie-Hellman key agreement
 * algorithm.
 * 
 * @see java.security.PublicKey
 * @see java.security.DHKeyAgreement
 * @see com.dstc.security.provider.DHParameters
 * @see com.dstc.security.provider.DHPublicKey
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public class DHPrivateKey extends com.dstc.security.asn1.Integer
  implements javax.crypto.interfaces.DHPrivateKey
{
  private BigInteger x;
  private DHParameterSpec params;

  protected DHPrivateKey(BigInteger x, BigInteger p, BigInteger g, int l)
  {
    super(x);
    this.x = x;
    this.params = new DHParameterSpec(p, g, l);
  }

  public BigInteger getX()
  {
    return this.x;
  }

  public DHParameterSpec getParams()
  {
    return this.params;
  }

  public String getAlgorithm()
  {
    return "DH";
  }

  public String getFormat()
  {
    return "PKCS#8";
  }

  ///Returns DER encoding of PrivateKeyInfo for this key
  public byte[] getEncoded()
  {
    try
    {
      AlgorithmParameters algParams =
        AlgorithmParameters.getInstance("DH", "DSTC");
      algParams.init(params);

      //Get Encoded private key
      byte priv[] = (new PrivateKeyInfo(new AlgorithmId(OID.dhKeyAgreement,
        algParams), super.encode())).encode();

      return priv;
    }
    catch (Exception e)
    {
      System.out.println(e.toString());
      return null;
    }
  }

  //Constructs a DH private key from a DER INTEGER encoding and DHParams
  public DHPrivateKey(byte encoded[], DHParameterSpec params)
    throws Asn1Exception
  {
    doDecode(encoded);
    this.x = this.getBigInteger();
    this.params = params;
  }
}
