//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.provider;

import java.security.Provider;

/**
 * <p>The DSTC provider master class.
 *
 * @see java.security.Provider
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public final class DSTC extends Provider 
{
  private static String info;

  static
  {
    StringBuffer sb = new StringBuffer();
    sb.append("DSTC Security Provider v0.99 (1/3/99): \n");
    sb.append("  MD2, MD5, SHA-1 and RIPEMD-160 message digests,\n");
    sb.append("  DSA key generation and signatures,\n");
    sb.append("  RSA key generation and signing with ");
    sb.append("MD2, MD5, SHA-1 and RIPEMD-160\n");
    sb.append("  RSA encryption,\n");
    sb.append("  DES, DESede, Blowfish, IDEA, RC2 & RC5 block ciphers,\n");
    sb.append("  RC4 stream cipher,\n"); 
    sb.append("  Diffie-Hellman key agreement\n");
    sb.append("  Diffie-Hellman ephemeral signatures\n");
    sb.append("  DES-MAC, and HMAC with MD5, SHA1 and ");
    sb.append("RIPEMD-160 Message Authentication\n");
    sb.append("  PKCS#5 password-based encryption\n");
    sb.append("  PKCS#8 encryption of private keys\n");
    sb.append("  CertificateFactory for X.509 v3 Certificates and CRLs\n");
    info = sb.toString();
  }
  
  public DSTC () 
  {
    super("DSTC", 0.99, info);

    //Certificate factories
    put("CertificateFactory.X509", 
        "com.dstc.security.x509.X509CertificateFactory");

    //Key pair generators

    put("KeyPairGenerator.DH", 
        "com.dstc.security.provider.DHKeyPairGenerator");
    put("KeyPairGenerator.DSA",
        "com.dstc.security.provider.DSAKeyPairGenerator");
    put("Alg.Alias.KeyPairGenerator.OID:1.2.840.10040.4.1", "DSA");
    put("KeyPairGenerator.RSA",
        "com.dstc.security.provider.RSAKeyPairGenerator");

    //Key factories

    put("KeyFactory.DSA",
        "com.dstc.security.provider.DSAKeyFactory");
    put("KeyFactory.RSA",
        "com.dstc.security.provider.RSAKeyFactory");
    put("KeyFactory.DH",
        "com.dstc.security.provider.DHKeyFactory");

    //Signature algorithms

    put("Signature.SHA1withDSA", "com.dstc.security.provider.DSA");
    put("Alg.Alias.Signature.SHA-1withDSA", "SHA1withDSA");
    put("Alg.Alias.Signature.SHA-1/DSA", "SHA1withDSA");
    put("Alg.Alias.Signature.SHA/DSA", "SHA1withDSA");
    put("Alg.Alias.Signature.DSA", "SHA1withDSA");
    put("Alg.Alias.Signature.DSS", "SHA1withDSA");
    put("Alg.Alias.Signature.OID:1.2.840.10040.4.3", "SHA1withDSA");

    put("Signature.MD2withRSA", "com.dstc.security.provider.RSAwithMD2");
    put("Alg.Alias.Signature.MD2/RSA", "MD2withRSA");

    put("Signature.MD5withRSA", "com.dstc.security.provider.RSAwithMD5");
    put("Alg.Alias.Signature.MD5/RSA", "MD5withRSA");

    put("Signature.SHA1withRSA", "com.dstc.security.provider.RSAwithSHA1");
    put("Alg.Alias.Signature.SHA-1withRSA", "SHA1withRSA");
    put("Alg.Alias.Signature.SHA-1/RSA", "SHA1withRSA");
    put("Alg.Alias.Signature.SHA1/RSA", "SHA1withRSA");
    put("Alg.Alias.Signature.SHA/RSA", "SHA1withRSA");

    put("Signature.RIPEMD-160/RSA", 
        "com.dstc.security.provider.RSAwithRIPEMD160"); 
    put("Alg.Alias.Signature.RIPEMD-160withRSA", "RIPEMD-160/RSA");
    put("Alg.Alias.Signature.RIPEMD160withRSA", "RIPEMD-160/RSA");

    put("Signature.RawDSA", "com.dstc.security.provider.RawDSA");
    put("Signature.RawRSA", "com.dstc.security.provider.RawRSA");

    put("Signature.DH", "com.dstc.security.provider.DHEphemeralSignature");

    //Key agreement algorithms

    put("KeyAgreement.DH",
        "com.dstc.security.provider.DHKeyAgreement");

    //MessageDigest algorithms

    put("MessageDigest.MD2", "com.dstc.security.provider.MD2");
    put("MessageDigest.MD5", "com.dstc.security.provider.MD5");
    put("MessageDigest.RIPEMD-160", "com.dstc.security.provider.RIPEMD160");
    put("MessageDigest.SHA", "com.dstc.security.provider.SHA1");
    put("Alg.Alias.MessageDigest.SHA-1", "SHA");
    put("Alg.Alias.MessageDigest.SHA1", "SHA");

    //Key generators

    put("KeyGenerator.DES",
        "com.dstc.security.provider.DESKeyGenerator");
    put("KeyGenerator.DESede",
        "com.dstc.security.provider.DESedeKeyGenerator");
    put("KeyGenerator.RC2",
        "com.dstc.security.provider.RC2KeyGenerator");
    put("KeyGenerator.RC4",
        "com.dstc.security.provider.RC4KeyGenerator");
    put("KeyGenerator.RC5",
        "com.dstc.security.provider.RC5KeyGenerator");
    put("KeyGenerator.IDEA",
        "com.dstc.security.provider.IDEAKeyGenerator");
    put("KeyGenerator.Blowfish",
        "com.dstc.security.provider.BlowfishKeyGenerator");

    //Secret key factories

    put("SecretKeyFactory.DES",
        "com.dstc.security.provider.DESSecretKeyFactory");
    put("SecretKeyFactory.DESede",
        "com.dstc.security.provider.DESedeSecretKeyFactory");
    put("SecretKeyFactory.RC5",
        "com.dstc.security.provider.RC5SecretKeyFactory");
    put("SecretKeyFactory.RC2",
        "com.dstc.security.provider.RC2SecretKeyFactory");
    put("SecretKeyFactory.RC4",
        "com.dstc.security.provider.RC4SecretKeyFactory");
    put("SecretKeyFactory.IDEA",
        "com.dstc.security.provider.IDEASecretKeyFactory");
    put("SecretKeyFactory.Blowfish",
        "com.dstc.security.provider.BlowfishSecretKeyFactory");

    //Cipher algorithms

    put("Cipher.RC5", "com.dstc.security.provider.RC5");
    put("Cipher.RC4", "com.dstc.security.provider.RC4");
    put("Cipher.RC2", "com.dstc.security.provider.RC2");
    put("Cipher.DES", "com.dstc.security.provider.DES");
    put("Cipher.Blowfish", "com.dstc.security.provider.Blowfish");
    put("Cipher.DESede", "com.dstc.security.provider.DESede");
    put("Cipher.IDEA", "com.dstc.security.provider.IDEA");
    put("Cipher.PBEwithMD5andDES-CBC", 
        "com.dstc.security.provider.PBEwithMD5AndDES_CBC");
    put("Cipher.PBEwithSHAand3-KeyTripleDES-CBC", 
        "com.dstc.security.provider.PBEwithSHAAnd3_KeyTripleDES_CBC");
    put("Cipher.PBEwithSHAand40BitRC2-CBC",
        "com.dstc.security.provider.PBEwithSHAAnd40BitRC2_CBC");       
    put("Cipher.RSA", "com.dstc.security.provider.RSA");

    //Algorithm parameters

    put("AlgorithmParameters.DSA",
        "com.dstc.security.provider.DSAParameters");
    put("AlgorithmParameters.DH",
        "com.dstc.security.provider.DHParameters");
    put("AlgorithmParameters.PBEwithMD5andDES-CBC",
        "com.dstc.security.provider.PBEParameters");
    put("AlgorithmParameters.PBEwithSHAand3-KeyTripleDES-CBC",
        "com.dstc.security.provider.PBEParameters");
    put("AlgorithmParameters.PBEwithSHAand40BitRC2-CBC",
        "com.dstc.security.provider.PBEParameters");
    put("AlgorithmParameters.DESede/CBC",
        "com.dstc.security.provider.DESedeParameters");
    put("AlgorithmParameters.RC2/CBC",
        "com.dstc.security.provider.RC2Parameters");
    put("AlgorithmParameters.PasswordBasedMac",
        "com.dstc.security.provider.PBMParameters");
    put("AlgorithmParameters.DHBasedMac",
        "com.dstc.security.provider.DHBMParameters");

    //Algorithm parameter generators

    put("AlgorithmParameterGenerator.DSA",
        "com.dstc.security.provider.DSAParameterGenerator");
    put("AlgorithmParameterGenerator.DH",
        "com.dstc.security.provider.DHParameterGenerator");

    //MAC algorithms

    put("Mac.HMACwithMD5",
        "com.dstc.security.provider.HMACwithMD5");
    put("Mac.HMACwithRIPEMD160",
        "com.dstc.security.provider.HMACwithRIPEMD160");
    put("Mac.HMACwithSHA1",
        "com.dstc.security.provider.HMACwithSHA1");
    put("Mac.DES-MAC",
        "com.dstc.security.provider.DESMAC");
  }
}
