//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, Gehrmann Labs
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.provider;

//From JDK
import java.security.spec.AlgorithmParameterSpec;
//From JCSI
import com.dstc.security.x509.AlgorithmId;

/**
 * <p>This class specifies the set of parameters used with the 
 * Certificate Management Protocol, as specified in CMP spec.
 *
 * @see com.dstc.security.provider.PBMParameter
 * @see java.security.AlgorithParameters
 * @see java.security.spec.AlgorithmParameterSpec
 *
 * @version 0.1, 99/07/05
 * @author Eddy Cheung
 */
public class PBMParameterSpec implements AlgorithmParameterSpec
{
    private byte[] salt;
    private AlgorithmId owf_id;
    private AlgorithmId mac_id;
    private int iterationCount;

    /**
     * Specifies the PBMParameterSpec using a salt, owf algorithmId & Mac algorithmId
     *
     */
    public PBMParameterSpec(byte salt[], AlgorithmId owf, int iterationCount, AlgorithmId mac)
    {
if (salt!=null) {
    System.arraycopy(salt, 0, this.salt, 0, salt.length);
} else {
    this.salt = null;
}

this.owf_id = owf;
this.iterationCount = iterationCount;
this.mac_id = mac;
    }

    /**
     * Returns the salt
     *
     * @return the salt
     */
    public byte[] getSalt()
    {
if (this.salt != null) {
    return this.salt;
} else {
    return null;
}
    }

    
    /**
     * Returns the OWF algorithm Id
     *
     * @return the owf AlgorithmId.
     */
    public AlgorithmId getOwfAlgorithmId()
    {
return this.owf_id;
    }

    /**
     * Returns the IterationCount
     *
     * @return this iteration count
     */
    public int getIterationCount()
    {
return this.iterationCount;
    }
    
    /**
     * Returns the mac Algorithm Id
     *
     * @return the mac AlgorithmId.
     */
    public AlgorithmId getMacAlgorithmId()
    {
return this.mac_id;
    }
}


