//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.provider;

//From JDK
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.io.IOException;
//From JCSI
import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.x509.AlgorithmId;

/**
 * <p>Implements algorithm parameters for the PBMParameter
 * 
 * @see java.security.AlgorithmParameters
 *
 * @version 0.98, 99 July 5
 * @author Eddy Cheung
 * @author Ming Yung
 */

/* Log Message:
 * $Log: PBMParameters.java,v $
 * Revision 1.3  1999/07/06 00:03:57  cheung
 * New PBECipher Methods for PKCS12 and also added some flexibility for KeyDerivation Method.
 * DHKeyFactory, DSAKeyFactory, RSAKeyFactory all still uses PKCS5KeyDerivation method
 * This is currently hard coded... Please beware in the future.
 *
 */

public final class PBMParameters extends AlgorithmParametersSpi
{
  private PBMParameterSpec paramsSpec;
  private PBMParams params;

  protected void engineInit(AlgorithmParameterSpec paramSpec) 
    throws InvalidParameterSpecException
  {
    if (!(paramSpec instanceof PBMParameterSpec))
      throw new InvalidParameterSpecException("Not a PBM param spec");

    this.paramsSpec = (PBMParameterSpec)paramSpec;
    this.params = new PBMParams(paramsSpec.getSalt(),
                                paramsSpec.getOwfAlgorithmId(),
paramsSpec.getIterationCount(),
                                paramsSpec.getMacAlgorithmId());
  }

  protected void engineInit(byte[] params) throws IOException
  {
    try
    {
      this.params = new PBMParams(params);
      this.paramsSpec = new PBMParameterSpec(this.params.salt,
                                             this.params.owf_id,
     this.params.iterationCount,
                                             this.params.mac_id);
    }
    catch (Exception e)
    {
      throw new IOException(e.toString());
    }
  }

  protected void engineInit(byte[] params, String format) throws IOException
  {
    engineInit(params);
  }

  protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) 
    throws InvalidParameterSpecException
  {
    if (!paramSpec.getName().equals("com.dstc.security.provider.PBMParameterSpec"))
      throw new InvalidParameterSpecException(paramSpec.getName() +
        " not supported");

    return this.paramsSpec;
  }

  protected byte[] engineGetEncoded() throws IOException
  {
    return params.encode();
  }

  protected byte[] engineGetEncoded(String format) throws IOException
  {
    return engineGetEncoded();
  }

  protected String engineToString()
  {
    return "PBM Parameters";
  }

  /**
   * <p>Inner class representing the ASN.1 structure PBMParameters
   *
   * <p>PBMParameter ::= SEQUENCE {
   *       salt              OCTET STRING,
   *       owf               AlgorithmIdentifier,
   *       --AlgId for a One-Way Function (SHA-1 recommended)
   *       iterationCount    INTEGER,
   *       --Number of times the OWF is applied
   *       mac               AlgorithmIdentifier
   *       -- the MAC AlgId (e.g., DES-MAC, Triple_DES_MAC [PKCS11],
   *       -- or HMAC [RFC2104, RFC2202]
   *    }
   */
  protected class PBMParams extends Sequence
  {
      private byte[] salt;
      private int iterationCount;
      private AlgorithmId owf_id;
      private AlgorithmId mac_id;
  
    /**
     * Constructs a PBMParams given parameters salt, owf, and a mac algorithmId
     */
    protected PBMParams (byte salt[], AlgorithmId owf, int iterationCount, AlgorithmId mac) 
    {
if (salt != null) {
    System.arraycopy(salt, 0, this.salt, 0, salt.length);
    this.addComponent(new com.dstc.security.asn1.OctetString(salt));
} else {    
    this.addComponent(new com.dstc.security.asn1.OctetString());
}

this.owf_id = owf;
this.addComponent(owf);

this.iterationCount = iterationCount;
this.addComponent(new com.dstc.security.asn1.Integer(iterationCount));

this.mac_id = mac;
this.addComponent(mac);
    }
  
    /**
     * Constructs a  PBMParams from a DER encoding
     */
    protected PBMParams(byte encoded[]) throws Asn1Exception
    {
      doDecode(encoded);

      int i = 0;

      this.salt = ((com.dstc.security.asn1.OctetString)
   components.elementAt(i++)).getBytes();

      this.owf_id = new AlgorithmId(((Asn1)components.elementAt(i++)).encode());

      this.iterationCount = ((com.dstc.security.asn1.Integer)components.elementAt(i++)).getInt();

      //XXX TODO... The following is commented out, as we don't support CAST128 Mac Encryption Alorgithm
    
      //this.mac_id = new AlgorithmId(((Asn1)components.elementAt(i++)).encode());

      System.err.println("Note! PBMParameters.PBMParams(byte[])" +
 " getting AlgorithmId has been commented out.");

    }
  }
}
