//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.smime;

import java.io.*;
import java.util.Vector;
import java.util.Enumeration;

import javax.mail.*;
import javax.mail.internet.*;
import javax.activation.*;

public class TextCanonicalizer
{
  private static final byte LF = 0x0a;
  private static final byte CR = 0x0d;

  private MimeBodyPart part;
  private ByteArrayOutputStream os;

  /**
   * Constructs a TextCanonicalizer from a MimeBodyPart
   * containg the test message to be canonicalized.
   */
  public TextCanonicalizer(MimeBodyPart part)
  {
    os = new ByteArrayOutputStream();
    this.part = part;
  }

  public byte[] getDigest() throws IOException, MessagingException
  {
/*
    ByteArrayOutputStream out = new ByteArrayOutputStream();
    part.writeTo(out);
    ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
    BufferedReader rd = new BufferedReader(new InputStreamReader(in));
    while (true)
    {
      String line = rd.readLine();
      if (line == null)
        break;

System.out.println("line: " + line);
      os.write(line.getBytes());
      os.write("\r\n".getBytes());
    }
    return os.toByteArray();
*/
    ByteArrayOutputStream out = new ByteArrayOutputStream();
    part.writeTo(out);
    ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());

    int curr, next;
    while ((curr = in.read()) != -1)
    {
      switch (curr)
      {
        case (CR):
          //next = is.read();
          break;

        case (LF):
          os.write(CR);
          os.write(LF);
          break;

        default:
          os.write(curr);
      }
    }
    return os.toByteArray();
  }  
}
