//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.smime.handlers;

import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import javax.activation.*;
import java.awt.datatransfer.*;
import com.dstc.security.smime.MimeMultipartSigned;

/**
 * <p>An implementation of a DataContentHandler for content-type
 * multipart_signed.
 *
 * @version 0.98, 98/11/01
 * @author Ming Yung
 */
public class multipart_signed implements DataContentHandler
{
  /**
   * Returns a MimeMultipartSigned object from the DataSource
   */
  public Object getContent(DataSource dataSource)
  {
    try
    {
      return new MimeMultipartSigned(dataSource);
    }
    catch (Exception e)
    {
      e.printStackTrace();
      return null;
    }
  }

  /**
   * Writes out the MimeMultipartSigned object
   */
  public void writeTo(Object obj, String str, OutputStream os) 
    throws IOException
  {
    try
    {
      ((MimeMultipartSigned)obj).writeTo(os);
    }
    catch (MessagingException e)
    {
      throw new IOException(e.toString());
    }
  }

  public Object getTransferData(DataFlavor flavor, DataSource dataSource)
  {
    return null;
  }

  public DataFlavor[] getTransferDataFlavors()
  {
    return null;
  }
}
