//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.io.IOException;
import java.io.ByteArrayInputStream;

/**
 * Class for Alert messages
 *
 * @author Ming Yung
 */
final class Alert extends V3Message
{
  protected static final byte CLOSE_NOTIFY = 0x00;
  protected static final byte UNEXPECTED_MESSAGE = 0x0a;
  protected static final byte BAD_RECORD_MAC = 0x14;
  protected static final byte DECOMPRESSION_FAILURE = 0x1e;
  protected static final byte HANDSHAKE_FAILURE = 0x28;
  protected static final byte NO_CERTIFICATE = 0x29;
  protected static final byte BAD_CERTIFICATE = 0x2a;
  protected static final byte UNSUPPORTED_CERTIFICATE = 0x2b;
  protected static final byte CERTIFICATE_REVOKED = 0x2c;
  protected static final byte CERTIFICATE_EXPIRED = 0x2d;
  protected static final byte CERTIFICATE_UNKNOWN = 0x2e;
  protected static final byte ILLEGAL_PARAMETER = 0x2f;

  protected static final byte WARNING = 0x01;
  protected static final byte FATAL = 0x02;

  private byte level;
  private byte description;
  
  /**
   * Default constructor for an Alert message
   */
  protected Alert()
  {
    this.length = 2;
    this.contentType = SSLProtocolUnit.ALERT;
  }

  /**
   * Constructs an Alert message from a level and its description
   */
  protected Alert(byte level, byte description) 
  {
    this();

    this.level = level;
    this.description = description;
  }

  /**
   * Constructs an Alert message from an XDRInputStream
   */
  protected Alert(byte[] data) throws IOException
  {
    this();

    XDRInputStream is = 
      new XDRInputStream(new ByteArrayInputStream(data));

    this.level = is.readByte();
    this.description = is.readByte();

    if (Debug.debug >= Debug.DEBUG_MSG)
    {
      Debug.debug("  **** Alert ****");
      Debug.debug("level: " + level);
      Debug.debug("description: " + description);
    }
  }

  /**
   * Writes the data in this message out to the XDROutputStream
   */
  protected void write(XDROutputStream os) throws IOException
  {
    os.writeByte(this.level);
    os.writeByte(this.description);
  }
}
