//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.util.Vector;
import java.net.Socket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

import javax.net.SocketFactory;
import javax.net.ssl.SSLKeyException;

/**
 * An abstract SSLSocketFactory which does not require properties for
 * configuration.
 *
 * Subclassed by SSLSocketFactory which does need properties
 *
 * @author Ming Yung
 */
public abstract class BaseSSLSocketFactory 
  extends javax.net.ssl.SSLSocketFactory
{
  protected static BaseSSLSocketFactory instance = null;
  private SecureRandom rand = null;
  private Vector trustedCerts = null;
  private SessionCache cache = null;
  private PrivateKey privKey = null;
  private Vector clientCerts = null;
  private String[] enabledCipherSuites = null;

  protected BaseSSLSocketFactory() throws SSLKeyException
  {
    super();

    //!!! Caution. Trivial Seeding. For testing only
    rand = new SecureRandom(new byte[8]);
    this.cache = new SessionCache();
  }

  public String[] getDefaultCipherSuites()
  {
    return this.enabledCipherSuites;
  }

  public String[] getSupportedCipherSuites()
  {
    return CipherSuites.suiteName;
  }

  public Socket createSocket(InetAddress host, int port)
    throws IOException, UnknownHostException
  {
    return new SSLSocket(host, port, privKey, clientCerts, 
                         enabledCipherSuites, trustedCerts, cache, rand);
  }

  public Socket createSocket(InetAddress host, int port,
                             InetAddress clientHost, int clientPort)
    throws IOException, UnknownHostException
  {
    return new SSLSocket(host, port, clientHost, clientPort,
                         privKey, clientCerts, enabledCipherSuites,
                         trustedCerts, cache, rand);
  }

  public Socket createSocket(String host, int port)
    throws IOException
  {
    return new SSLSocket(host, port, privKey, clientCerts, 
                         enabledCipherSuites, trustedCerts, cache, rand);
  }

  public Socket createSocket(String host, int port, InetAddress clientHost, 
                             int clientPort)
    throws IOException
  {
    return new SSLSocket(host, port, clientHost, clientPort,
                         privKey, clientCerts, enabledCipherSuites,
                         trustedCerts, cache, rand);
  }

  //////////////////////////////////////////////////////////////////
  // methods not defined in javax.net.ssl.SSLSocketFactory
  //////////////////////////////////////////////////////////////////

  protected void initializeKeys() throws SSLKeyException {};

  public void setDefaultCipherSuites(String[] suites)
  {
    this.enabledCipherSuites = suites;
  }

  public void setClientPrivateKey(PrivateKey priv)
  {
    this.privKey = priv;
  }

  public void setClientCertificates(Vector certs)
  {
    this.clientCerts = certs;
  }

  public void setTrustedCertificates(Vector certs)
  {
    this.trustedCerts = certs;
  }

  SecureRandom getRandom()
  {
    return this.rand;
  }

  Vector getTrustedCertificates()
  {
    return this.trustedCerts;
  }

  SessionCache getSessionCache()
  {
    return this.cache;
  }
}
