//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.io.IOException;
import java.io.ByteArrayInputStream;

/**
 * A class for ChangeCipherSpec messages sent to a peer to indicate
 * the start of a new encryption regime
 *
 * @author Ming Yung
 */
final class ChangeCipherSpec extends V3Message
{
  private byte msg = 0x01;
  
  /**
   * Default constructor for a ChangeCipherSpec message
   */
  ChangeCipherSpec() 
  {
    this.length = 1;
    this.contentType = SSLProtocolUnit.CHANGE_CIPHER_SPEC;
  }

  /**
   * Constructs a ChangeCipherSpec message from an XDRInputStream
   */
  ChangeCipherSpec(byte[] data) throws IOException
  {
    this();

    XDRInputStream is 
      = new XDRInputStream(new ByteArrayInputStream(data));
    this.msg = is.readByte();

    if (Debug.debug >= Debug.DEBUG_MSG)
      Debug.debug("++ ChangeCipherSpec");
  }

  /**
   * Writes the data in this message to the XDROutputStream
   */
  protected void write(XDROutputStream os) throws IOException
  {
    os.writeByte(this.msg);
  }
}
