//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

/**
 * SSL version 3 cipher suites
 *
 * @author Ming Yung
 */
final class CipherSuites
{
  private static final int SSL_RSA_EXPORT_WITH_RC4_40_MD5 = 0;
  private static final int SSL_RSA_WITH_RC4_128_MD5 = 1;
  private static final int SSL_RSA_WITH_RC4_128_SHA = 2;
  private static final int SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = 3;
  private static final int SSL_RSA_WITH_IDEA_CBC_SHA = 4;
  private static final int SSL_RSA_EXPORT_WITH_DES40_CBC_SHA = 5;
  private static final int SSL_RSA_WITH_DES_CBC_SHA = 6;
  private static final int SSL_RSA_WITH_3DES_EDE_CBC_SHA = 7;
  private static final int SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = 8;
  private static final int SSL_DH_DSS_WITH_DES_CBC_SHA = 9;
  private static final int SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA = 10;
  private static final int SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = 11;
  private static final int SSL_DH_RSA_WITH_DES_CBC_SHA = 12;
  private static final int SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA = 13;
  private static final int SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = 14;
  private static final int SSL_DHE_DSS_WITH_DES_CBC_SHA = 15;
  private static final int SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 16;
  private static final int SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = 17;
  private static final int SSL_DHE_RSA_WITH_DES_CBC_SHA = 18;
  private static final int SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 19;

  protected static final byte[][] suiteType 
    = {{0x00, 0x03}, {0x00, 0x04}, {0x00, 0x05}, {0x00, 0x06},
       {0x00, 0x07}, {0x00, 0x08}, {0x00, 0x09}, {0x00, 0x0a},
       {0x00, 0x0b}, {0x00, 0x0c}, {0x00, 0x0d}, {0x00, 0x0e},
       {0x00, 0x0f}, {0x00, 0x10}, {0x00, 0x11}, {0x00, 0x12},
       {0x00, 0x13}, {0x00, 0x14}, {0x00, 0x15}, {0x00, 0x16}};

  protected static final String[] suiteName = 
    {"SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_WITH_RC4_128_MD5",
     "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5",
     "SSL_RSA_WITH_IDEA_CBC_SHA", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA",
     "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA",
     "SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_DSS_WITH_DES_CBC_SHA",
     "SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA", 
     "SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA",
     "SSL_DH_RSA_WITH_DES_CBC_SHA", "SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA",
     "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA",
     "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", 
     "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA",
     "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA"};

  protected static final boolean[] isExportable
    = {true, false, false, true, false, true, false, false,
       true, false, false, true, false, false,
       true, false, false, true, false, false};

  protected static final String[] keyXAlgName
    = {"RSA_EXP", "RSA", "RSA", "RSA_EXP", "RSA", "RSA_EXP", "RSA", "RSA",
       "DH_EXP", "DH", "DH", "DH_EXP", "DH", "DH", 
       "DHE_DSS_EXP", "DHE_DSS", "DHE_DSS", "DHE_RSA_EXP", "DHE_RSA", 
       "DHE_RSA"};

  protected static final String[] cipherAlgName
    = {"RC4", "RC4", "RC4", "RC2", "IDEA", "DES", "DES", "DESede",
       "DES", "DES", "DESede", "DES", "DES", "DESede",
       "DES", "DES", "DESede", "DES", "DES", "DESede"};

  protected static final boolean[] isBlockCipher
    = {false, false, false, true, true, true, true, true,
       true, true, true, true, true, true,
       true, true, true, true, true, true};

  protected static final int[] blockSize
    = {0, 0, 0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};

  protected static final int[] keyLength
    = {5, 16, 16, 5, 16, 5, 8, 24, 5, 8, 24, 5, 8, 24, 5, 8, 24, 5, 8, 24};

  protected static final int[] expKeyLength
    = {16, 16, 16, 16, 16, 8, 8, 24, 8, 8, 24, 8, 8, 24, 8, 8, 24, 8, 8, 24};

  protected static final String[] macAlgName 
    = {"MD5", "MD5", "SHA", "MD5", "SHA", "SHA", "SHA", "SHA",
       "SHA", "SHA", "SHA", "SHA", "SHA", "SHA",
       "SHA", "SHA", "SHA", "SHA", "SHA", "SHA"};

  protected static final int[] macSize 
    = {16, 16, 20, 16, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
       20, 20, 20, 20, 20, 20};

  protected static final int[] padSize 
    = {48, 48, 40, 48, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
       40, 40, 40, 40, 40, 40};

  protected static final int getIndex(byte[] type)
  {
    return (type[1] - 3);
  }

  protected static String getSuiteName(byte[] type)
  {
    int ind = getIndex(type);
    if (ind < 0 || ind > 19) 
      return null;
    else
      return suiteName[getIndex(type)];
  }

  protected static String getKeyXAlgName(byte[] type)
  {
    return keyXAlgName[getIndex(type)];
  }
}
