//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.util.Iterator;
import java.util.Vector;
import java.util.Calendar;
import java.io.IOException;

import javax.net.ssl.SSLHandshakeException;

/**
 * A class for HelloRequest Handshake mesages sent by a server to a client to
 * initiate a new handshake after at least one has successfully completed.
 *
 * @author Ming Yung
 */
final class HelloRequest extends HandShake
{
  /**
   * Constructs a HelloRequest from an XDRInputStream with a 
   * callback to a controlling ServerHandShaker
   */
  protected HelloRequest(HandShaker handShaker, byte[] data) 
    throws IOException
  {
    super(handShaker, data);

    if (Debug.debug >= Debug.DEBUG_MSG)
      Debug.debug("++ HelloRequest");
  }

  /**
   * Constructs a HelloRequest message with a callback to a ServerHandShaker
   */
  protected HelloRequest(ServerHandShaker handShaker)
  {
    this.handShaker = handShaker;
    this.msgType = HELLO_REQUEST;
    
    this.bodyLength = 0; 
  }

  /**
   * Reads the body of this ClientHello message from the XDRInputStream
   *
   * <p>The controlling ServerHandShaker upon receipt of this message
   *    sets its client random, sessionID, and ciphersuite
   */
  protected void readBody(XDRInputStream is) 
    throws IOException
  {
  }

  /**
   * Writes the body of this ClientHello message to the XDROutputStream
   */
  protected void writeBody(XDROutputStream os) throws IOException
  {
  }
}
