//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.io.OutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

/**
 * An output stream for SSLProtocolUnit objects
 *
 * @author Ming YUng
 */
final class ProtocolUnitOutputStream extends XDROutputStream
{
  private SSLContext ctx;

  ProtocolUnitOutputStream(SSLContext ctx, OutputStream os)
  {
    super(os);
    this.ctx = ctx;
  }

  synchronized void writeProtocolUnit(SSLProtocolUnit pu)
    throws IOException
  {
    byte[] fragment = pu.getBytes();

    if (pu instanceof HandShake)
       ctx.getHandShaker().updateHashes(fragment);

    fragment = ctx.macAndEncrypt(pu.getContentType(), fragment);

    super.writeByte(pu.getContentType());
    super.write(ctx.getHandShaker().getProtocolVersion());
    super.writeShort(fragment.length);
    super.write(fragment);
    flush();

    if (Debug.debug >= Debug.DEBUG_RECORD)
      Debug.debug("Sent message: " + pu);
  }
}
