//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.io.IOException;

import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

final class RSAClientKeyExchange extends ClientKeyExchange
{
  /**
   * Constructs a ClientKeyExchange message from an XDRInputStream with
   * a callback to the controlling ServerHandShaker
   */
  protected RSAClientKeyExchange(ServerHandShaker handShaker, byte[] data) 
    throws IOException
  {
    super(handShaker, data);

    if (Debug.debug >= Debug.DEBUG_MSG)
      Debug.debug("++ RSAClientKeyExchange");
  }

  /**
   * Constructs a ClientKeyExchange message with a callback to the
   * controlling ClientHandShaker
   */
  protected RSAClientKeyExchange(ClientHandShaker handShaker)
    throws IOException
  {
    this.handShaker = handShaker;
    this.msgType = CLIENT_KEY_EXCHANGE;

    this.exchangeKeys = handShaker.getEncryptedPreMasterSecret();
    this.bodyLength = this.exchangeKeys.length;
  }

  /**
   * Reads the body of this ClientKeyExchange message from an XDRInputStream
   */
  protected void readBody(XDRInputStream is) 
    throws IOException
  {
    if (this.handShaker.isExportable())
      this.exchangeKeys = is.readBytes(64);
    else
      this.exchangeKeys 
        = is.readBytes((handShaker.getPubKeyBitLength()+4)/8);

    ((ServerHandShaker)handShaker).setMasterSecret(exchangeKeys);
  }
}
