//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.io.IOException;
import java.io.ByteArrayOutputStream;

import java.security.interfaces.RSAPublicKey;

import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

final class RSAServerKeyExchange extends ServerKeyExchange
{
  /**
   * Constructs a ServerKeyExchange message from an XDRInputStream with
   * a callback to the controlling ClientHandShaker
   */
  protected RSAServerKeyExchange(ClientHandShaker handShaker, byte[] data) 
    throws IOException
  {
    super(handShaker, data);

    if (Debug.debug >= Debug.DEBUG_MSG)
      Debug.debug("++ RSAServerKeyExchange");
  }

  protected RSAServerKeyExchange(ServerHandShaker handShaker, int keyLength)
    throws IOException
  {
    super(handShaker, keyLength);
  }

  protected void generateParamsAndSig(XDROutputStream out)
    throws IOException
  {
    RSAPublicKey pub 
      = ((ServerHandShaker)handShaker).generateTempRSAPubKey();

    byte[] modulus = pub.getModulus().toByteArray();
    byte[] exponent = pub.getPublicExponent().toByteArray();

    out.writeVector(2, modulus);
    out.writeVector(2, exponent); 
  }

  protected void verifyParamsSig(XDRInputStream is, XDROutputStream out) 
    throws IOException
  {
    byte[] modulus = is.readVector(2);
    byte[] exponent = is.readVector(2);

    ((ClientHandShaker)handShaker).setServerEncryptionKey(modulus, exponent); 
    out.writeVector(2, modulus);
    out.writeVector(2, exponent); 
  }
}
