//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.io.IOException;

/**
 * An interface for SSL Protocl Units
 *
 * Implemented by Alert, ApplicationData, HandShake & ChangeCipherSpec
 *
 * @author Ming Yung
 */
public interface SSLProtocolUnit
{
  public static final byte CHANGE_CIPHER_SPEC = 0x14;
  public static final byte ALERT = 0x15;
  public static final byte HANDSHAKE = 0x16;
  public static final byte APPLICATION_DATA = 0x17;

  public byte getContentType();

  public int getLength();

  public byte[] getBytes() throws IOException;
}
