//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.util.Vector;
import java.util.Calendar;
import java.io.*;

import javax.net.ssl.SSLHandshakeException;

/**
 * A class for a server to process SSL v2 ClientHello messages from 
 * a client (still the default for the latest COTS browsers)
 *
 * @author Ming Yung
 */
final class V2ClientHello implements SSLProtocolUnit
{
  private byte[] random;
  private byte[] version;
  private byte[] sessionId;
  private Vector cipherSuites;
  private ServerHandShaker handShaker;
  private byte msgType;
  private byte[] contents;

  V2ClientHello(ServerHandShaker handShaker, byte contents[]) 
    throws IOException
  {
    this.handShaker = handShaker;
    this.contents = contents;
    
    XDRInputStream is
      = new XDRInputStream(
          new BufferedInputStream(new ByteArrayInputStream(contents)));

    readBody(is);
    handShaker.updateHashes(contents);

    if (Debug.debug >= Debug.DEBUG_MSG)
      Debug.debug("++V2ClientHello");
  }

  public byte[] getBytes() throws IOException
  {
    return contents;
  }

  public int getLength()
  {
    //not used
    return contents.length;
  }

  public byte getContentType()
  {
    return SSLProtocolUnit.HANDSHAKE;
  }

  protected void readBody(XDRInputStream is) 
    throws IOException
  {
    this.msgType = is.readByte();

    this.version = is.readBytes(2);

    int numSuites = is.readShort()/3;
    int sessionIdLength = is.readShort();
    int challengeLength = is.readShort();

    this.cipherSuites = new Vector();
    for (int i=0; i<numSuites; i++)
    {
      this.cipherSuites.addElement(is.readBytes(3));
    }

    this.sessionId = is.readBytes(sessionIdLength);
    ((ServerHandShaker)handShaker).setSessionId(this.sessionId);

    this.random =  is.readBytes(challengeLength);
    byte[] clientHelloRandom = new byte[32];
    System.arraycopy(random, 0, clientHelloRandom, 
                     32 - random.length, random.length);

    this.handShaker.setClientHelloRandom(clientHelloRandom);

    //should check to see if cipherSuite is supported
    Vector temp = new Vector();
    temp.addElement(CipherSuites.suiteType[0]);
    ((ServerHandShaker)handShaker).setCipherSuite(temp);
  }
}
