//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.io.IOException;
import java.io.ByteArrayOutputStream;

/**
 * An abstract class for SSL v3 Handshake messages
 *
 * @author Ming Yung
 */
abstract class V3Message implements SSLProtocolUnit
{
  protected byte[] data;
  protected int length;
  protected byte contentType;

  /**
   * Writes this message out to the XDROutputStream
   */
  protected abstract void write(XDROutputStream os) throws IOException;

  /**
   * Returns the data in this message
   */
  public byte[] getBytes() throws IOException
  {
    ByteArrayOutputStream bos = new ByteArrayOutputStream();
    XDROutputStream sos = new XDROutputStream(bos);
    write(sos);
    sos.flush();
    return bos.toByteArray();
  }

  /**
   * Returns the length of the data in this message
   */
  public int getLength()
  {
    return this.length;
  }

  /**
   * Returns the ContentType of the data in this message
   */
  public byte getContentType()
  {
    return this.contentType;
  }
}
