//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.FilterInputStream;
import java.io.DataInputStream;

/**
 * An input stream for base SSL data types defined at the record layer
 *
 * (XDR is an inappropriate name. Will be changed in a subsequent version)
 *
 * @author Ming Yung
 */
class XDRInputStream extends DataInputStream
{
  XDRInputStream(InputStream is)
  {
    super(is);
  }

  int read3Bytes() throws IOException
  {
    byte retval[] = new byte[3];
    if (read(retval) == -1)
      return -1;

    return (int)(((retval[0] & 0xff) << 16) | 
                 ((retval[1] & 0xff) << 8) | 
                 (retval[2] & 0xff));
  }

  byte[] readBytes(int n) throws IOException
  {
    if (n==0) return new byte[0];

    byte retval[] = new byte[n];
    readFully(retval);

    return retval;
  }

  byte[] readVector(int lengthOctets) throws IOException
  {
    byte retval[];

    switch (lengthOctets)
    {
      case 1: 
        retval = new byte[readByte()]; 
        break;

      case 2: 
        retval = new byte[readShort()];
        break;

      case 3: 
        retval = new byte[read3Bytes()];
        break;

      default: 
        retval = new byte[readInt()];
    }

    if (retval.length == 0) return retval;
    readFully(retval);

    return retval;
  }
}
