//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.x509;

import java.util.Vector;
import java.util.Set;
import java.util.HashSet;
import com.dstc.security.x509.extns.*;
import com.dstc.security.provider.OID;
import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Boolean;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Asn1Exception;

/**
 * <p>A class representing the x.509 ASN.1 structure Extension.
 * 
 * <pre>
 *   Extension  ::=  SEQUENCE  {
 *       extnID      OBJECT IDENTIFIER,
 *       critical    BOOLEAN DEFAULT FALSE,
 *       extnValue   OCTET STRING  }
 * </pre>
 */
public class Extension extends Sequence
{
  protected String extnID;
  protected boolean critical = false;
  protected byte[] extnValue; //OctetString
  protected byte[] value;

  /**
   * Default constructor
   */
  public Extension() {}

  /**
   * Constructs an Extension from a DER encoding
   */
  public Extension(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);

    int i = 0;
    this.extnID = ((Oid)components.elementAt(i++)).getOid();

    try
    {
      this.critical = ((Boolean)components.elementAt(i)).getTruth();
      i++;
    }
    catch (ClassCastException e)
    {
      //Ignore
    }

    this.extnValue = ((OctetString)components.elementAt(i)).encode();
    this.value = ((OctetString)components.elementAt(i)).getBytes();
  }

  public boolean isCritical()
  {
    return this.critical;
  }

  public String getExtnID()
  {
    return this.extnID;
  }

  public byte[] getExtnValue()
  {
    return extnValue;
  }

  public String toString()
  {
    StringBuffer sb = new StringBuffer("Unknown Extension:\n");
    sb.append("  OID:" + extnID + "\n");
    return sb.toString();
  }

  protected static String printHex(byte bytes[]) 
  {
    StringBuffer sb = new StringBuffer();
    for (int i=0; i<bytes.length; i++) 
    {
      sb.append(toHexDigit(bytes[i]));
    }
    sb.append("\n");
    return sb.toString();
  }

  private static String toHexDigit(byte x)
  {
    char ret[] = new char[2];
    char c = (char) ((x >> 4) & 0xf);
    if (c > 9)
    {
      c = (char) ((c - 10) + 'a');
    }
    else
    {
      c = (char) (c + '0');
    }
    ret[0] = c;

    c = (char) (x & 0xf);
    if (c > 9)
    {
      c = (char)((c - 10) + 'a');
    }
    else
    {
      c = (char)(c + '0');
    }
    ret[1] = c;
    return new String(ret);
  }
}
