//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.IA5String;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Primitive;
import com.dstc.security.asn1.Sequence;

/**
 * <p>A class representing x.509 ASN.1 structure GeneralName.
 * 
 * <pre>
 *      GeneralName ::= CHOICE {
 *           otherName                       [0]     OtherName,
 *           rfc822Name                      [1]     IA5String,
 *           dNSName                         [2]     IA5String,
 *           x400Address                     [3]     ORAddress,
 *           directoryName                   [4]     Name,
 *           ediPartyName                    [5]     EDIPartyName,
 *           uniformResourceIdentifier       [6]     IA5String,
 *           iPAddress                       [7]     OCTET STRING,
 *           registeredID                    [8]     OBJECT IDENTIFIER}
 *
 * </pre>
 */

public class GeneralName extends Primitive
{
  public static final int RFC822NAME = 1;
  public static final int DNSNAME = 2;
  private int type;
  private String name;
  
  public GeneralName(byte[] encoded) throws Asn1Exception
  {
    doDecode(encoded);
    this.type = getTagNumber();
    this.name = new String(contents);
  }

  public GeneralName(int type, String name)
  {
    this(tag(type), orig(type, name));

    this.type = type;
    this.name = name;
  }

  private GeneralName(byte tag, Asn1 orig)
  {
    super(tag, orig);
  }

  private static final byte tag(int type)
  {
    return (byte)(type | Asn1.TAG_CLASS_CONTEXT);
  }

  private static final Asn1 orig(int type, String name)
  {
    switch (type)
    {
      case (1):
      case (2):
      case (6):
        return new IA5String(name);

      default:
        return null;
    }
  }

  /**
   * Returns the type of this GeneralName
   */
  public int getType()
  {
    return this.type;
  }
  
  /**
   * Return this GeneralName as a form of String
   */
  public String getName()
  {
    return this.name;
  }
} 
