//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.x509;

import java.util.Collection;
import java.io.InputStream;
import java.io.IOException;
import java.security.Provider;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;

import com.dstc.security.provider.OID;
import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.cms.v1.ContentInfo;
import com.dstc.security.cms.v1.SignedData;

public class X509CertificateFactory extends CertificateFactorySpi
{
  public Certificate engineGenerateCertificate(InputStream inStream)
      throws CertificateException
  {
    inStream.mark(30);

    try
    {
      //DER encoding first
      byte[] encoded = new byte[inStream.available()];
      inStream.read(encoded);

      return new X509CertImpl(encoded);
    }
    catch (Exception e)
    {
      //Ignore and try something else
    }

    try
    {
      //Base64 encoding next
      inStream.reset();
      Base64InputStream bis 
        = new Base64InputStream(inStream,
                                "-----BEGIN CERTIFICATE-----",
                                "-----END CERTIFICATE-----");
      byte encoded[] = new byte[bis.available()];
      bis.read(encoded);

      return new X509CertImpl(encoded);
    }
    catch (Exception e)
    {
      e.printStackTrace();
      throw new CertificateException("Error parsing certificate"); 
    }
  }

  public Collection engineGenerateCertificates(InputStream inStream)
      throws CertificateException
  {
    try
    {
      byte[] encoded = new byte[inStream.available()];
      inStream.read(encoded);
      ContentInfo contentInfo = new ContentInfo(encoded);

      if (!contentInfo.getContentType().equals(OID.id_signedData))
        throw new CertificateException("Not a PKCS#7 SignedData");

      SignedData signedData 
        = new SignedData(contentInfo.getContent().encode());

      return signedData.getCertificates();
    }
    catch (IOException e)
    {
      throw new CertificateException(e.toString());
    }
    catch (Asn1Exception e)
    {
      throw new CertificateException(e.toString());
    }
  }

  public CRL engineGenerateCRL(InputStream inStream)
      throws CRLException
  {
    try
    {
      byte[] encoded = new byte[1000];
      inStream.read(encoded);
      return new X509CRLImpl(encoded);
    }
    catch (IOException e)
    {
      throw new CRLException(e.toString()); 
    }
    catch (Asn1Exception e)
    {
      throw new CRLException(e.toString()); 
    }
  }

  public Collection engineGenerateCRLs(InputStream inStream)
      throws CRLException
  {
    try
    {
      byte[] encoded = new byte[2000];
      inStream.read(encoded);
      ContentInfo contentInfo = new ContentInfo(encoded);

      if (!contentInfo.getContentType().equals(OID.id_signedData))
        throw new CRLException("Not a PKCS#7 SignedData");

      SignedData signedData 
        = new SignedData(contentInfo.getContent().encode());

      return signedData.getCRLs();
    }
    catch (IOException e)
    {
      throw new CRLException(e.toString());
    }
    catch (Asn1Exception e)
    {
      throw new CRLException(e.toString());
    }
  }
}
