//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package javax.crypto.spec;

import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;

/**
 * <p>This class specifies the set of parameters used with the 
 * Diffie-Hellman algorithm, as specified in PKCS #3: 
 * Diffie-Hellman Key-Agreement Standard. 
 *
 * <p>A central authority generates parameters and gives them to 
 * the two entities seeking to generate a secret key. 
 * The parameters are a prime p, a base g, and optionally the length 
 * in bits of the private value, l. 
 *
 * <p>It is possible that more than one instance of parameters 
 * may be generated by a given central authority, and that 
 * there may be more than one central authority. Indeed, each 
 * individual may be its own central authority, with different 
 * entities having different parameters. 
 *
 * @see java.crypto.KeyAgreement
 * @see java.security.AlgorithParameters
 * @see java.security.spec.AlgorithmParameterSpec
 *
 * @version 0.1, 97/11/26
 * @author Ming Yung
 */
public class DHParameterSpec implements AlgorithmParameterSpec
{
  private BigInteger p, g;
  private int l;

  /**
   * Specifies the Diffie-Hellman parameters, using a 
   * prime modulus p and a base generator g.
   * 
   * @param p the prime modulus
   * @param g the base generator
   */
  public DHParameterSpec(BigInteger p, BigInteger g)
  {
    this.p = p;
    this.g = g;
  }

  /**
   * Specifies the Diffie-Hellman parameters, using a 
   * prime modulus p, a base generator g, and the size in bits, l, 
   * of the random exponent (private value).
   *
   * @param p the prime modulus
   * @param g the base generator
   * @param l the size in bits of the random exponent (private value)
   */
  public DHParameterSpec(BigInteger p, BigInteger g, int l)
  {
    this.p = p;
    this.g = g;
    this.l = l;
  }

  /**
   * Returns the prime modulus p.
   *
   * @return the prime modulus p.
   */
  public BigInteger getP()
  {
    return this.p;
  }

  /**
   * Returns the base generator g.
   *
   * @return the base generator g.
   */
  public BigInteger getG()
  {
    return this.g;
  }

  /**
   * Returns the size in bits, l, of the random exponent (private value). 
   *
   * @return the size in bits, l, of the random exponent (private value), 
   * or 0 if this size has not been set
   */
  public int getL()
  {
    return this.l;
  }
}


