//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package javax.net.ssl;

import java.util.EventObject;
import java.security.cert.X509Certificate;

/**
 * <p> This event indicates that an SSL handshake completed on a given SSL
 * connection. All of the core information about that handshake's result
 * is captured through an "SSLSession" object. As a convenience, this
 * event class provides direct access to to some important session
 * attributes.
 *
 * <p> The source of this event is the SSLSocket on which handshaking just
 * completed.
 *
 * @version 0.98, 98/09/10
 * @author Ming Yung
 *
 */

public class HandshakeCompletedEvent extends EventObject 
{
  private SSLSession session;
  private SSLSocket socket;

  /**
   * Constructs a new HandshakeCompletedEvent.
   *
   * @param sock  the SSLSocket acting as the source of the event
   * @param s  the SSLSession this event is associated with
   */
  public HandshakeCompletedEvent(SSLSocket sock, SSLSession s)
  {
    super(sock);
    this.socket = sock;
    this.session = s;
  }

  /**
   * Returns the session which was produced by the handshake.
   */
  public SSLSession getSession()
  {
    return this.session;
  }

  /**
   * Returns the cipher suite in use by the session which was produced by
   * the handshake.
   */
  public String getCipherSuite()
  {
    return this.session.getCipherSuite();
  }

  /**
   * Returns the identity of the peer which was identified as part of
   * defining the session.
   */
  public X509Certificate[] getPeerCertificateChain() 
    throws SSLPeerUnverifiedException
  {
    return this.session.getPeerCertificateChain();
  }

  /**
   * Returns the socket which is the source of this event. (This is a
   * convenience function, to let applications write code without
   * type casts.)
   */
  public SSLSocket getSocket()
  {
    return this.socket;
  }
}
