//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package javax.net.ssl;

import javax.net.ServerSocketFactory;

/**
 * <p> This class creates SSL server sockets.
 *
 * @version 0.98, 98/09/10
 * @author Ming Yung
 *
 */

public abstract class SSLServerSocketFactory extends ServerSocketFactory
{
  /**
   * Constructor is used only by subclasses.
   */
  protected SSLServerSocketFactory()
  {
  }

  /**
   * Returns the default SSL server socket factory.
   */
  public static ServerSocketFactory getDefault()
  {
    return com.dstc.security.ssl.SSLServerSocketFactory.getDefault();
  }

  /**
   * Returns the list of cipher suites which are enabled by default. Unless
   * a different list is enabled, handshaking on an SSL connection
   * will use one of these cipher suites. The minimum quality of
   * service for these defaults requires confidentiality protection
   * and server authentication.
   *
   * @return array of the cipher suites enabled by default
   */
  public abstract String[] getDefaultCipherSuites();

  /**
   * Returns the names of the cipher suites which could be enabled for use
   * on an SSL connection created by this factory. Normally, only a
   * subset of these will actually be enabled by default, since this
   * list may include cipher suites which do not meet quality of
   * service requirements for those defaults. Such cipher suites are
   * useful in specialized applications.
   *
   * @return an array of cipher suite names
   */
  public abstract String[] getSupportedCipherSuites();
}
