//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package javax.net.ssl;

import java.util.EventObject;

/**
 * <p> This event is communicated to a SSLSessionBindingListener whenever
 * such a listener is bound to or unbound from a SSLSession value. The
 * event's source is the SSLSession to which the listener is being bound,
 * or from which the listener is being unbound.
 *
 * @version 0.98, 98/09/10
 * @author Ming Yung
 *
 */

public class SSLSessionBindingEvent extends EventObject 
{
  private SSLSession session;
  private String name;

  /**
   * Constructs a new SSLSessionBindingEvent
   *
   * @param session  the SSLSession acting as the source of the event
   */
  public SSLSessionBindingEvent(SSLSession session, String name)
  {
    super(session);
    this.session = session;
    this.name = name;
  }

  /**
   * Returns the name to which the object is being bound, or the name from
   * which the object is being unbound.
   */
  public String getName()
  {
    return this.name;
  }

  /**
   * Returns the SSLSession into which the listener is being bound or from
   * which the listener is being unbound.
   */
  public SSLSession getSession()
  {
    return this.session;
  }
}
