//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package javax.net.ssl;

import java.util.EventListener;

/**
 * <p> This is interface is implemented by objects which want to know when
 * they are being bound or unbound from a SSLSession. When either event
 * occurs, the event is communicated through a SSLSessionBindingEvent
 * identifying the session into which the object is being bound, or from
 * which the object is being unbound.
 *
 * @version 0.98, 98/09/10
 * @author Ming Yung
 *
 */

public interface SSLSessionBindingListener extends EventListener 
{
  /**
   * This is called to notify the listener that it is being bound into an
   * SSLSession.
   *
   * @param event  the event identifying the SSLSession into which
   * the listener is being bound.
   */
  public abstract void valueBound(SSLSessionBindingEvent event);

  /**
   * This is called to notify the listener that it is being unbound from a
   * SSLSession.
   *
   * @param event  the event identifying the SSLSession into which
   * the listener is being unbound.
   */
  public abstract void valueUnbound(SSLSessionBindingEvent event);
}
