//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package jcsi.servlet;

import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

import java.io.*;
import java.util.Properties;
import java.util.Calendar;
import java.util.Hashtable;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.BasicAttribute;

import java.math.BigInteger;
import java.security.*;
import java.security.spec.*;
import java.security.cert.*;
import com.dstc.security.provider.OID;
import com.dstc.security.x509.Attribute;
import com.dstc.security.asn1.*;
import com.dstc.security.pki.*;
import com.dstc.security.x509.extns.*;
import com.dstc.security.x509.Base64InputStream;

/**
 * A servlet which returns a user certificate from a base64-encoded PKCS#10
 * certification request generated by the Microsft Enrollment Control 
 *
 * @version 0.98, 99/02/15
 * @author Ming Yung
 */
public class MicrosoftServlet extends OnlineCAServlet 
{
  protected X509Certificate processCertRequest(HttpServletRequest req, 
                                               HttpServletResponse res)
    throws ServletException, IOException
  {
    //set the "content type" header of the response
    res.setContentType("application/x-pkcs7-certreqresp");

    X509Certificate cert = processPKCS10(req);

    res.getOutputStream().write(caTool.makeCertChain(cert).encode());
    res.getOutputStream().flush();
    res.getOutputStream().close();

    return cert;
  }

  private X509Certificate processPKCS10(HttpServletRequest req)
    throws ServletException, IOException
  {
    try 
    {
      //Read the base64-encoded PKCS#10 certification request

      InputStream b64is = 
        new ByteArrayInputStream(req.getParameter("Request").getBytes());

      InputStream is = new Base64InputStream(b64is, null, null);
      byte encoded[] = new byte[is.available()];
      is.read(encoded);

      String dn 
        = CertRequestFactory.getRequest("PKCS10", encoded).getSubjectName();
      this.entryName = dn.substring(0, dn.indexOf("Email") - 2);

      caTool.processPKCS10(encoded);

      BigInteger serialNumber =
        BigInteger.valueOf(Calendar.getInstance().getTime().getTime());

      //Set the extensions

      caTool.addExtension(new NetscapeCertType(true, 
        (byte)(NetscapeCertType.SMIME | NetscapeCertType.SSL_CLIENT)));

      //Generate the cert

      X509Certificate cert 
        = (X509Certificate) caTool.generateCertificate(2, serialNumber);
      return cert;
    } 
    catch(Exception e) 
    {
      e.printStackTrace();
      return null;
    }
  }
}
