package jcsi;

import java.rmi.*;
import java.rmi.server.*;

public class EchoServer extends UnicastRemoteObject
  implements Echo
{
  public static void main(String[] args)
  {
    try
    {
      if (System.getSecurityManager() == null)
        System.setSecurityManager(new RMISecurityManager());

      EchoServer impl = new EchoServer();
      Naming.rebind("/EchoServer", impl);

      System.out.println("Echo server is ready");

    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

  public EchoServer() throws RemoteException
  {
    super(0, new SSLClientSocketFactory(), new SSLServerSocketFactory());
  }

  public String echo(String in) throws RemoteException
  {
    System.out.println("Received: " + in);
    return in;
  }
}
