//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package jcsi;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.OutputStream;
import java.net.Socket;

import java.security.cert.X509Certificate;

import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;

public class FoxTrot
{
  public static void main(String args[])
  {
    FoxTrot cl = new FoxTrot(args[0], Integer.parseInt(args[1]));
  }

  public FoxTrot(String host, int port)
  {
    try
    {
      SocketFactory fact = javax.net.ssl.SSLSocketFactory.getDefault();
      Socket sock = fact.createSocket(host, port);

      System.out.println("");

      OutputStream os = sock.getOutputStream();
      InputStream is = sock.getInputStream();

      String req = "GET /jobs/default.htm HTTP/1.1\r\n" +
                   "Host: " + host + ":" + port + "\r\n" +
                   "Connection: Keep-Alive\r\n" +
                   "User-Agent: Java SSL Client\r\n" +
                   "Content-Length: 0\r\n" +
                   "\r\n";

      WriterThread writer = new WriterThread(os, req);
      ReaderThread reader = new ReaderThread(is);
      writer.start();
      reader.start();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

  private class ReaderThread extends Thread
  {
    private BufferedReader in ;
    private static final int READ_INTERVAL = 100;

    ReaderThread(InputStream is)
    {
      this.in = new BufferedReader(new InputStreamReader(is));
    }

    public void run()
    {
      try
      {
        while (true)
        {
          String next = in.readLine();

          if (next == null) break;

          System.out.println(next);
        }
      }
      catch (IOException e)
      {
        e.printStackTrace();
      }
    }
  }

  private class WriterThread extends Thread
  {
    private byte[] reqBytes;
    private OutputStream os;
    private static final int INTERVAL = 5000;

    WriterThread(OutputStream os, String req)
    {
      this.os = os;
      this.reqBytes = req.getBytes();
    }
      
    public void run()
    {
      try
      {
        while (true)
        {
          os.write(reqBytes);
          os.flush();

          Thread.sleep(INTERVAL);
        }
      }
      catch (InterruptedException e)
      {
        //wake up
      }
      catch (IOException e)
      {
        e.printStackTrace();
      }
    }
  }
}
