//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package jcsi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.net.ServerSocket;
import java.net.Socket;

import java.security.cert.X509Certificate;

import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLPeerUnverifiedException;

public class SSLServer implements Runnable
{
  private static final boolean debug = true;
  private int port;
  private ServerSocketFactory fact;

  public static void main(String args[])
  {
    SSLServer server = new SSLServer(Integer.parseInt(args[0]));
    server.run();
  }

  public SSLServer(int port) 
  {
    this.port = port;
    fact = javax.net.ssl.SSLServerSocketFactory.getDefault();
  }

  public void run()
  {
    if (fact == null)
      return;

    ServerSocket serverSock = null;

    try
    {
      serverSock = fact.createServerSocket(port);
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }

    do
    {
      try
      {
        Socket sock = serverSock.accept();

        OutputStream out = sock.getOutputStream();
        InputStream is = sock.getInputStream();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
  
        while (true)
        {
          String line = in.readLine();
          System.out.println(line);

          if (line.equals("")) break;
        }

        StringBuffer sb = new StringBuffer();
        sb.append("<HTML><HEAD>\n");
        sb.append("<TITLE>Java SSL Server</TITLE>\n");
        sb.append("</HEAD><BODY>\n");
        sb.append("<H1>Welcome!</H1>\n");
        sb.append("You have successfully accessed the DSTC Java");
        sb.append("SSL test Web Server.<P>\n");
        sb.append("The negotiated cipher suite is ");
        sb.append(((SSLSocket)sock).getSession().getCipherSuite() + ".<P>\n");
        sb.append("</BODY></HTML>\n");
  
        out.write(sb.toString().getBytes());
        out.flush();

        try
        {
          System.out.println("\n********************");
          X509Certificate[] certs
            = ((SSLSocket)sock).getSession().getPeerCertificateChain();
          for (int i=0; i<certs.length; i++)
          {
            System.out.println(certs[i].toString());
          }
          System.out.println("********************");
        }
        catch (SSLPeerUnverifiedException e)
        {
          System.out.println(e.getMessage());
        }

        in.close();
        out.close();
        sock.close();

        if (debug)
          System.out.println("socket closed");
      }
      catch (Exception e)
      {
        e.printStackTrace();
      }
    }
    while (true);
  }
}
