/* $Id: fish.h,v 1.7 1999/06/22 21:49:37 levitte Exp $ */

#ifndef FISH_H
#define FISH_H

#define PILOTSSH_VERSTR_FMT "SSH-1.5-%s\n"
#define AUTHFILE_ID_STRING "SSH PRIVATE KEY FILE FORMAT 1.1\n"

extern char *input_device;
extern char *output_device;
extern unsigned long done_ef;

#define VERBOSE_M_INFO		0x01
#define VERBOSE_M_STATE		0x02
#define VERBOSE_M_IO		0x04
#define VERBOSE_M_LONGINFO	0x08
#define VERBOSE_M_PACKET	0x10
#define VERBOSE_M_PASSWORD	0x80

#define VERBOSE_M_BRIEF		VERBOSE_M_INFO|VERBOSE_M_STATE
#define VERBOSE_M_FULL		VERBOSE_M_BRIEF|VERBOSE_M_IO|VERBOSE_M_LONGINFO|VERBOSE_M_PACKET

extern unsigned char verbose;

#define on_verbosity(__v,__fc) do { if (verbose & (__v)) { __fc; } } while(0)
#define on_info(__fc) on_verbosity(VERBOSE_M_INFO,__fc)
#define on_state(__fc) on_verbosity(VERBOSE_M_STATE,__fc)
#define on_io(__fc) on_verbosity(VERBOSE_M_IO,__fc)
#define on_longinfo(__fc) on_verbosity(VERBOSE_M_LONGINFO,__fc)
#define on_packet(__fc) on_verbosity(VERBOSE_M_PACKET,__fc)
#define on_password(__fc) on_verbosity(VERBOSE_M_PASSWORD,__fc)
#define on_brief(__fc) on_verbosity(VERBOSE_M_BRIEF,__fc)
#define on_full(__fc) on_verbosity(VERBOSE_M_FULL,__fc)

#endif

/* Emacs local variables

Local variables:
eval: (set-c-style "BSD")
end:

*/
