/* $Id: gnu_extras.h,v 1.3 1999/06/25 06:15:19 levitte Exp $ */

#ifdef __GNUC__
/* Diverse declarations that GNU C do not have today... */

#ifndef GNU_EXTRAS_H
#define GNU_EXTRAS_H

/*** gnu_hacks.h comes with GNU C...  for VAX only; it is missing in the
     Alpha variant, which is of course completely stupid, and forces me
     to keep a copy of it.  Whenever there's a change in the copy that
     comes with GNU C, this program is in trouble...  ***/

#include "gnu_hacks.h"

/*** GNU C knows Nothing about variant_struct and variant_union.  So far,
     it seems like redefining them to struct and union respectively makes
     no harm... ***/

#define variant_union union
#define variant_struct struct

/*** The following were stolen from STSDEF.H that comes with DEC C ***/

#ifndef _STSDEF_H
#define _STSDEF_H

#ifndef _VMS_STSDEF_H
#define _VMS_STSDEF_H

#define STS$M_SEVERITY 0x7
#define STS$M_COND_ID 0xFFFFFF8
#define STS$M_CONTROL 0x0
#define STS$M_SUCCESS 0x1
#define STS$M_MSG_NO 0xFFF8
#define STS$M_CODE 0x7FF8
#define STS$M_FAC_SP 0x8000
#define STS$M_CUST_DEF 0x8000000
#define STS$M_INHIB_MSG 0x10000000
#define STS$M_FAC_NO 0xFFF0000
#define STS$K_WARNING 0                 /* WARNING                          */
#define STS$K_SUCCESS 1                 /* SUCCESSFUL COMPLETION            */
#define STS$K_ERROR 2                   /* ERROR                            */
#define STS$K_INFO 3                    /* INFORMATION                      */
#define STS$K_SEVERE 4                  /* SEVERE ERROR                     */

#define STS$S_CODE       0x0C
#define STS$S_COND_ID    0x19
#define STS$S_CONTROL    0x04
#define STS$S_FAC_NO     0x0C
#define STS$S_MSG_NO     0x0D
#define STS$S_SEVERITY   0x03

#define STS$V_CODE       0x03
#define STS$V_COND_ID    0x03
#define STS$V_CONTROL    0x1C
#define STS$V_CUST_DEF   0x1B
#define STS$V_FAC_NO     0x10
#define STS$V_FAC_SP     0x0F
#define STS$V_INHIB_MSG  0x1C
#define STS$V_MSG_NO     0x03
#define STS$V_SEVERITY   0x00
#define STS$V_SUCCESS    0x00
#endif

/* Define MACROS to extract individual fields from a status value */

#define $VMS_STATUS_CODE(code) 	    (((code)&STS$M_CODE)     >>STS$V_CODE)
#define $VMS_STATUS_COND_ID(code)   (((code)&STS$M_COND_ID)  >>STS$V_COND_ID)
#define $VMS_STATUS_CONTROL(code)   (((code)&STS$M_CONTROL)  >>STS$V_CONTROL)
#define $VMS_STATUS_CUST_DEF(code)  (((code)&STS$M_CUST_DEF) >>STS$V_CUST_DEF)
#define $VMS_STATUS_FAC_NO(code)    (((code)&STS$M_FAC_NO)   >>STS$V_FAC_NO)
#define $VMS_STATUS_FAC_SP(code)    (((code)&STS$M_FAC_SP)   >>STS$V_FAC_SP)
#define $VMS_STATUS_INHIB_MSG(code) (((code)&STS$M_INHIB_MSG)>>STS$V_INHIB_MSG)
#define $VMS_STATUS_MSG_NO(code)    (((code)&STS$M_MSG_NO)   >>STS$V_MSG_NO)
#define $VMS_STATUS_SEVERITY(code)  (((code)&STS$M_SEVERITY) >>STS$V_SEVERITY)
#define $VMS_STATUS_SUCCESS(code)   (((code)&STS$M_SUCCESS)  >>STS$V_SUCCESS)
#endif

/*** It seems like the GNU C compiler does something wrong with function
     name case, so let's help it out a little.  According to Jrme Lauret,
     this only happens where the actual calls are made, not in the definitions
     or declarations, so this should be pretty safe.  Unfortunately, this
     has to cover _all_ calls we make to external library functions... ***/

#define fish_internal           FISH_INTERNAL
#define fish_args               FISH_ARGS
#define fish_key_args           FISH_KEY_ARGS

#define cli$dcl_parse           CLI$DCL_PARSE
#define cli$dispatch            CLI$DISPATCH
#define cli$get_value           CLI$GET_VALUE
#define cli$present             CLI$PRESENT
#define sys$getsyiw             SYS$GETSYIW
#define sys$qiow                SYS$QIOW

#define netlib_address_to_name  NETLIB_ADDRESS_TO_NAME
#define netlib_addrtostr        NETLIB_ADDRTOSTR
#define netlib_close            NETLIB_CLOSE
#define netlib_connect_by_name  NETLIB_CONNECT_BY_NAME
#define netlib_getpeername      NETLIB_GETPEERNAME
#define netlib_ntoh_word        NETLIB_NTOH_WORD
#define netlib_read             NETLIB_READ
#define netlib_shutdown         NETLIB_SHUTDOWN
#define netlib_socket           NETLIB_SOCKET
#define netlib_write            NETLIB_WRITE
#define netlib_get_hostname	NETLIB_GET_HOSTNAME

#define BIO_ctrl                BIO_CTRL
#define BIO_new                 BIO_NEW
#define BIO_s_file              BIO_S_FILE
#define BF_cbc_encrypt          BF_CBC_ENCRYPT
#define BF_set_key              BF_SET_KEY
#define BN_bin2bn               BN_BIN2BN
#define BN_bn2bin               BN_BN2BIN
#define BN_bn2dec               BN_BN2DEC
#define BN_clear_free           BN_CLEAR_FREE
#define BN_cmp	                BN_CMP
#define BN_dec2bn               BN_DEC2BN
#define BN_free                 BN_FREE
#define BN_num_bits             BN_NUM_BITS
#define BUF_MEM_free            BUF_MEM_FREE
#define BUF_MEM_grow            BUF_MEM_GROW
#define BUF_MEM_new             BUF_MEM_NEW
#define ERR_load_crypto_strings ERR_LOAD_CRYPTO_STRINGS
#define ERR_print_errors        ERR_PRINT_ERRORS
#define MD5_Final               MD5_FINAL
#define MD5_Init                MD5_INIT
#define MD5_Update              MD5_UPDATE
#define RAND_bytes              RAND_BYTES
#define RAND_file_name          RAND_FILE_NAME
#define RAND_load_file          RAND_LOAD_FILE
#define RAND_seed               RAND_SEED
#define RAND_write_file         RAND_WRITE_FILE
#define RC4_set_key             RC4_SET_KEY
#define RSA_free                RSA_FREE
#define RSA_generate_key        RSA_GENERATE_KEY
#define RSA_new                 RSA_NEW
#define RSA_private_decrypt     RSA_PRIVATE_DECRYPT
#define RSA_public_encrypt      RSA_PUBLIC_ENCRYPT
#define des_ncbc_encrypt        DES_NCBC_ENCRYPT
#define des_set_key             DES_SET_KEY
#define idea_cfb64_encrypt      IDEA_CFB64_ENCRYPT
#define idea_set_encrypt_key    IDEA_SET_ENCRYPT_KEY

#define deflate                 DEFLATE
#define deflateEnd              DEFLATEEND
#define deflateInit_            DEFLATEINIT_
#define inflate                 INFLATE
#define inflateEnd              INFLATEEND
#define inflateInit_            INFLATEINIT_

#endif

#endif /* __GNUC__ */
/* Emacs local variables

Local variables:
eval: (set-c-style "BSD")
end:

*/
