/* $Id: io.h,v 1.1 1999/06/16 22:54:23 levitte Exp $ */

#ifndef IO_H
#define IO_H

#include "queue.h"

/* Forward declarations */
struct io_methods;

/* This is data about a SSH channel that is kept around as long as the channel
   is alive.  Actually, there's an array of these, that's why we need the flag
   member.  This structure is just a template... */
struct ssh_ch_st {
    struct io_methods *methods;

    struct VMS_queue *head;
    enum { channel_free, channel_busy } flag;
};

/* Blocks of data coming from the channel are queued in an I/O queue that will
   then be taken care of by the main loop.  The following structure is a
   template for the queue elements. */
struct io_st {
    VMS_queue queue_header;
    struct ssh_ch_st *ssh_ch_block;
};

/* The functions are supposed to do the following:

	create:		Initialise with I/O-dependent data and get
			the I/O started.  At this point, the channel
			structured is associated with a queue.
	get_buffer:	Copy whatever is in a given I/O packet to
			an external buffer of a given size.  Returns
			the amount of bytes actually transfered.
	put_buffer:	Send a buffer on the I/O channel.  Since this
			is AST-governed, the returned value is meaningless
			except for direct errors.
	enqueue:	Put the I/O packet on the given queue.  This is
			actually an internal routine...
	dequeue:	Take the I/O packet out of the given queue.  This is
			actually an internal routine...
	destroy:	Destroy this packet, free up the space.
*/
struct io_methods {
    int (*create)(struct ssh_ch_st *ctx, struct VMS_queue *queue, ...);
    int (*get_buffer)(struct io_st *ctx, char *buf, site_t siz);
    int (*put_buffer)(struct ssh_ch_st *ctx, char *buf, size_t len);
    int (*enqueue)(struct io_st *ctx, VMS_queue *queue);
    int (*dequeue)(struct io_st *ctx, VMS_queue *queue);
    void (*destroy)(struct io_st *ctx);
};

extern struct VMS_queue io_queue;

#define MAX_SSH_CHANNEL		256
#define SSH_CHANNEL_STDIN	MAX_SSH_CHANNEL+0
#define SSH_CHANNEL_STDOUT	MAX_SSH_CHANNEL+1
#define SSH_CHANNEL_STDERR	MAX_SSH_CHANNEL+2
extern struct ssh_channel[SSH_CHANNEL_STDERR+1];

/* Per io type init methods */
struct ssh_ch_st *tt_in_init(void);
struct ssh_ch_st *tt_out_init(void);
struct ssh_ch_st *remotenet_init(void);
struct ssh_ch_st *localnet_init(void);
struct ssh_ch_st *X11_init(void);

#endif

/* Emacs local variables

Local variables:
eval: (set-c-style "BSD")
end:

*/
