/* $Id: skeleton.c-h,v 1.1 1999/06/16 22:54:23 levitte Exp $ */

#include <netlib_dir/netlibdef.h>
#include <stdarg.h>
#include <descrip.h>
#include "io.h"
#include "io_buffer.h"
#include "vms.h"

struct ssh_ch_remotenet_st {
    struct ssh_ch_st ssh_ch_block;
    void *netlib_context;
};

struct io_remotenet_st {
    struct io_st io_block;
    struct NETLIBIOSBDEF iosb;

    enum { d_in, d_out } direction;
    unsigned char buf[35000];
    struct dsc$descriptor_s bufdsc;
};

struct io_methods remotenet_methods = {
    remotenet_create_input,
    remotenet_get_buffer,
    remotenet_put_buffer,
    remotenet_enqueue,
    remotenet_dequeue,
    remotenet_destroy
};

/* Support routines */
static struct io_remotenet_st *create_io_st()
{
    return (struct io_remotenet_out_st *)io_pool_get(sizeof(struct io_remotenet_out_st *));
}

static struct io_remotenet_st *fill_io_st(struct io_remotenet_st *ctx,
					  char *buf, int len)
{
    if (ctx == 0)
	return 0;

    if (buf) {
	memcpy(ctx->buf, buf, this_len);
    } else {
	/* dirty way to get the right data into an input I/O structure :-) */
	len = sizeof(ctx->buf);
    }
    ctx->bufdsc.dsc$w_length = len;
    ctx->bufdsc.dsc$b_dtype = DSC$K_DTYPE_T;
    ctx->bufdsc.dsc$b_class = DSC$K_CLASS_S;
    ctx->bufdsc.dsc$a_pointer = ctx->buf;

    return ctx;
}

struct ssh_ch_st *remotenet_init(void)
{
    struct ssh_ch_remotenet_st *v =
	(struct ssh_ch_remotenet_st *)xmalloc(sizeof(struct ssh_ch_remotenet_st));

    ssh_ch_init(v, remotenet_methods);
    return (struct ssh_ch_st *)v;
}

int remotenet_get_buffer(struct io_st *ctx, char *buf, size_t siz)
{
    struct io_remotenet_st *v = (struct io_remotenet_st *)ctx;
    int l = siz < v->;

    memcpy(buf + l, v->in[i].buf + rp, siz - l);
    return l;
}

static void remotenet_put_AST(struct io_remotenet_out_st *ctx)
{
    int status;

    status = ctx->iosb.iosb_w_status;
    if (!$VMS_STATUS_SUCCESS(status))
	lib$signal(status);

    status = io_pool_free(ctx);
    if (!$VMS_STATUS_SUCCESS(status))
	lib$signal(status);
    return;
}

int remotenet_put_buffer(struct ssh_ch_st *ctx, char *buf, size_t len)
{
    int status = 1;
    struct io_remotenet_st *v;

    if  (len < 0)
	lib$signal(FISH_M_EXIT);

    while (len > 0) {
	int this_len = (len < sizeof(v->buf) ? len : sizeof(v->buf));

	v = fill_io_st(create_io_st(), buf, len);
	if (v == 0)
	    return SS$_INSFMEM;
	
	ssh_debugf("remotenet_put_buffer(): writing to network, %d bytes (should be %d)",
		   v->bufdsc.dsc$w_length, len);
	status = netlib_write(&network_context, &v->bufdsc,
			      0, 0, &v->iosb, remotenet_put_AST, v);

	len -= this_len;
	buf += this_len;

	if (!$VMS_STATUS_SUCCESS(status))
	    return status;
    }
}

static void remotenet_input_AST(struct io_remotenet_st *ctx);

void remotenet_input_start(struct io_remotenet_st *ctx)
{
    int status = netlib_read(&ctx->ssh_ch_block->netlib_context,
			     &ctx->bufdsc, 0, 0, 0, 0, &ctx->iosb,
			     remotenet_input_AST, ctx);
    if (!$VMS_STATUS_SUCCESS(status))
	lib$signal(status);
}

void remotenet_input_AST(struct io_remotenet_st *ctx)
{
    int status;

    if (ctx->iosb.iosb_w_count != 0) {
	if (!$VMS_STATUS_SUCCESS(ctx->iosb.iosb_w_status)) {
	    ssh_debugf("remotenet_input_AST(): Exiting on condition %%X%X",
		       ctx->iosb.iosb_w_status);
	    lib$signal(ctx->iosb.iosb_w_status);
	}
    }

    remotenet_enqueue(ctx, ctx->ssh_ch_block->head);

    remotenet_input_start(fill_io_st(create_io_st(), 0, 0))
}

void remotenet_destroy(struct io_st *ctx)
{
    int status;

    free(ctx);

    return;
}

/* Emacs local variables

Local variables:
eval: (set-c-style "BSD")
end:

*/
