/* $Id: vms.h,v 1.6 1999/06/22 12:32:24 levitte Exp $ */

#ifndef __VMS_H

#include <ttdef.h>
#include <tt2def.h>
#include <descrip.h>

typedef enum
{
    /* 0 */
    TTY_OP_END=0,
    /* 1 */
    VINTR, VQUIT, VERASE, VKILL, VEOF, VEOL, VEOL2,
    /* 8 */
    VSTART=8, VSTOP, VSUSP, VDSUSP, VREPRINT, VWERASE, VLNEXT, VFLUSH,
    /* 16 */
    VSWTCH=16, VSTATUS, VDISCARD, /* 19-23 missing */
    /* 24 */
    /* 24-29 missing */ IGNPAR=30, PARMRK,
    /* 32 */
    INPCK=32, ISTRIP, INLCR, IGNCR, ICRNL, IUCLC, IXON, IXANY,
    /* 40 */
    IXOFF=40, IMAXBEL, /* 42-47 missing */
    /* 48 */
    /* 48-49 missing */ ISIG=50, ICANON, XCASE, ECHO, ECHOE, ECHOK,
    /* 56 */
    ECHONL=56, NOFLSH, TOSTOP, IEXTEN, ECHOCTL, ECHOKE, PENDIN, /* 63 missing */
    /* 64 */
    /* 64-69 missing */ OPOST=70, OLCUC,
    /* 72 */
    ONLCR=72, OCRNL, ONOCR, ONLRET, /* 73-79 missing */
    /* 80 */
    /* 80-87 missing */
    /* 88 */
    /* 88-89 missing */ CS7=90, CS8, PARENB, PARODD, /* 94-95 missing */
    /* 96 */
    /* 96-191 missing */
    /* 192 */
    TTY_OP_ISPEED=192, TTY_OP_OSPEED
} tty_bits;

typedef struct tty_s {
    unsigned short channel;
    struct dsc$descriptor_s name;
    struct {
	unsigned char class;
	unsigned char type;
	short int buffer_size;
	unsigned int basic_chars;
	unsigned int extended_chars;
    } tty_char;
} tty_s;

/* TTY specific things */

tty_s *tty_open(const char *name, int *status);
int tty_close(tty_s *tty, int *status);
int tty_release(tty_s *tty, int *status);
int tty_io_cancel(tty_s *tty, int *status);
tty_s *tty_dup(tty_s *tty);
int tty_setflags(tty_s *tty, int flags, int flags2, int *status);
int tty_clearflags(tty_s *tty, int flags, int flags2, int *status);
int tty_copychar(tty_s *tty,tty_s *from);
int tty_sensemode(tty_s *tty, int *status);
int tty_setmode(tty_s *tty, int *status);

/* TTY things you might want to do */

tty_s *tty_noecho(const char *name, int *status);
tty_s *tty_echo(const char *name, int *status);
int read_prompted(const char *name, const char *prompt,
		  char *bufaddr, unsigned long bufsize,
		  int purged, int echo, int *status);

int lib_put_output(char *str);

#define __VMS_H
#endif

/* Emacs local variables

Local variables:
eval: (set-c-style "BSD")
end:

*/
