 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %              AAA   N   N  IIIII  M   M   AAA   TTTTT  EEEEE                 % O %             A   A  NN  N    I    MM MM  A   A    T    E                     % O %             AAAAA  N N N    I    M M M  AAAAA    T    EEE                   % O %             A   A  N  NN    I    M   M  A   A    T    E                     % O %             A   A  N   N  IIIII  M   M  A   A    T    EEEEE                 % O %                                                                             % O %                                                                             % O %                 Interactively Animate an Image Sequence.                    % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              July 1992                                      % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Animate displays a sequence of images in the MIFF format on anyI %  workstation display running an X server.  Animate first determines the E %  hardware capabilities of the workstation.  If the number of unique I %  colors in an image is less than or equal to the number the workstation E %  can support, the image is displayed in an X window.  Otherwise the D %  number of colors in the image is first reduced to match the color8 %  resolution of the workstation before it is displayed. % M %  This means that a continuous-tone 24 bits-per-pixel image can display on a I %  8 bit pseudo-color device or monochrome device.  In most instances the H %  reduced color image closely resembles the original.  Alternatively, aG %  monochrome or pseudo-color image can display on a continuous-tone 24  %  bits-per-pixel device.  % ) %  The Animate program command syntax is:  % > %  Usage: animate [options ...] file [ [options ...] file ...] %  %  Where options include: > %    -backdrop            display image centered on a backdropJ %    -cache threshold     megabytes of memory available to the pixel cache+ %    -colormap type       Shared or Private A %    -colors value        preferred number of colors in the image 4 %    -colorspace type     alternate image colorspaceJ %    -crop geometry       preferred size and location of the cropped image> %    -delay value         display the next image after pausingF %    -density geometry    vertical and horizontal density of the image8 %    -display server      display image to this X serverH %    -dither              apply Floyd/Steinberg error diffusion to image3 %    -gamma value         level of gamma correction I %    -geometry geometry   preferred size and location of the Image window 9 %    -interlace type      None, Line, Plane, or Partition D %    -map type            display image using this Standard ColormapB %    -matte               store matte channel if the image has one< %    -monochrome          transform image to black and whiteH %    -remote command      execute a command in an remote display process; %    -rotate degrees      apply Paeth rotation to the image , %    -scene value         image scene number3 %    -size geometry       width and height of image @ %    -treedepth value     depth of the color classification treeD %    -verbose             print detailed information about the image> %    -visual type         display image using this visual typeD %    -window id           display image to background of this window % F %  In addition to those listed above, you can specify these standard XA %  resources as command line options:  -background, -bordercolor, C %  -borderwidth, -font, -foreground, -iconGeometry, -iconic, -name, * %  -mattecolor, -shared_memory, or -title. % D %  By default, the image format of `file' is determined by its magicF %  number.  To specify a particular image format, precede the filenameG %  with an image format name and a colon (i.e. ps:image) or specify the H %  image type as the filename suffix (i.e. image.ps).  Specify 'file' as$ %  '-' for standard input or output. %  %  Buttons: 9 %    Press any button to map or unmap the Command widget.  %  %  */   /*   Include declarations.  */ #include "magick/magick.h" #include "magick/defines.h"  #include "magick/xwindows.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 4 %  Method Usage displays the program command syntax. % % %  The format of the Usage method is:  % * %      void Usage(const char *client_name) % + %  A description of each parameter follows:  % J %    o client_name: a character string representing the name of the client %      program.  %  %  */* static void Usage(const char *client_name) {    const char     **p;     static const char      *buttons[]=      { <       "Press any button to map or unmap the Command widget",       (char *) NULL      },     *options[]=      { B       "-backdrop            display image centered on a backdrop",N       "-cache threshold     megabytes of memory available to the pixel cache",/       "-colormap type       Shared or Private", E       "-colors value        preferred number of colors in the image", 8       "-colorspace type     alternate image colorspace",N       "-crop geometry       preferred size and location of the cropped image",B       "-delay value         display the next image after pausing",J       "-density geometry    vertical and horizontal density of the image",<       "-display server      display image to this X server",L       "-dither              apply Floyd/Steinberg error diffusion to image",7       "-gamma value         level of gamma correction", M       "-geometry geometry   preferred size and location of the Image window", =       "-interlace type      None, Line, Plane, or Partition", F       "-matte               store matte channel if the image has one",H       "-map type            display image using this Standard Colormap",@       "-monochrome          transform image to black and white",L       "-remote command      execute a command in an remote display process",?       "-rotate degrees      apply Paeth rotation to the image", 0       "-scene value         image scene number",7       "-size geometry       width and height of image", D       "-treedepth value     depth of the color classification tree",H       "-verbose             print detailed information about the image",B       "-visual type         display image using this visual type",G       "-window id          display image to background of this window",        (char *) NULL      };  4   (void) printf("Version: %.1024s\n",MagickVersion);:   (void) printf("Copyright: %.1024s\n\n",MagickCopyright);   (void) printf(F     "Usage: %.1024s [-options ...] file [ [-options ...] file ...]\n",     client_name); /   (void) printf("\nWhere options include: \n"); +   for (p=options; *p != (char *) NULL; p++) $     (void) printf("  %.1024s\n",*p);   (void) printf(O     "\nIn addition to those listed above, you can specify these standard X\n");    (void) printf(H     "resources as command line options:  -background, -bordercolor,\n");   (void) printf(J     "-borderwidth, -font, -foreground, -iconGeometry, -iconic, -name,\n");=   (void) printf("-mattecolor, -shared_memory, or -title.\n");    (void) printf(M     "\nBy default, the image format of `file' is determined by its magic\n");    (void) printf(M     "number.  To specify a particular image format, precede the filename\n");    (void) printf(N     "with an image format name and a colon (i.e. ps:image) or specify the\n");   (void) printf(O     "image type as the filename suffix (i.e. image.ps).  Specify 'file' as\n"); 7   (void) printf("'-' for standard input or output.\n"); !   (void) printf("\nButtons: \n"); +   for (p=buttons; *p != (char *) NULL; p++) $     (void) printf("  %.1024s\n",*p);
   Exit(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %    M a i n                                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   #if defined(WIN32)M int WINAPI WinMain(HINSTANCE instance,HINSTANCE last,LPSTR command,int state)  {    char     **argv;       int 	     argc,      main(int,char **);   #   argv=StringToArgv(command,&argc);    return(main(argc,argv)); }  #endif   int main(int argc,char **argv) {  #if defined(HasX11)    char     *client_name,      *option,     *resource_value,     *server_name;   	   Display 
     *display;      double	     sans;      Image      *image,      *loaded_image,     *next_image,     *p;      ImageInfo      *image_info;     int      i,     x;     QuantizeInfo     *quantize_info;      unsigned int     first_scene,     last_scene, 
     scene;     XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     /*&     Initialize command line arguments.   */   SetNotifyHandlers;   ReadCommandlLine(argc,&argv); #   client_name=SetClientName(*argv); &   (void) ExpandFilenames(&argc,&argv);   /*     Set defaults.    */   display=(Display *) NULL;    first_scene=0;   image=(Image *) NULL;    last_scene=0;    /*8     Check for server name specified on the command line.   */   server_name=(char *) NULL;   for (i=1; i < argc; i++)   {      /*)       Check command line for server name.      */     option=argv[i]; H     if ((Extent(option) == 1) || ((*option != '-') && (*option != '+')))       continue; /     if (Latin1Compare("display",option+1) == 0)        { 
         /*%           User specified server name. 
         */         i++;         if (i == argc)@           MagickError(OptionError,"Missing server name",option);         server_name=argv[i];         break;       } (     if (strncmp("help",option+1,2) == 0)       Usage(client_name);    }    /*/     Get user defaults from X resource database.    */$   display=XOpenDisplay(server_name);"   if (display == (Display *) NULL)=     MagickError(XServerError,"Unable to connect to X server", !       XDisplayName(server_name));    XSetErrorHandler(XError); >   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info); &   image_info=resource_info.image_info;$   image_info->insert_backdrops=True;#   image_info->coalesce_frames=True; ,   quantize_info=resource_info.quantize_info;   resource_info.delay=0;   resource_info.pause=0;   resource_value= D     XGetResourceInstance(resource_database,client_name,"delay","0");B   (void) XParseGeometry(resource_value,&x,&x,&resource_info.delay,     &resource_info.pause);   image_info->density=P     XGetResourceInstance(resource_database,client_name,"density",(char *) NULL);+   if (image_info->density == (char *) NULL) 3     image_info->density=XGetScreenDensity(display);    resource_value= K     XGetResourceInstance(resource_database,client_name,"interlace","none"); +   image_info->interlace=UndefinedInterlace; 0   if (Latin1Compare("None",resource_value) == 0)&     image_info->interlace=NoInterlace;0   if (Latin1Compare("Line",resource_value) == 0)(     image_info->interlace=LineInterlace;1   if (Latin1Compare("Plane",resource_value) == 0) )     image_info->interlace=PlaneInterlace; 5   if (Latin1Compare("Partition",resource_value) == 0) -     image_info->interlace=PartitionInterlace; 2   if (image_info->interlace == UndefinedInterlace)N     MagickWarning(OptionWarning,"Unrecognized interlace type",resource_value);   resource_value= J     XGetResourceInstance(resource_database,client_name,"verbose","False");-   image_info->verbose=IsTrue(resource_value);    resource_value= H     XGetResourceInstance(resource_database,client_name,"dither","True");/   quantize_info->dither=IsTrue(resource_value);    /*     Parse command line.    */   for (i=1; i <= argc; i++)    {      if (i < argc)        option=argv[i];      else"       if (image != (Image *) NULL)         break;
       else"         if (!isatty(STDIN_FILENO))           option="-";          else!           option="logo:Untitled"; G     if ((Extent(option) > 1) && ((*option == '-') || (*option == '+')))        switch (*(option+1))       {          case 'b': 	         { 2           if (strncmp("backdrop",option+1,5) == 0)
             { 6               resource_info.backdrop=(*option == '-');               break;
             } 4           if (strncmp("background",option+1,5) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)D                     MagickError(OptionError,"Missing color",option);N                   (void) CloneString(&resource_info.background_color,argv[i]);4                   (void) QueryColorDatabase(argv[i],3                     &image_info->background_color);                  }                break;
             } 5           if (strncmp("bordercolor",option+1,7) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)D                     MagickError(OptionError,"Missing color",option);J                   (void) CloneString(&resource_info.border_color,argv[i]);O                   (void) QueryColorDatabase(argv[i],&image_info->border_color);                  }                break;
             } 5           if (strncmp("borderwidth",option+1,7) == 0) 
             { +               resource_info.border_width=0; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing width",option);;                   resource_info.border_width=atoi(argv[i]);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'c': 	         { /           if (strncmp("cache",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))H                     MagickError(OptionError,"Missing threshold",option);                 }                break;
             } 2           if (strncmp("colormap",option+1,6) == 0)
             { 5               resource_info.colormap=PrivateColormap; !               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; ;                   resource_info.colormap=UndefinedColormap; ;                   if (Latin1Compare("private",option) == 0) ;                     resource_info.colormap=PrivateColormap; :                   if (Latin1Compare("shared",option) == 0):                     resource_info.colormap=SharedColormap;B                   if (resource_info.colormap == UndefinedColormap)L                     MagickError(OptionError,"Invalid colormap type",option);                 }                break;
             } 0           if (strncmp("colors",option+1,7) == 0)
             { -               quantize_info->number_colors=0; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing colors",option); =                   quantize_info->number_colors=atoi(argv[i]);                  }                break;
             } 4           if (strncmp("colorspace",option+1,7) == 0)
             { 6               quantize_info->colorspace=RGBColorspace;!               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; @                   quantize_info->colorspace=UndefinedColorspace;8                   if (Latin1Compare("cmyk",option) == 0)=                     quantize_info->colorspace=CMYKColorspace; 8                   if (Latin1Compare("gray",option) == 0)                     { ?                       quantize_info->colorspace=GRAYColorspace; 7                       quantize_info->number_colors=256; 2                       quantize_info->tree_depth=8;                     } 8                   if (Latin1Compare("ohta",option) == 0)=                     quantize_info->colorspace=OHTAColorspace; 7                   if (Latin1Compare("rgb",option) == 0) <                     quantize_info->colorspace=RGBColorspace;8                   if (Latin1Compare("srgb",option) == 0)=                     quantize_info->colorspace=sRGBColorspace; ?                   if (Latin1Compare("transparent",option) == 0) D                     quantize_info->colorspace=TransparentColorspace;7                   if (Latin1Compare("xyz",option) == 0) <                     quantize_info->colorspace=XYZColorspace;9                   if (Latin1Compare("ycbcr",option) == 0) >                     quantize_info->colorspace=YCbCrColorspace;7                   if (Latin1Compare("ycc",option) == 0) <                     quantize_info->colorspace=YCCColorspace;7                   if (Latin1Compare("yiq",option) == 0) <                     quantize_info->colorspace=YIQColorspace;9                   if (Latin1Compare("ypbpr",option) == 0) >                     quantize_info->colorspace=YPbPrColorspace;7                   if (Latin1Compare("yuv",option) == 0) <                     quantize_info->colorspace=YUVColorspace;G                   if (quantize_info->colorspace == UndefinedColorspace) N                     MagickError(OptionError,"Invalid colorspace type",option);                 }                break;
             } .           if (strncmp("crop",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'd': 	         { /           if (strncmp("debug",option+1,3) == 0) 
             { 3               resource_info.debug=(*option == '-');                break;
             } /           if (strncmp("delay",option+1,3) == 0) 
             { $               resource_info.delay=0;$               resource_info.pause=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     MagickError(OptionError,"Missing seconds",option);K                   (void) XParseGeometry(argv[i],&x,&x,&resource_info.delay, *                     &resource_info.pause);                 }                break;
             } 1           if (strncmp("density",option+1,3) == 0) 
             { 0               image_info->density=(char *) NULL;!               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option); C                   (void) CloneString(&image_info->density,argv[i]);                  }                break;
             } 5           if (Latin1Compare("display",option+1) == 0) 
             { 4               image_info->server_name=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)J                     MagickError(OptionError,"Missing server name",option);G                   (void) CloneString(&image_info->server_name,argv[i]);                  }                break;
             } 0           if (strncmp("dither",option+1,3) == 0)
             { 5               quantize_info->dither=(*option == '-');                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'f': 	         { .           if (strncmp("font",option+1,3) == 0)
             { -               image_info->font=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     MagickError(OptionError,"Missing font name",option);@                   (void) CloneString(&image_info->font,argv[i]);                 } 8               if ((image_info->font == (char *) NULL) ||-                   (*image_info->font != '@')) I                 (void) CloneString(&resource_info.font,image_info->font);                break;
             } 4           if (strncmp("foreground",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)I                     MagickError(OptionError,"Missing foreground",option); N                   (void) CloneString(&resource_info.foreground_color,argv[i]);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'g': 	         { /           if (strncmp("gamma",option+1,2) == 0) 
             {                i++;>               if ((i == argc) || !sscanf(argv[i],"%lf",&sans))@                 MagickError(OptionError,"Missing value",option);               break;
             } 2           if (strncmp("geometry",option+1,2) == 0)
             { 9               resource_info.image_geometry=(char *) NULL; !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option); L                   (void) CloneString(&resource_info.image_geometry,argv[i]);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'h': 	         { .           if (strncmp("help",option+1,2) == 0)
             { !               Usage(client_name);                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'i': 	         { 6           if (strncmp("iconGeometry",option+1,5) == 0)
             { 8               resource_info.icon_geometry=(char *) NULL;!               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option); K                   (void) CloneString(&resource_info.icon_geometry,argv[i]);                  }                break;
             } 0           if (strncmp("iconic",option+1,5) == 0)
             { 4               resource_info.iconic=(*option == '-');               break;
             } 3           if (strncmp("interlace",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; ;                   image_info->interlace=UndefinedInterlace; 8                   if (Latin1Compare("None",option) == 0)6                     image_info->interlace=NoInterlace;8                   if (Latin1Compare("Line",option) == 0)8                     image_info->interlace=LineInterlace;9                   if (Latin1Compare("Plane",option) == 0) 9                     image_info->interlace=PlaneInterlace; =                   if (Latin1Compare("Partition",option) == 0) =                     image_info->interlace=PartitionInterlace; B                   if (image_info->interlace == UndefinedInterlace)M                     MagickError(OptionError,"Invalid interlace type",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'm': 	         { -           if (strncmp("map",option+1,3) == 0) 
             {                argv[i]="+sans";3               resource_info.map_type=(char *) NULL; !               if (*option == '-')                  { "                   argv[i]="-sans";                   i++;                    if (i == argc)G                     MagickError(OptionError,"Missing map type",option); F                   (void) CloneString(&resource_info.map_type,argv[i]);                 }                break;
             } 3           if (Latin1Compare("matte",option+1) == 0)              break;4           if (strncmp("mattecolor",option+1,6) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)D                     MagickError(OptionError,"Missing color",option);I                   (void) CloneString(&resource_info.matte_color,argv[i]); N                   (void) QueryColorDatabase(argv[i],&image_info->matte_color);                 }                break;
             } 4           if (strncmp("monochrome",option+1,2) == 0)
             { 6               image_info->monochrome=(*option == '-');)               if (image_info->monochrome)                  { 1                   quantize_info->number_colors=2; .                   quantize_info->tree_depth=8;;                   quantize_info->colorspace=GRAYColorspace;                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'n': 	         { +           resource_info.name=(char *) NULL;            if (*option == '-') 
             {                i++;               if (i == argc)?                 MagickError(OptionError,"Missing name",option); >               (void) CloneString(&resource_info.name,argv[i]);
             }            break;	         }          case 'r': 	         { 0           if (strncmp("remote",option+1,3) == 0)
             {                i++;               if (i == argc)B                 MagickError(OptionError,"Missing command",option);F               XRemoteCommand(display,resource_info.window_id,argv[i]);               Exit(0);
             } 0           if (strncmp("rotate",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))F                     MagickError(OptionError,"Missing degrees",option);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 's': 	         { /           if (strncmp("scene",option+1,3) == 0) 
             {                first_scene=0;               last_scene=0; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))K                     MagickError(OptionError,"Missing scene number",option); ,                   first_scene=atoi(argv[i]);)                   last_scene=first_scene; J                   (void) sscanf(argv[i],"%u-%u",&first_scene,&last_scene);                 }                break;
             } 7           if (strncmp("shared_memory",option+1,4) == 0) 
             { ?               resource_info.use_shared_memory=(*option == '-');                break;
             } .           if (strncmp("size",option+1,2) == 0)
             { -               image_info->size=(char *) NULL; !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option); @                   (void) CloneString(&image_info->size,argv[i]);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 't': 	         { 3           if (strncmp("text_font",option+1,3) == 0) 
             { 4               resource_info.text_font=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)H                     MagickError(OptionError,"Missing font name",option);G                   (void) CloneString(&resource_info.text_font,argv[i]);                  }                break;
             } /           if (strncmp("title",option+1,2) == 0) 
             { 0               resource_info.title=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)D                     MagickError(OptionError,"Missing title",option);C                   (void) CloneString(&resource_info.title,argv[i]);                  }                break;
             } 3           if (strncmp("treedepth",option+1,3) == 0) 
             { *               quantize_info->tree_depth=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing depth",option);:                   quantize_info->tree_depth=atoi(argv[i]);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'v': 	         { 1           if (strncmp("verbose",option+1,2) == 0) 
             { 3               image_info->verbose=(*option == '-');                break;
             } 0           if (strncmp("visual",option+1,3) == 0)
             { 6               resource_info.visual_type=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)K                     MagickError(OptionError,"Missing visual class",option); I                   (void) CloneString(&resource_info.visual_type,argv[i]);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'w': 	         { 0           if (strncmp("window",option+1,2) == 0)
             { 4               resource_info.window_id=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)J                     MagickError(OptionError,"Missing id, name, or 'root'",                       option);G                   (void) CloneString(&resource_info.window_id,argv[i]);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case '?': 	         {            Usage(client_name);            break;	         }          default:	         { @           MagickError(OptionError,"Unrecognized option",option);           break;	         }        }      else       { 
         /*            Option is a file name.
         */>         for (scene=first_scene; scene <= last_scene ; scene++)	         {            /*             Read image.            */5           (void) strcpy(image_info->filename,option); (           if (first_scene != last_scene)
             {                char(                 filename[MaxTextExtent];                 /*4                 Form filename for multi-part images.               */@               FormatString(filename,image_info->filename,scene);D               if (Latin1Compare(filename,image_info->filename) == 0)P                 FormatString(filename,"%.1024s[%u]",image_info->filename,scene);;               (void) strcpy(image_info->filename,filename); 
             } 3           (void) strcpy(image_info->magick,"MIFF"); ;           image_info->colorspace=quantize_info->colorspace; 3           image_info->dither=quantize_info->dither; +           next_image=ReadImage(image_info); +           if (next_image == (Image *) NULL) 
             { !               if (*option == '-')                  break;               else                 continue; 
             } 7           MogrifyImages(image_info,i,argv,&next_image); &           if (image == (Image *) NULL)             image=next_image;            else
             {                /*+                 Link image into image list.                */B               for (p=image; p->next != (Image *) NULL; p=p->next);%               next_image->previous=p; !               p->next=next_image; 
             } 	         }        }    }    if (image == (Image *) NULL)H     MagickError(OptionError,"Missing an image file name",(char *) NULL);+   while (image->previous != (Image *) NULL)      image=image->previous;/   if (resource_info.window_id != (char *) NULL) :     XAnimateBackgroundImage(display,&resource_info,image);   else     {        /*"         Animate image to X server.       */J       loaded_image=XAnimateImages(display,&resource_info,argv,argc,image);,       while (loaded_image != (Image *) NULL)       {          image=loaded_image; 4         MogrifyImage(image_info,argc-1,argv,&image);L         loaded_image=XAnimateImages(display,&resource_info,argv,argc,image);       }      }    DestroyDelegateInfo();   DestroyMagickInfo();   FreeMemory(argv); 
   Exit(0); #endif   return(False); } 