 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                CCCC   OOO   M   M  BBBB   IIIII  N   N  EEEEE               % O %               C      O   O  MM MM  B   B    I    NN  N  E                   % O %               C      O   O  M M M  BBBB     I    N N N  EEE                 % O %               C      O   O  M   M  B   B    I    N  NN  E                   % O %                CCCC   OOO   M   N  BBBB   IIIII  N   N  EEEEE               % O %                                                                             % O %                                                                             % O %                        Digitally combine two images.                        % O %                                                                             % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                               January 1993                                  % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ! %  The combine program syntax is:  % ? %  Usage: combine [options ...] image composite [mask] combined  %  %  Where options include: = %    -blend value        blend the two images a given percent I %    -cache threshold    number of megabytes available to the pixel cache @ %    -colors value       preferred number of colors in the image+ %    -compose operator   composite operator 3 %    -colorspace type    alternate image colorspace 4 %    -comment string     annotate image with comment2 %    -compress type      type of image compressionE %    -density geometry   vertical and horizontal density of the image L %    -displace geometry  shift image pixels as defined by a displacement map@ %    -display server     obtain image or font from this X server, %    -dispose method     GIF disposal methodG %    -dither             apply Floyd/Steinberg error diffusion to image 5 %    -font name          X11 font for displaying text @ %    -geometry geometry  perferred size or location of the image= %    -gravity type       which direction to gravitate towards 8 %    -interlace type     None, Line, Plane, or Partition3 %    -label name         assign a label to an image A %    -matte              store matte channel if the image has one ; %    -monochrome         transform image to black and white J %    -negate             replace every pixel with its complementary color = %    -page geometry      size and location of an image canvas 8 %    -quality value      JPEG/MIFF/PNG compression level+ %    -scene value        image scene number 2 %    -size geometry      width and height of image7 %    -stegano offset     hide watermark within an image F %    -stereo             combine two image to create a stereo anaglyph@ %    -tile               repeat composite operation across image? %    -treedepth value    depth of the color classification tree C %    -verbose            print detailed information about the image  %  %  */   /*   Include declarations.  */ #include "magick/magick.h" #include "magick/defines.h"    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % . %  Procedure Usage displays the program usage; % % %  The format of the Usage method is:  % * %      void Usage(const char *client_name) % J %    o client_name: a character string representing the name of the client %      program.  %  %  */* static void Usage(const char *client_name) {    const char     **p;     static const char      *options[]=      { A       "-blend value        blend the two images a given percent", M       "-cache threshold    number of megabytes available to the pixel cache", D       "-colors value       preferred number of colors in the image",7       "-colorspace type    alternate image colorspace", 8       "-comment string     annotate image with comment",/       "-compose operator   composite operator", 6       "-compress type      type of image compression",I       "-density geometry   vertical and horizontal density of the image", P       "-displace geometry  shift image pixels as defined by a displacement map",D       "-display server     obtain image or font from this X server",0       "-dispose method     GIF disposal method",K       "-dither             apply Floyd/Steinberg error diffusion to image", 9       "-font name          X11 font for displaying text", D       "-geometry geometry  perferred size or location of the image",A       "-gravity type       which direction to gravitate towards", <       "-interlace type     None, Line, Plane, or Partition",6       "-label name         ssign a label to an image",E       "-matte              store matte channel if the image has one", ?       "-monochrome         transform image to black and white", N       "-negate             replace every pixel with its complementary color ",A       "-page geometry      size and location of an image canvas", <       "-quality value      JPEG/MIFF/PNG compression level",/       "-scene value        image scene number", 6       "-size geometry      width and height of image",;       "-stegano offset     hide watermark within an image", J       "-stereo             combine two image to create a stereo anaglyph",D       "-tile               repeat composite operation across image",C       "-treedepth value    depth of the color classification tree", G       "-verbose            print detailed information about the image",        (char *) NULL      };  4   (void) printf("Version: %.1024s\n",MagickVersion);:   (void) printf("Copyright: %.1024s\n\n",MagickCopyright);Q   (void) printf("Usage: %.1024s [options ...] image composite [mask] combined\n",      client_name); .   (void) printf("\nWhere options include:\n");+   for (p=options; *p != (char *) NULL; p++) $     (void) printf("  %.1024s\n",*p);
   Exit(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  M a i n                                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */ int main(int argc,char **argv) { + #define NotInitialized  (unsigned int) (~0)      char     *client_name,      *displacement_geometry,      *watermark_geometry,     *filename,     *geometry,     *option,     *write_filename;     CompositeOperator      compose;     double
     blend,	     sans;      Image      *combined_image,     *composite_image,      *image,      *mask_image;     ImageInfo      image_info;      int      gravity,     status,      x,     y;     register int     i;     unsigned int     stegano,     stereo, 	     tile;      /*&     Initialize command line arguments.   */   ReadCommandlLine(argc,&argv); #   client_name=SetClientName(*argv); &   (void) ExpandFilenames(&argc,&argv);   if (argc < 4)      Usage(client_name);    /*     Set default.   */   blend=0.0;   compose=ReplaceCompositeOp; !   composite_image=(Image *) NULL; &   displacement_geometry=(char *) NULL;#   watermark_geometry=(char *) NULL;    geometry=(char *) NULL;    gravity=NorthWestGravity;    image=(Image *) NULL;    GetImageInfo(&image_info);   mask_image=(Image *) NULL;   stegano=0;   stereo=False; 
   tile=False;    write_filename=argv[argc-1];   /*     Check command syntax.    */   filename=(char *) NULL;    for (i=1; i < (argc-1); i++)   {      option=argv[i]; G     if ((Extent(option) < 2) || ((*option != '-') && (*option != '+')))        { 
         /*           Read input images.
         */         filename=argv[i]; 4         (void) strcpy(image_info.filename,filename);$         if (image == (Image *) NULL)           { )             image=ReadImage(&image_info); (             if (image == (Image *) NULL)C               MagickError(OptionError,"Missing an image file name",                  (char *) NULL);              continue;            } )         if (mask_image != (Image *) NULL) M           MagickError(OptionError,"input images already specified",filename); .         if (composite_image == (Image *) NULL)           { 3             composite_image=ReadImage(&image_info); 2             if (composite_image == (Image *) NULL)C               MagickError(OptionError,"Missing an image file name",                  (char *) NULL);              continue;            } *         mask_image=ReadImage(&image_info);)         if (mask_image == (Image *) NULL) N           MagickError(OptionError,"Missing an image file name",(char *) NULL);       }      else       switch(*(option+1))        {          case 'b': 	         { /           if (strncmp("blend",option+1,3) == 0) 
             {                blend=0.0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing value",option);&                   blend=atof(argv[i]);+                   compose=BlendCompositeOp;                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'c': 	         { /           if (strncmp("cache",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))H                     MagickError(OptionError,"Missing threshold",option);                 }                break;
             } 0           if (strncmp("colors",option+1,7) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing colors",option);                  }                break;
             } 4           if (strncmp("colorspace",option+1,7) == 0)
             { 2               image_info.colorspace=RGBColorspace;!               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; <                   image_info.colorspace=UndefinedColorspace;8                   if (Latin1Compare("cmyk",option) == 0)9                     image_info.colorspace=CMYKColorspace; 8                   if (Latin1Compare("gray",option) == 0)9                     image_info.colorspace=GRAYColorspace; 8                   if (Latin1Compare("ohta",option) == 0)9                     image_info.colorspace=OHTAColorspace; 7                   if (Latin1Compare("rgb",option) == 0) 8                     image_info.colorspace=RGBColorspace;8                   if (Latin1Compare("srgb",option) == 0)9                     image_info.colorspace=sRGBColorspace; ?                   if (Latin1Compare("transparent",option) == 0) @                     image_info.colorspace=TransparentColorspace;7                   if (Latin1Compare("xyz",option) == 0) 8                     image_info.colorspace=XYZColorspace;9                   if (Latin1Compare("ycbcr",option) == 0) :                     image_info.colorspace=YCbCrColorspace;7                   if (Latin1Compare("ycc",option) == 0) 8                     image_info.colorspace=YCCColorspace;7                   if (Latin1Compare("yiq",option) == 0) 8                     image_info.colorspace=YIQColorspace;9                   if (Latin1Compare("ypbpr",option) == 0) :                     image_info.colorspace=YPbPrColorspace;7                   if (Latin1Compare("yuv",option) == 0) 8                     image_info.colorspace=YUVColorspace;C                   if (image_info.colorspace == UndefinedColorspace) N                     MagickError(OptionError,"Invalid colorspace type",option);                 }                break;
             } 1           if (strncmp("comment",option+1,4) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)F                     MagickError(OptionError,"Missing comment",option);                 }                break;
             } 1           if (strncmp("compose",option+1,5) == 0) 
             { )               compose=ReplaceCompositeOp; !               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; /                   compose=UndefinedCompositeOp; 8                   if (Latin1Compare("Over",option) == 0),                     compose=OverCompositeOp;6                   if (Latin1Compare("In",option) == 0)*                     compose=InCompositeOp;7                   if (Latin1Compare("Out",option) == 0) +                     compose=OutCompositeOp; 8                   if (Latin1Compare("Atop",option) == 0),                     compose=AtopCompositeOp;7                   if (Latin1Compare("Xor",option) == 0) +                     compose=XorCompositeOp; 8                   if (Latin1Compare("Plus",option) == 0),                     compose=PlusCompositeOp;9                   if (Latin1Compare("Minus",option) == 0) -                     compose=MinusCompositeOp; 7                   if (Latin1Compare("Add",option) == 0) +                     compose=AddCompositeOp; <                   if (Latin1Compare("Subtract",option) == 0)0                     compose=SubtractCompositeOp;>                   if (Latin1Compare("Difference",option) == 0)2                     compose=DifferenceCompositeOp;;                   if (Latin1Compare("Bumpmap",option) == 0) /                     compose=BumpmapCompositeOp; ;                   if (Latin1Compare("Replace",option) == 0) /                     compose=ReplaceCompositeOp; >                   if (Latin1Compare("ReplaceRed",option) == 0)2                     compose=ReplaceRedCompositeOp;@                   if (Latin1Compare("ReplaceGreen",option) == 0)4                     compose=ReplaceGreenCompositeOp;?                   if (Latin1Compare("ReplaceBlue",option) == 0) 3                     compose=ReplaceBlueCompositeOp; @                   if (Latin1Compare("ReplaceMatte",option) == 0)4                     compose=ReplaceMatteCompositeOp;6                   if (compose == UndefinedCompositeOp)K                     MagickError(OptionError,"Invalid compose type",option);                  }                break;
             } 2           if (strncmp("compress",option+1,5) == 0)
             { 3               image_info.compression=NoCompression; !               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; >                   image_info.compression=UndefinedCompression;8                   if (Latin1Compare("None",option) == 0)9                     image_info.compression=NoCompression; 8                   if (Latin1Compare("BZip",option) == 0);                     image_info.compression=BZipCompression; 7                   if (Latin1Compare("Fax",option) == 0) :                     image_info.compression=FaxCompression;:                   if (Latin1Compare("Group4",option) == 0)=                     image_info.compression=Group4Compression; 8                   if (Latin1Compare("JPEG",option) == 0);                     image_info.compression=JPEGCompression; 7                   if (Latin1Compare("LZW",option) == 0) :                     image_info.compression=LZWCompression;D                   if (Latin1Compare("RunlengthEncoded",option) == 0)G                     image_info.compression=RunlengthEncodedCompression; 7                   if (Latin1Compare("Zip",option) == 0) :                     image_info.compression=ZipCompression;E                   if (image_info.compression == UndefinedCompression) O                     MagickError(OptionError,"Invalid compression type",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'd': 	         { 1           if (strncmp("density",option+1,3) == 0) 
             { /               image_info.density=(char *) NULL; !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option); B                   (void) CloneString(&image_info.density,argv[i]);                 }                break;
             } 6           if (Latin1Compare("displace",option+1) == 0)
             { 2               displacement_geometry=(char *) NULL;!               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))G                     MagickError(OptionError,"Missing geometry",option); E                   (void) CloneString(&displacement_geometry,argv[i]); .                   compose=DisplaceCompositeOp;                 }                break;
             } 5           if (Latin1Compare("display",option+1) == 0) 
             { 3               image_info.server_name=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)J                     MagickError(OptionError,"Missing server name",option);F                   (void) CloneString(&image_info.server_name,argv[i]);                 }                break;
             } 1           if (strncmp("dispose",option+1,5) == 0) 
             { /               image_info.dispose=(char *) NULL; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing method",option); A                   image_info.dispose=PostscriptGeometry(argv[i]);                  }                break;
             } 0           if (strncmp("dither",option+1,3) == 0)
             { 1               image_info.dither=(*option == '-');                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'f': 	         { (           image_info.font=(char *) NULL;           if (*option == '-') 
             {                i++;               if (i == argc)D                 MagickError(OptionError,"Missing font name",option);;               (void) CloneString(&image_info.font,argv[i]); 
             }            break;	         }          case 'g': 	         { 2           if (strncmp("geometry",option+1,2) == 0)
             { %               geometry=(char *) NULL; !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option); 8                   (void) CloneString(&geometry,argv[i]);                 }                break;
             } 1           if (strncmp("gravity",option+1,2) == 0) 
             { $               gravity=ForgetGravity;!               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; :                   if (Latin1Compare("Forget",option) == 0)*                     gravity=ForgetGravity;=                   if (Latin1Compare("NorthWest",option) == 0) -                     gravity=NorthWestGravity; 9                   if (Latin1Compare("North",option) == 0) )                     gravity=NorthGravity; =                   if (Latin1Compare("NorthEast",option) == 0) -                     gravity=NorthEastGravity; 8                   if (Latin1Compare("West",option) == 0)(                     gravity=WestGravity;:                   if (Latin1Compare("Center",option) == 0)*                     gravity=CenterGravity;8                   if (Latin1Compare("East",option) == 0)(                     gravity=EastGravity;=                   if (Latin1Compare("SouthWest",option) == 0) -                     gravity=SouthWestGravity; 9                   if (Latin1Compare("South",option) == 0) )                     gravity=SouthGravity; =                   if (Latin1Compare("SouthEast",option) == 0) -                     gravity=SouthEastGravity; /                   if (gravity == ForgetGravity) K                     MagickError(OptionError,"Invalid gravity type",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'h': 	         { .           if (strncmp("help",option+1,2) == 0)
             { !               Usage(client_name);                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'i': 	         { 3           if (strncmp("interlace",option+1,3) == 0) 
             { /               image_info.interlace=NoInterlace; !               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; :                   image_info.interlace=UndefinedInterlace;8                   if (Latin1Compare("None",option) == 0)5                     image_info.interlace=NoInterlace; 8                   if (Latin1Compare("Line",option) == 0)7                     image_info.interlace=LineInterlace; 9                   if (Latin1Compare("Plane",option) == 0) 8                     image_info.interlace=PlaneInterlace;=                   if (Latin1Compare("Partition",option) == 0) <                     image_info.interlace=PartitionInterlace;A                   if (image_info.interlace == UndefinedInterlace) M                     MagickError(OptionError,"Invalid interlace type",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'l': 	         { /           if (strncmp("label",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)I                     MagickError(OptionError,"Missing label name",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'm': 	         { /           if (strncmp("matte",option+1,5) == 0)              break;4           if (strncmp("monochrome",option+1,2) == 0)             break;@           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'n': 	         { 0           if (strncmp("negate",option+1,3) == 0)             break;@           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'p': 	         { .           if (strncmp("page",option+1,3) == 0)
             { ,               image_info.page=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)L                     MagickError(OptionError,"Missing page geometry",option);>                   image_info.page=PostscriptGeometry(argv[i]);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'q': 	         { 1           if (strncmp("quality",option+1,2) == 0) 
             { $               image_info.quality=75;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     MagickError(OptionError,"Missing quality",option);3                   image_info.quality=atoi(argv[i]);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 's': 	         { /           if (strncmp("scene",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))K                     MagickError(OptionError,"Missing scene number",option);                  }                break;
             } .           if (strncmp("size",option+1,2) == 0)
             { ,               image_info.size=(char *) NULL;!               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option); ?                   (void) CloneString(&image_info.size,argv[i]);                  }                break;
             } 1           if (strncmp("stegano",option+1,4) == 0) 
             {                stegano=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing offset",option); *                   stegano=atoi(argv[i])+1;                 }                break;
             } 0           if (strncmp("stereo",option+1,4) == 0)
             { &               stereo=(*option == '-');               break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 't': 	         { .           if (strncmp("tile",option+1,2) == 0)
             { $               tile=(*option == '-');               break;
             } @           MagickError(OptionError,"Unrecognized option",option);3           if (strncmp("treedepth",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing depth",option);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'v': 	         { 1           if (strncmp("verbose",option+1,2) == 0) 
             { 2               image_info.verbose=(*option == '-');               break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'w': 	         { 7           if (Latin1Compare("watermark",option+1) == 0) 
             { /               watermark_geometry=(char *) NULL; !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))G                     MagickError(OptionError,"Missing geometry",option); B                   (void) CloneString(&watermark_geometry,argv[i]);.                   compose=ModulateCompositeOp;                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case '?': 	         {            Usage(client_name);            break;	         }          default:	         { @           MagickError(OptionError,"Unrecognized option",option);           break;	         }        }    } G   if ((image == (Image *) NULL) || (composite_image == (Image *) NULL))      Usage(client_name); #   if (mask_image != (Image *) NULL)      { M       CompositeImage(composite_image,ReplaceMatteCompositeOp,mask_image,0,0);        DestroyImage(mask_image);      } "   if (compose == BlendCompositeOp)     { 
       Quantum          opacity;         register PixelPacket         *q;          /*#         Create mattes for blending.        */       opacity=(unsigned short)B         (DownScale(MaxRGB)-(((int) DownScale(MaxRGB)*blend)/100));       image->class=DirectClass;        image->matte=True;+       for (y=0; y < (int) image->rows; y++)        { 7         if (!GetPixelCache(image,0,y,image->columns,1))            break;         q=image->pixels;0         for (x=0; x < (int) image->columns; x++)	         {            q->opacity=opacity;            q++;	         } #         if (!SyncPixelCache(image))            break;       } ;       opacity=(unsigned short) (DownScale(MaxRGB)-opacity); )       composite_image->class=DirectClass; "       composite_image->matte=True;5       for (y=0; y < (int) composite_image->rows; y++)        { K         if (!GetPixelCache(composite_image,0,y,composite_image->columns,1))            break;         q=image->pixels;:         for (x=0; x < (int) composite_image->columns; x++)	         {            q->opacity=opacity;            q++;	         } -         if (!SyncPixelCache(composite_image))            break;       }      } %   if (compose == DisplaceCompositeOp) 4     composite_image->geometry=displacement_geometry;%   if (compose == ModulateCompositeOp) 1     composite_image->geometry=watermark_geometry;    /*     Combine image.   */   if (stegano != 0)      {        image->offset=stegano-1;9       combined_image=SteganoImage(image,composite_image);      }    else     if (stereo) 8       combined_image=StereoImage(image,composite_image);     else       if (tile) 	         {            /*%             Tile the composite image.            */D           for (y=0; y < (int) image->rows; y+=composite_image->rows)L             for (x=0; x < (int) image->columns; x+=composite_image->columns)@               CompositeImage(image,compose,composite_image,x,y);           combined_image=image; 	         } 
       else	         {            unsigned int             size;              /*&             Digitally composite image.           */           size=0;            x=0;           y=0;(           if (geometry != (char *) NULL)B             (void) ParseImageGeometry(geometry,&x,&y,&size,&size);           switch (gravity)           { "             case NorthWestGravity:               break;             case NorthGravity:
             { @               x+=(image->columns-composite_image->columns) >> 1;               break;
             } "             case NorthEastGravity:
             { 9               x+=image->columns-composite_image->columns;                break;
             }              case WestGravity: 
             { :               y+=(image->rows-composite_image->rows) >> 1;               break;
             }              case ForgetGravity: 
             {                char(                 geometry[MaxTextExtent];                 /*@                 Stretch composite to the same size as the image.               */L               FormatString(geometry,"%ux%u+0+0",image->columns,image->rows);F               TransformImage(&composite_image,(char *) NULL,geometry);               break;
             }              case StaticGravity:              case CenterGravity:              default:
             { @               x+=(image->columns-composite_image->columns) >> 1;:               y+=(image->rows-composite_image->rows) >> 1;               break;
             }              case EastGravity: 
             { 9               x+=image->columns-composite_image->columns; :               y+=(image->rows-composite_image->rows) >> 1;               break;
             } "             case SouthWestGravity:
             { 3               y+=image->rows-composite_image->rows;                break;
             }              case SouthGravity:
             { @               x+=(image->columns-composite_image->columns) >> 1;3               y+=image->rows-composite_image->rows;                break;
             } "             case SouthEastGravity:
             { 9               x+=image->columns-composite_image->columns; 3               y+=image->rows-composite_image->rows;                break;
             }            } <           CompositeImage(image,compose,composite_image,x,y);           combined_image=image; 	         } '   if (combined_image == (Image *) NULL) H     MagickError(OptionError,"Missing an image file name",(char *) NULL);   /*B     Transmogrify image as defined by the image processing options.   */9   CommentImage(combined_image,composite_image->comments); 6   MogrifyImage(&image_info,argc,argv,&combined_image);   /*     Write image.   */9   (void) strcpy(combined_image->filename,write_filename); !   SetImageInfo(&image_info,True); 0   status=WriteImage(&image_info,combined_image);   if (image_info.verbose) /     DescribeImage(combined_image,stderr,False);     DestroyImages(combined_image);   DestroyDelegateInfo();   DestroyMagickInfo();   FreeMemory(argv);    Exit(status ? 0 : errno);    return(False); } 