 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                CCCC   OOO   N   N  V   V  EEEEE  RRRR   TTTTT               % O %               C      O   O  NN  N  V   V  E      R   R    T                 % O %               C      O   O  N N N  V   V  EEE    RRRR     T                 % O %               C      O   O  N  NN   V V   E      R R      T                 % O %                CCCC   OOO   N   N    V    EEEEE  R  R     T                 % O %                                                                             % O %                                                                             % O %                Convert an image from one format to another.                 % O %                                                                             % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                April 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Convert converts an input file using one image format to an output file! %  with a differing image format.  % ! %  The convert program syntax is:  % = %  Usage: convert [options ...] file [ files... ] output_file  %  %  Where options include: D %    -adjoin              join images into a single multi-image file/ %    -antialias           remove pixel-aliasing 2 %    -append              append an image sequence3 %    -average             average an image sequence : %    -blur factor         apply a filter to blur the image? %    -border geometry     surround image with a border of color & %    -bordercolor color   border color; %    -box color           color for annotation bounding box J %    -cache threshold     number of megabytes available to the pixel cache5 %    -charcoal factor     simulate a charcoal drawing 4 %    -coalesce            merge a sequence of images? %    -colorize value      colorize the image with the pen color A %    -colors value        preferred number of colors in the image 4 %    -colorspace type     alternate image colorspace5 %    -comment string      annotate image with comment 3 %    -compress type       type of image compression > %    -contrast            enhance or reduce the image contrastJ %    -crop geometry       preferred size and location of the cropped image2 %    -cycle amount        cycle the image colormapM %    -deconstruct         break down an image sequence into constituent parts > %    -delay value         display the next image after pausingF %    -density geometry    vertical and horizontal density of the image, %    -depth value         depth of the image> %    -despeckle           reduce the speckles within an image"A %    -display server      obtain image or font from this X server - %    -dispose method      GIF disposal method H %    -dither              apply Floyd/Steinberg error diffusion to imageE %    -draw string         annotate the image with a graphic primitive E %    -edge factor         apply a filter to detect edges in the image ) %    -emboss              emboss an image I %    -enhance             apply a digital filter to enhance a noisy image D %    -equalize            perform histogram equalization to an image@ %    -filter type         use this filter when resizing an image> %    -flip                flip image in the vertical direction@ %    -flop                flop image in the horizontal direction6 %    -font name           X11 font for displaying textB %    -frame geometry      surround image with an ornamental borderJ %    -fuzz distance       colors within this distance are considered equal3 %    -gamma value         level of gamma correction A %    -geometry geometry   perferred size or location of the image @ %    -gravity type        vertical and horizontal text placement? %    -implode amount      implode image pixels about the center 9 %    -interlace type      None, Line, Plane, or Partition 4 %    -label name          assign a label to an image1 %    -layer type          Red, Green, Blue, Matte 1 %    -linewidth value     width of line in pixels K %    -loop iterations     add Netscape loop extension to your GIF animation L %    -map filename        transform image colors to match this set of colorsB %    -matte               store matte channel if the image has one< %    -median radius       apply a median filter to the imageA %    -modulate value      vary the brightness, saturation and hue < %    -monochrome          transform image to black and white1 %    -morph value         morph an image sequence A %    -mosaic              create an mosaic from an image sequence J %    -negate              replace every pixel with its complementary color9 %    -noise               add or reduce noise in an image J %    -normalize           transform image to span the full range of colors< %    -opaque color        change this color to the pen color> %    -page geometry       size and location of an image canvas2 %    -paint radius        simulate an oil paintingG %    -pen color           color for annotating or changing opaque color E %    -ping                efficiently determine image characteristics 6 %    -pointsize value     pointsize of Postscript font, %    -preview type        image preview typeF %    -profile filename    add ICC or IPTC information profile to image9 %    -quality value       JPEG/MIFF/PNG compression level K %    -raise value         lighten/darken image edges to create a 3-D effect A %    -region geometry     apply options to a portion of the image B %    -roll geometry       roll an image vertically or horizontally; %    -rotate degrees      apply Paeth rotation to the image 9 %    -sample geometry     scale image with pixel sampling , %    -scene value         image scene numberC %    -seed value          pseudo-random number generator seed value * %    -segment values      segment an imageF %    -shade degrees       shade the image using a distant light source= %    -sharpen factor      apply a filter to sharpen the image K %    -shear geometry      slide one edge of the image along the X or Y axis 3 %    -size geometry       width and height of image F %    -solarize threshold   negate all pixels above the threshold levelB %    -spread amount       displace image pixels by a random amount= %    -swirl degrees       swirl image pixels about the center K %    -texture filename    name of texture to tile onto the image background - %    -threshold value     threshold the image F %    -transparent color   make this color transparent within the image@ %    -treedepth value     depth of the color classification treeJ %    -units type          PixelsPerInch, PixelsPerCentimeter, or UndefinedD %    -verbose             print detailed information about the image5 %    -view                FlashPix viewing transforms : %    -wave geometry       alter an image along a sine wave % D %  By default, the image format of `file' is determined by its magicF %  number.  To specify a particular image format, precede the filenameG %  with an image format name and a colon (i.e. ps:image) or specify the H %  image type as the filename suffix (i.e. image.ps).  Specify 'file' as$ %  '-' for standard input or output. %  %  */   /*   Include declarations.  */ #include "magick/magick.h" #include "magick/defines.h"    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method ConcatentateImages reads each file in sequence and writes it to a ; %  single file.  It is required by the delegates subsystem.  % 2 %  The format of the ConcatentateImages method is: % 3 %      void ConcatenateImages(int argc,char **argv)  % + %  A description of each parameter follows:  % G %    o argc: Specifies a pointer to an integer describing the number of ' %      elements in the argument vector.  % L %    o argv: Specifies a pointer to a text array containing the command line %      arguments.  %  %  */3 static void ConcatenateImages(int argc,char **argv)  {    FILE     *input,      *output;     register int     c,     i;     /*     Open output file.    */"   output=fopen(argv[argc-1],"wb");   if (output == (FILE *) NULL)B     MagickError(FileOpenError,"Unable to open file",argv[argc-1]);   for (i=2; i < (argc-1); i++)   {      input=fopen(argv[i],"rb");     if (input == (FILE *) NULL)        { E         MagickWarning(FileOpenWarning,"Unable to open file",argv[i]);          continue;        } 2     for (c=fgetc(input); c != EOF; c=fgetc(input))$       (void) fputc((char) c,output);     (void) fclose(input);      (void) remove(argv[i]);    }    (void) fclose(output);
   Exit(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % . %  Procedure Usage displays the program usage; % % %  The format of the Usage method is:  % * %      void Usage(const char *client_name) % J %    o client_name: a character string representing the name of the client %      program.  %  %  */* static void Usage(const char *client_name) {    const char     **p;     static const char      *options[]=      { H       "-adjoin              join images into a single multi-image file",3       "-antialias           remove pixel-aliasing", 6       "-append              append an image sequence",7       "-average             average an image sequence", >       "-blur factor         apply a filter to blur the image",C       "-border geometry     surround image with a border of color", *       "-bordercolor color   border color",?       "-box color           color for annotation bounding box", 9       "-charcoal factor     simulate a charcoal drawing", 8       "-coalesce            merge a sequence of images",C       "-colorize value      colorize the image with the pen color", E       "-colors value        preferred number of colors in the image", 8       "-colorspace type     alternate image colorspace",9       "-comment string      annotate image with comment", 7       "-compress type       type of image compression", B       "-contrast            enhance or reduce the image contrast",N       "-crop geometry       preferred size and location of the cropped image",6       "-cycle amount        cycle the image colormap",B       "-delay value         display the next image after pausing",Q       "-deconstruct         break down an image sequence into constituent parts", J       "-density geometry    vertical and horizontal density of the image",0       "-depth value         depth of the image",A       "-despeckle           reduce the speckles within an image", E       "-display server      obtain image or font from this X server", 1       "-dispose method      GIF disposal method", L       "-dither              apply Floyd/Steinberg error diffusion to image",I       "-draw string         annotate the image with a graphic primitive", I       "-edge factor         apply a filter to detect edges in the image", -       "-emboss              emboss an image", M       "-enhance             apply a digital filter to enhance a noisy image", H       "-equalize            perform histogram equalization to an image",D       "-filter type         use this filter when resizing an image",B       "-flip                flip image in the vertical direction",D       "-flop                flop image in the horizontal direction",:       "-font name           X11 font for displaying text",F       "-frame geometry      surround image with an ornamental border",N       "-fuzz distance       colors within this distance are considered equal",7       "-gamma value         level of gamma correction", E       "-geometry geometry   perferred size or location of the image", D       "-gravity type        vertical and horizontal text placement",C       "-implode amount      implode image pixels about the center", =       "-interlace type      None, Line, Plane, or Partition", 8       "-label name          assign a label to an image",5       "-layer type          Red, Green, Blue, Matte", 5       "-linewidth value     width of line in pixels", 8       "-label name          assign a label to an image",O       "-loop iterations     add Netscape loop extension to your GIF animation", P       "-map filename        transform image colors to match this set of colors",F       "-matte               store matte channel if the image has one",@       "-median radius       apply a median filter to the image",F       "-modulate value      vary the brightness, saturation, and hue",@       "-monochrome          transform image to black and white",5       "-morph value         morph an image sequence", E       "-mosaic              create an mosaic from an image sequence", O       "-negate              replace every pixel with its complementary color ", =       "-noise               add or reduce noise in an image", N       "-normalize           transform image to span the full range of colors",@       "-opaque color        change this color to the pen color",B       "-page geometry       size and location of an image canvas",6       "-paint radius        simulate an oil painting",K       "-pen color           color for annotating or changing opaque color", I       "-ping                efficiently determine image characteristics", :       "-pointsize value     pointsize of Postscript font",0       "-preview type        image preview type",J       "-profile filename    add ICC or IPTC information profile to image",=       "-quality value       JPEG/MIFF/PNG compression level", O       "-raise value         lighten/darken image edges to create a 3-D effect", E       "-region geometry     apply options to a portion of the image", F       "-roll geometry       roll an image vertically or horizontally",?       "-rotate degrees      apply Paeth rotation to the image", =       "-sample geometry     scale image with pixel sampling", 0       "-scene value         image scene number",.       "-segment values      segment an image",G       "-seed value          pseudo-random number generator seed value", J       "-shade degrees       shade the image using a distant light source",A       "-sharpen factor      apply a filter to sharpen the image", O       "-shear geometry      slide one edge of the image along the X or Y axis", 7       "-size geometry       width and height of image", J       "-solarize threshold   negate all pixels above the threshold level",F       "-spread amount       displace image pixels by a random amount",A       "-swirl degrees       swirl image pixels about the center", O       "-texture filename    name of texture to tile onto the image background", 1       "-threshold value     threshold the image", J       "-transparent color   make this color transparent within the image",D       "-treedepth value     depth of the color classification tree",<       "-units type          Inch, Centimeter, or Undefined",H       "-verbose             print detailed information about the image",9       "-view                FlashPix viewing transforms", >       "-wave geometry       alter an image along a sine wave",       (char *) NULL      };  4   (void) printf("Version: %.1024s\n",MagickVersion);:   (void) printf("Copyright: %.1024s\n\n",MagickCopyright);O   (void) printf("Usage: %.1024s [options ...] file [ files... ] output_file\n",      client_name); .   (void) printf("\nWhere options include:\n");+   for (p=options; *p != (char *) NULL; p++) $     (void) printf("  %.1024s\n",*p);   (void) printf(M     "\nBy default, the image format of `file' is determined by its magic\n");    (void) printf(M     "number.  To specify a particular image format, precede the filename\n");    (void) printf(N     "with an image format name and a colon (i.e. ps:image) or specify the\n");   (void) printf(O     "image type as the filename suffix (i.e. image.ps).  Specify 'file' as\n"); 7   (void) printf("'-' for standard input or output.\n");     ListMagickInfo((FILE *) NULL);"   ListDelegateInfo((FILE *) NULL);
   Exit(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  M a i n                                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */ int main(int argc,char **argv) { + #define NotInitialized  (unsigned int) (~0)      char     *client_name,      *filename,     *option;     double	     sans;      Image      *image,      *next_image;     ImageInfo      image_info;      int      append,      gravity,     status,      x;     register Image     *p;      register int     i;     unsigned int     average,
     coalesce,      deconstruct,
     morph,     mosaic,      global_colormap,
     scene;     /*&     Initialize command line arguments.   */   ReadCommandlLine(argc,&argv); #   client_name=SetClientName(*argv); &   (void) ExpandFilenames(&argc,&argv);   if (argc < 3)      Usage(client_name);    /*     Set defaults.    */   append=0;    average=False;   coalesce=False;    deconstruct=False;
   morph=0;   mosaic=False;    filename=(char *) NULL;    global_colormap=False;   image=(Image *) NULL;    GetImageInfo(&image_info);   option=(char *) NULL; 
   scene=0;   /*!     Parse command-line arguments.    */:   if ((argc > 2) && (strcmp("-concatenate",argv[1]) == 0))!     ConcatenateImages(argc,argv);    for (i=1; i < (argc-1); i++)   {      option=argv[i]; G     if ((Extent(option) < 2) || ((*option != '-') && (*option != '+')))        { 
         /*           Read input image. 
         */         filename=argv[i]; 4         (void) strcpy(image_info.filename,filename);*         next_image=ReadImage(&image_info);)         if (next_image == (Image *) NULL)            continue; 6         MogrifyImages(&image_info,i,argv,&next_image);$         if (image == (Image *) NULL)           image=next_image;          else           {              /*)               Link image into image list.              */@             for (p=image; p->next != (Image *) NULL; p=p->next);#             next_image->previous=p;              p->next=next_image;            }        }      else       switch(*(option+1))        {          case 'a': 	         { 0           if (strncmp("adjoin",option+1,2) == 0)
             { 1               image_info.adjoin=(*option == '-');                break;
             } 3           if (strncmp("antialias",option+1,3) == 0) 
             { 4               image_info.antialias=(*option == '-');               break;
             } 0           if (strncmp("append",option+1,2) == 0)
             { /               append=(*option) == '-' ? 1 : -1;                break;
             } 1           if (strncmp("average",option+1,2) == 0) 
             { '               average=(*option == '-');                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'b': 	         { 4           if (strncmp("background",option+1,5) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)O                     MagickError(OptionError,"Missing background color",option); 4                   (void) QueryColorDatabase(argv[i],2                     &image_info.background_color);                 }                break;
             } .           if (strncmp("blur",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))E                     MagickError(OptionError,"Missing factor",option);                  }                break;
             } 0           if (strncmp("border",option+1,7) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } 5           if (strncmp("bordercolor",option+1,7) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)K                     MagickError(OptionError,"Missing border color",option); N                   (void) QueryColorDatabase(argv[i],&image_info.border_color);                 }                break;
             } -           if (strncmp("box",option+1,3) == 0) 
             { +               image_info.box=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     MagickError(OptionError,"Missing box color",option);>                   (void) CloneString(&image_info.box,argv[i]);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'c': 	         { /           if (strncmp("cache",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))H                     MagickError(OptionError,"Missing threshold",option);                 }                break;
             } 2           if (strncmp("charcoal",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))E                     MagickError(OptionError,"Missing factor",option);                  }                break;
             } 2           if (strncmp("coalesce",option+1,3) == 0)
             { (               coalesce=(*option == '-');               break;
             } 2           if (strncmp("colorize",option+1,7) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing value",option);                 }                break;
             } 0           if (strncmp("colors",option+1,7) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing colors",option);                  }                break;
             } 4           if (strncmp("colorspace",option+1,7) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; <                   image_info.colorspace=UndefinedColorspace;8                   if (Latin1Compare("cmyk",option) == 0)9                     image_info.colorspace=CMYKColorspace; 8                   if (Latin1Compare("gray",option) == 0)9                     image_info.colorspace=GRAYColorspace; 8                   if (Latin1Compare("ohta",option) == 0)9                     image_info.colorspace=OHTAColorspace; 7                   if (Latin1Compare("rgb",option) == 0) 8                     image_info.colorspace=RGBColorspace;8                   if (Latin1Compare("srgb",option) == 0)9                     image_info.colorspace=sRGBColorspace; ?                   if (Latin1Compare("transparent",option) == 0) @                     image_info.colorspace=TransparentColorspace;7                   if (Latin1Compare("xyz",option) == 0) 8                     image_info.colorspace=XYZColorspace;9                   if (Latin1Compare("ycbcr",option) == 0) :                     image_info.colorspace=YCbCrColorspace;7                   if (Latin1Compare("ycc",option) == 0) 8                     image_info.colorspace=YCCColorspace;7                   if (Latin1Compare("yiq",option) == 0) 8                     image_info.colorspace=YIQColorspace;9                   if (Latin1Compare("ypbpr",option) == 0) :                     image_info.colorspace=YPbPrColorspace;7                   if (Latin1Compare("yuv",option) == 0) 8                     image_info.colorspace=YUVColorspace;C                   if (image_info.colorspace == UndefinedColorspace) N                     MagickError(OptionError,"Invalid colorspace type",option);                 }                break;
             } 1           if (strncmp("comment",option+1,4) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)F                     MagickError(OptionError,"Missing comment",option);                 }                break;
             } 2           if (strncmp("compress",option+1,5) == 0)
             { 3               image_info.compression=NoCompression; !               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; >                   image_info.compression=UndefinedCompression;8                   if (Latin1Compare("None",option) == 0)9                     image_info.compression=NoCompression; 8                   if (Latin1Compare("BZip",option) == 0);                     image_info.compression=BZipCompression; 7                   if (Latin1Compare("Fax",option) == 0) :                     image_info.compression=FaxCompression;:                   if (Latin1Compare("Group4",option) == 0)=                     image_info.compression=Group4Compression; 8                   if (Latin1Compare("JPEG",option) == 0);                     image_info.compression=JPEGCompression; 7                   if (Latin1Compare("LZW",option) == 0) :                     image_info.compression=LZWCompression;D                   if (Latin1Compare("RunlengthEncoded",option) == 0)G                     image_info.compression=RunlengthEncodedCompression; 7                   if (Latin1Compare("Zip",option) == 0) :                     image_info.compression=ZipCompression;E                   if (image_info.compression == UndefinedCompression) O                     MagickError(OptionError,"Invalid compression type",option);                  }                break;
             } 2           if (strncmp("contrast",option+1,3) == 0)             break;.           if (strncmp("crop",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } /           if (strncmp("cycle",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing amount",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'd': 	         { 5           if (strncmp("deconstruct",option+1,3) == 0) 
             { +               deconstruct=(*option == '-');                break;
             } /           if (strncmp("delay",option+1,3) == 0) 
             { -               image_info.delay=(char *) NULL; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing delay",option);?                   image_info.delay=PostscriptGeometry(argv[i]);                  }                break;
             } 1           if (strncmp("density",option+1,3) == 0) 
             { /               image_info.density=(char *) NULL; !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option); B                   (void) CloneString(&image_info.density,argv[i]);                 }                break;
             } /           if (strncmp("depth",option+1,3) == 0) 
             { ,               image_info.depth=QuantumDepth;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))J                     MagickError(OptionError,"Missing image depth",option);1                   image_info.depth=atoi(argv[i]);                  }                break;
             } 3           if (strncmp("despeckle",option+1,3) == 0)              break;5           if (Latin1Compare("display",option+1) == 0) 
             { 3               image_info.server_name=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)J                     MagickError(OptionError,"Missing server name",option);F                   (void) CloneString(&image_info.server_name,argv[i]);                 }                break;
             } 1           if (strncmp("dispose",option+1,5) == 0) 
             { /               image_info.dispose=(char *) NULL; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing method",option); A                   image_info.dispose=PostscriptGeometry(argv[i]);                  }                break;
             } 0           if (strncmp("dither",option+1,3) == 0)
             { 1               image_info.dither=(*option == '-');                break;
             } .           if (strncmp("draw",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     MagickError(OptionError,"Missing primitive",option);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'e': 	         { .           if (strncmp("edge",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))E                     MagickError(OptionError,"Missing factor",option);                  }                break;
             } 0           if (strncmp("emboss",option+1,2) == 0)             break;1           if (strncmp("enhance",option+1,2) == 0)              break;2           if (strncmp("equalize",option+1,2) == 0)             break;@           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'f': 	         { 0           if (strncmp("filter",option+1,3) == 0)
             { !               if (*option == '-')                  {                    FilterType                     filter;                      i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; )                   filter=UndefinedFilter; 9                   if (Latin1Compare("Point",option) == 0) '                     filter=PointFilter; 7                   if (Latin1Compare("Box",option) == 0) %                     filter=BoxFilter; <                   if (Latin1Compare("Triangle",option) == 0)*                     filter=TriangleFilter;;                   if (Latin1Compare("Hermite",option) == 0) )                     filter=HermiteFilter; ;                   if (Latin1Compare("Hanning",option) == 0) )                     filter=HanningFilter; ;                   if (Latin1Compare("Hamming",option) == 0) )                     filter=HammingFilter; <                   if (Latin1Compare("Blackman",option) == 0)*                     filter=BlackmanFilter;<                   if (Latin1Compare("Gaussian",option) == 0)*                     filter=GaussianFilter;=                   if (Latin1Compare("Quadratic",option) == 0) +                     filter=QuadraticFilter; 9                   if (Latin1Compare("Cubic",option) == 0) '                     filter=CubicFilter; :                   if (Latin1Compare("Catrom",option) == 0)(                     filter=CatromFilter;<                   if (Latin1Compare("Mitchell",option) == 0)*                     filter=MitchellFilter;;                   if (Latin1Compare("Lanczos",option) == 0) )                     filter=LanczosFilter; :                   if (Latin1Compare("Bessel",option) == 0)(                     filter=BesselFilter;8                   if (Latin1Compare("Sinc",option) == 0)&                     filter=SincFilter;0                   if (filter == UndefinedFilter)J                     MagickError(OptionError,"Invalid filter type",option);                 }                break;
             } .           if (strncmp("flip",option+1,3) == 0)             break;.           if (strncmp("flop",option+1,3) == 0)             break;.           if (strncmp("font",option+1,2) == 0)
             { ,               image_info.font=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)H                     MagickError(OptionError,"Missing font name",option);?                   (void) CloneString(&image_info.font,argv[i]);                  }                break;
             } /           if (strncmp("frame",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } .           if (strncmp("fuzz",option+1,2) == 0)
             {                 image_info.fuzz=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     MagickError(OptionError,"Missing distance",option); 0                   image_info.fuzz=atoi(argv[i]);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'g': 	         { /           if (strncmp("gamma",option+1,2) == 0) 
             {                i++;>               if ((i == argc) || !sscanf(argv[i],"%lf",&sans))@                 MagickError(OptionError,"Missing value",option);               break;
             } 2           if (strncmp("geometry",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } 1           if (strncmp("gravity",option+1,2) == 0) 
             { $               gravity=ForgetGravity;!               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; =                   if (Latin1Compare("NorthWest",option) == 0) -                     gravity=NorthWestGravity; 9                   if (Latin1Compare("North",option) == 0) )                     gravity=NorthGravity; =                   if (Latin1Compare("NorthEast",option) == 0) -                     gravity=NorthEastGravity; 8                   if (Latin1Compare("West",option) == 0)(                     gravity=WestGravity;:                   if (Latin1Compare("Center",option) == 0)*                     gravity=CenterGravity;8                   if (Latin1Compare("East",option) == 0)(                     gravity=EastGravity;=                   if (Latin1Compare("SouthWest",option) == 0) -                     gravity=SouthWestGravity; 9                   if (Latin1Compare("South",option) == 0) )                     gravity=SouthGravity; =                   if (Latin1Compare("SouthEast",option) == 0) -                     gravity=SouthEastGravity; /                   if (gravity == ForgetGravity) K                     MagickError(OptionError,"Invalid gravity type",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'h': 	         { .           if (strncmp("help",option+1,2) == 0)
             { !               Usage(client_name);                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'i': 	         { 1           if (strncmp("implode",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))E                     MagickError(OptionError,"Missing amount",option);                  }                break;
             } 3           if (strncmp("interlace",option+1,3) == 0) 
             { /               image_info.interlace=NoInterlace; !               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; :                   image_info.interlace=UndefinedInterlace;8                   if (Latin1Compare("None",option) == 0)5                     image_info.interlace=NoInterlace; 8                   if (Latin1Compare("Line",option) == 0)7                     image_info.interlace=LineInterlace; 9                   if (Latin1Compare("Plane",option) == 0) 8                     image_info.interlace=PlaneInterlace;=                   if (Latin1Compare("Partition",option) == 0) <                     image_info.interlace=PartitionInterlace;A                   if (image_info.interlace == UndefinedInterlace) M                     MagickError(OptionError,"Invalid interlace type",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);	         }          case 'l': 	         { /           if (strncmp("label",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)I                     MagickError(OptionError,"Missing label name",option);                  }                break;
             } /           if (strncmp("layer",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    LayerType                      layer;                     i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; '                   layer=UndefinedLayer; 7                   if (Latin1Compare("Red",option) == 0) #                     layer=RedLayer; 9                   if (Latin1Compare("Green",option) == 0) %                     layer=GreenLayer; 8                   if (Latin1Compare("Blue",option) == 0)$                     layer=BlueLayer;9                   if (Latin1Compare("Matte",option) == 0) %                     layer=MatteLayer; .                   if (layer == UndefinedLayer)I                     MagickError(OptionError,"Invalid layer type",option);                  }                break;
             } 3           if (strncmp("linewidth",option+1,2) == 0) 
             { %               image_info.linewidth=1; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))C                     MagickError(OptionError,"Missing size",option); 5                   image_info.linewidth=atoi(argv[i]);                  }                break;
             } .           if (strncmp("loop",option+1,2) == 0)
             { 2               image_info.iterations=(char *) NULL;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     MagickError(OptionError,"Missing iterations",option); D                   image_info.iterations=PostscriptGeometry(argv[i]);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'm': 	         { -           if (strncmp("map",option+1,3) == 0) 
             { /               global_colormap=(*option == '+'); !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     MagickError(OptionError,"Missing file name",option);                 }                break;
             } 3           if (Latin1Compare("matte",option+1) == 0)              break;4           if (strncmp("mattecolor",option+1,6) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)J                     MagickError(OptionError,"Missing matte color",option);M                   (void) QueryColorDatabase(argv[i],&image_info.matte_color);                  }                break;
             } 0           if (strncmp("median",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing radius",option);                  }                break;
             } 2           if (strncmp("modulate",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))D                     MagickError(OptionError,"Missing value",option);                 }                break;
             } 4           if (strncmp("monochrome",option+1,4) == 0)
             { 5               image_info.monochrome=(*option == '-');                break;
             } /           if (strncmp("morph",option+1,3) == 0) 
             {                morph=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing frames",option); &                   morph=atoi(argv[i]);                 }                break;
             } 0           if (strncmp("mosaic",option+1,3) == 0)
             { &               mosaic=(*option == '-');               break;
             } @           MagickError(OptionError,"Unrecognized option",option);	         }          case 'n': 	         { 0           if (strncmp("negate",option+1,3) == 0)             break;/           if (strncmp("noise",option+1,3) == 0) 
             { !               if (*option == '+')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; ?                   if ((Latin1Compare("Uniform",option) != 0) && @                       (Latin1Compare("Gaussian",option) != 0) &&F                       (Latin1Compare("Multiplicative",option) != 0) &&?                       (Latin1Compare("Impulse",option) != 0) && A                       (Latin1Compare("Laplacian",option) != 0) && =                       (Latin1Compare("Poisson",option) != 0)) I                     MagickError(OptionError,"Invalid noise type",option);                  }                break;
             } 3           if (strncmp("normalize",option+1,3) == 0)              break;@           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'o': 	         { 0           if (strncmp("opaque",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)K                     MagickError(OptionError,"Missing opaque color",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'p': 	         { .           if (strncmp("page",option+1,3) == 0)
             { ,               image_info.page=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)L                     MagickError(OptionError,"Missing page geometry",option);>                   image_info.page=PostscriptGeometry(argv[i]);                 }                break;
             } /           if (strncmp("paint",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing radius",option);                  }                break;
             } -           if (strncmp("pen",option+1,2) == 0) 
             { +               image_info.pen=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     MagickError(OptionError,"Missing pen color",option);>                   (void) CloneString(&image_info.pen,argv[i]);                 }                break;
             } .           if (strncmp("ping",option+1,2) == 0)
             { /               image_info.ping=(*option == '-');                break;
             } 3           if (strncmp("pointsize",option+1,2) == 0) 
             { &               image_info.pointsize=12;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))C                     MagickError(OptionError,"Missing size",option); 5                   image_info.pointsize=atof(argv[i]);                  }                break;
             } 1           if (strncmp("preview",option+1,3) == 0) 
             { 7               image_info.preview_type=UndefinedPreview; !               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; ;                   image_info.preview_type=UndefinedPreview; :                   if (Latin1Compare("Rotate",option) == 0):                     image_info.preview_type=RotatePreview;9                   if (Latin1Compare("Shear",option) == 0) 9                     image_info.preview_type=ShearPreview; 8                   if (Latin1Compare("Roll",option) == 0)8                     image_info.preview_type=RollPreview;7                   if (Latin1Compare("Hue",option) == 0) 7                     image_info.preview_type=HuePreview; >                   if (Latin1Compare("Saturation",option) == 0)>                     image_info.preview_type=SaturationPreview;>                   if (Latin1Compare("Brightness",option) == 0)>                     image_info.preview_type=BrightnessPreview;9                   if (Latin1Compare("Gamma",option) == 0) 9                     image_info.preview_type=GammaPreview; 9                   if (Latin1Compare("Spiff",option) == 0) 9                     image_info.preview_type=SpiffPreview; 8                   if (Latin1Compare("Dull",option) == 0)8                     image_info.preview_type=DullPreview;=                   if (Latin1Compare("Grayscale",option) == 0) =                     image_info.preview_type=GrayscalePreview; <                   if (Latin1Compare("Quantize",option) == 0)<                     image_info.preview_type=QuantizePreview;=                   if (Latin1Compare("Despeckle",option) == 0) =                     image_info.preview_type=DespecklePreview; ?                   if (Latin1Compare("ReduceNoise",option) == 0) ?                     image_info.preview_type=ReduceNoisePreview; <                   if (Latin1Compare("AddNoise",option) == 0)<                     image_info.preview_type=AddNoisePreview;;                   if (Latin1Compare("Sharpen",option) == 0) ;                     image_info.preview_type=SharpenPreview; 8                   if (Latin1Compare("Blur",option) == 0)8                     image_info.preview_type=BlurPreview;=                   if (Latin1Compare("Threshold",option) == 0) =                     image_info.preview_type=ThresholdPreview; >                   if (Latin1Compare("EdgeDetect",option) == 0)>                     image_info.preview_type=EdgeDetectPreview;:                   if (Latin1Compare("Spread",option) == 0):                     image_info.preview_type=SpreadPreview;9                   if (Latin1Compare("Shade",option) == 0) 9                     image_info.preview_type=ShadePreview; 9                   if (Latin1Compare("Raise",option) == 0) 9                     image_info.preview_type=RaisePreview; ;                   if (Latin1Compare("Segment",option) == 0) ;                     image_info.preview_type=SegmentPreview; <                   if (Latin1Compare("Solarize",option) == 0)<                     image_info.preview_type=SolarizePreview;9                   if (Latin1Compare("Swirl",option) == 0) 9                     image_info.preview_type=SwirlPreview; ;                   if (Latin1Compare("Implode",option) == 0) ;                     image_info.preview_type=ImplodePreview; 8                   if (Latin1Compare("Wave",option) == 0)8                     image_info.preview_type=WavePreview;<                   if (Latin1Compare("OilPaint",option) == 0)<                     image_info.preview_type=OilPaintPreview;C                   if (Latin1Compare("CharcoalDrawing",option) == 0) C                     image_info.preview_type=CharcoalDrawingPreview; 8                   if (Latin1Compare("JPEG",option) == 0)8                     image_info.preview_type=JPEGPreview;B                   if (image_info.preview_type == UndefinedPreview)M                     MagickError(OptionError,"Invalid interlace type",option);                  }                break;
             } 1           if (strncmp("profile",option+1,4) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)F                     MagickError(OptionError,"Missing profile",option);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);	         }          case 'q': 	         { 1           if (strncmp("quality",option+1,2) == 0) 
             { $               image_info.quality=75;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     MagickError(OptionError,"Missing quality",option);3                   image_info.quality=atoi(argv[i]);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'r': 	         { /           if (strncmp("raise",option+1,2) == 0) 
             {                i++;:               if ((i == argc) || !sscanf(argv[i],"%d",&x))F                 MagickError(OptionError,"Missing bevel width",option);               break;
             } 0           if (strncmp("region",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } .           if (strncmp("roll",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } 0           if (strncmp("rotate",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))F                     MagickError(OptionError,"Missing degrees",option);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 's': 	         { 0           if (strncmp("sample",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } /           if (strncmp("scene",option+1,3) == 0) 
             {                scene=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))K                     MagickError(OptionError,"Missing scene number",option);                  } "               scene=atoi(argv[i]);               break;
             } .           if (strncmp("seed",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing value",option);                 } 2               srand((unsigned int) atoi(argv[i]));               break;
             } 1           if (strncmp("segment",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))H                     MagickError(OptionError,"Missing threshold",option);                 }                break;
             } /           if (strncmp("shade",option+1,5) == 0) 
             {                i++;:               if ((i == argc) || !sscanf(argv[i],"%d",&x))B                 MagickError(OptionError,"Missing azimuth",option);               break;
             } 1           if (strncmp("sharpen",option+1,5) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))E                     MagickError(OptionError,"Missing factor",option);                  }                break;
             } /           if (strncmp("shear",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } .           if (strncmp("size",option+1,2) == 0)
             { ,               image_info.size=(char *) NULL;!               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option); ?                   (void) CloneString(&image_info.size,argv[i]);                  }                break;
             } 2           if (strncmp("solarize",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))H                     MagickError(OptionError,"Missing threshold",option);                 }                break;
             } 0           if (strncmp("spread",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing amount",option);                  }                break;
             } /           if (strncmp("swirl",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))F                     MagickError(OptionError,"Missing degrees",option);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 't': 	         { 1           if (strncmp("texture",option+1,5) == 0) 
             { /               image_info.texture=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)G                     MagickError(OptionError,"Missing filename",option); B                   (void) CloneString(&image_info.texture,argv[i]);                 }                break;
             } 3           if (strncmp("threshold",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing value",option);                 }                break;
             } 5           if (strncmp("transparent",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)P                     MagickError(OptionError,"Missing transparent color",option);                 }                break;
             } 3           if (strncmp("treedepth",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing depth",option);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'u': 	         { /           if (strncmp("units",option+1,3) == 0) 
             { 3               image_info.units=UndefinedResolution; !               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; 7                   image_info.units=UndefinedResolution; A                   if (Latin1Compare("PixelsPerInch",option) == 0) =                     image_info.units=PixelsPerInchResolution; G                   if (Latin1Compare("PixelsPerCentimeter",option) == 0) C                     image_info.units=PixelsPerCentimeterResolution;                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'v': 	         { 1           if (strncmp("verbose",option+1,2) == 0) 
             { 2               image_info.verbose=(*option == '-');               break;
             } .           if (strncmp("view",option+1,3) == 0)
             { ,               image_info.view=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)M                     MagickError(OptionError,"Missing view transform",option); ?                   (void) CloneString(&image_info.view,argv[i]);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'w': 	         { 2           if (Latin1Compare("wave",option+1) == 0)
             {                i++;:               if ((i == argc) || !sscanf(argv[i],"%d",&x))D                 MagickError(OptionError,"Missing amplitude",option);               break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case '?': 	         {            Usage(client_name);            break;	         }          default:	         { @           MagickError(OptionError,"Unrecognized option",option);           break;	         }        }    }    if (image == (Image *) NULL)H     MagickError(OptionError,"Missing an image file name",(char *) NULL);   /*     Write images.    */E   if ((Extent(option) > 2) && ((*option == '-') || (*option == '+'))) -     MogrifyImages(&image_info,i,argv,&image); +   while (image->previous != (Image *) NULL)      image=image->previous;   if (append != 0)     {        Image          *appended_image;         /*!         Append an image sequence.        */5       appended_image=AppendImages(image,append == 1); +       if (appended_image != (Image *) NULL) 	         {            DestroyImages(image);            image=appended_image; 	         }      }    if (average)     {        Image          *averaged_image;         /*"         Average an image sequence.       */*       averaged_image=AverageImages(image);+       if (averaged_image != (Image *) NULL) 	         {            DestroyImages(image);            image=averaged_image; 	         }      }    if (coalesce)      {        Image          *coalesced_image;          /*"         Average an image sequence.       */,       coalesced_image=CoalesceImages(image);,       if (coalesced_image != (Image *) NULL)	         {            DestroyImages(image);             image=coalesced_image;	         }      }    if (deconstruct)     {        Image          *deconstructed_image;          /*"         Average an image sequence.       */3       deconstructed_image=DeconstructImages(image); 0       if (deconstructed_image != (Image *) NULL)	         {            DestroyImages(image); $           image=deconstructed_image;	         }      }    if (morph != 0)      {        Image          *morphed_image;          /*          Morph an image sequence.       */-       morphed_image=MorphImages(image,morph); *       if (morphed_image != (Image *) NULL)	         {            DestroyImages(image);            image=morphed_image;	         }      } 
   if (mosaic)      {        Image          *mosaic_image;         /*"         Average an image sequence.       */'       mosaic_image=MosaicImages(image); )       if (mosaic_image != (Image *) NULL) 	         {            DestroyImages(image);            image=mosaic_image; 	         }      }    if (global_colormap)=     (void) MapImages(image,(Image *) NULL,image_info.dither);    /*     Write converted image.   */-   (void) strcpy(image_info.filename,argv[i]); /   for (p=image; p != (Image *) NULL; p=p->next)    { '     (void) strcpy(p->filename,argv[i]);      p->scene=scene++;    } !   SetImageInfo(&image_info,True);    status=0; /   for (p=image; p != (Image *) NULL; p=p->next)    { %     status=WriteImage(&image_info,p); /     if ((status == False) || image_info.adjoin)        break;   }    if (image_info.verbose) &     DescribeImage(image,stderr,False);   DestroyImages(image);    DestroyDelegateInfo();   DestroyMagickInfo();   FreeMemory(argv);    Exit(status ? 0 : errno);    return(False); } 