 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %             DDDD   IIIII  SSSSS  PPPP   L       AAA   Y   Y                 % O %             D   D    I    SS     P   P  L      A   A   Y Y                  % O %             D   D    I     SSS   PPPP   L      AAAAA    Y                   % O %             D   D    I       SS  P      L      A   A    Y                   % O %             DDDD   IIIII  SSSSS  P      LLLLL  A   A    Y                   % O %                                                                             % O %                                                                             % O %                     Interactively Display an Image.                         % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              July 1992                                      % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Display is a machine architecture independent image processing G %  and display program.  It can display any image in the MIFF format on C %  any workstation display running X.  Display first determines the E %  hardware capabilities of the workstation.  If the number of unique J %  colors in the image is less than or equal to the number the workstationE %  can support, the image is displayed in an X window.  Otherwise the D %  number of colors in the image is first reduced to match the color8 %  resolution of the workstation before it is displayed. % M %  This means that a continuous-tone 24 bits-per-pixel image can display on a I %  8 bit pseudo-color device or monochrome device.  In most instances the H %  reduced color image closely resembles the original.  Alternatively, aG %  monochrome or pseudo-color image can display on a continuous-tone 24  %  bits-per-pixel device.  % ) %  The Display program command syntax is:  % > %  Usage: display [options ...] file [ [options ...] file ...] %  %  Where options include: < %    -backdrop          display image centered on a backdrop= %    -border geometry   surround image with a border of color H %    -cache threshold   megabytes of memory available to the pixel cache) %    -colormap type     Shared or Private ? %    -colors value      preferred number of colors in the image 2 %    -colorspace type   alternate image colorspace5 %    -comment string    annotate image with comment", 1 %    -compress type     type of image compression < %    -contrast          enhance or reduce the image contrastH %    -crop geometry     preferred size and location of the cropped image< %    -delay value       display the next image after pausingD %    -density geometry  vertical and horizontal density of the image; %    -despeckle         reduce the speckles within an image 6 %    -display server    display image to this X server+ %    -dispose method    GIF disposal method F %    -dither            apply Floyd/Steinberg error diffusion to imageC %    -edge factor       apply a filter to detect edges in the image G %    -enhance           apply a digital filter to enhance a noisy image > %    -filter type       use this filter when resizing an image< %    -flip              flip image in the vertical direction> %    -flop              flop image in the horizontal direction@ %    -frame geometry    surround image with an ornamental border1 %    -gamma value       level of gamma correction G %    -geometry geometry preferred size and location of the Image window : %    -immutable         displayed image cannot be modified7 %    -interlace type    None, Line, Plane, or Partition 2 %    -label name        assign a label to an imageB %    -map type          display image using this Standard Colormap@ %    -matte             store matte channel if the image has one: %    -monochrome        transform image to black and whiteH %    -negate            replace every pixel with its complementary color< %    -page geometry     size and location of an image canvas7 %    -quality value     JPEG/MIFF/PNG compression level I %    -raise value       lighten/darken image edges to create a 3-D effect F %    -remote command    execute a command in an remote display process@ %    -roll geometry     roll an image vertically or horizontally9 %    -rotate degrees    apply Paeth rotation to the image 7 %    -sample geometry   scale image with pixel sampling * %    -scene value       image scene number( %    -segment value     segment an image; %    -sharpen factor    apply a filter to sharpen the image 1 %    -size geometry     width and height of image I %    -texture filename  name of texture to tile onto the image background > %    -treedepth value   depth of the color classification treeH %    -update seconds    detect when image file is modified and redisplayB %    -verbose           print detailed information about the image< %    -visual type       display image using this visual typeB %    -window id         display image to background of this windowE %    -window_group id   exit program when this window id is destroyed - %    -write filename    write image to a file  % F %  In addition to those listed above, you can specify these standard XA %  resources as command line options:  -background, -bordercolor, I %  -borderwidth, -font, -foreground, -iconGeometry, -iconic, -mattecolor, 0 %  -name, -shared_memory, -usePixmap, or -title. % D %  By default, the image format of `file' is determined by its magicF %  number.  To specify a particular image format, precede the filenameG %  with an image format name and a colon (i.e. ps:image) or specify the H %  image type as the filename suffix (i.e. image.ps).  Specify 'file' as$ %  '-' for standard input or output. %  %  Buttons: 2 %    1    press to map or unmap the Command widget8 %    2    press and drag to magnify a region of an image> %    3    press to load an image from a visual image directory %  %  */   /*   Include declarations.  */ #include "magick/magick.h" #include "magick/defines.h"  #include "magick/xwindows.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 4 %  Method Usage displays the program command syntax. % % %  The format of the Usage method is:  % * %      void Usage(const char *client_name) % + %  A description of each parameter follows:  % J %    o client_name: a character string representing the name of the client %      program.  %  */* static void Usage(const char *client_name) {    const char     **p;     static const char      *buttons[]=      { 6       "1    press to map or unmap the Command widget",<       "2    press and drag to magnify a region of an image",B       "3    press to load an image from a visual image directory",       (char *) NULL      },     *options[]=      { @       "-backdrop          display image centered on a backdrop",A       "-border geometry   surround image with a border of color", L       "-cache threshold   megabytes of memory available to the pixel cache",-       "-colormap type     Shared or Private", C       "-colors value      preferred number of colors in the image", 6       "-colorspace type   alternate image colorspace",7       "-comment string    annotate image with comment", 5       "-compress type     type of image compression", @       "-contrast          enhance or reduce the image contrast",L       "-crop geometry     preferred size and location of the cropped image",@       "-delay value       display the next image after pausing",H       "-density geometry  vertical and horizontal density of the image",?       "-despeckle         reduce the speckles within an image", :       "-display server    display image to this X server",/       "-dispose method    GIF disposal method", J       "-dither            apply Floyd/Steinberg error diffusion to image",G       "-edge factor       apply a filter to detect edges in the image", K       "-enhance           apply a digital filter to enhance a noisy image", B       "-filter type       use this filter when resizing an image",@       "-flip              flip image in the vertical direction",B       "-flop              flop image in the horizontal direction",D       "-frame geometry    surround image with an ornamental border",5       "-gamma value       level of gamma correction", K       "-geometry geometry preferred size and location of the Image window", >       "-immutable         displayed image cannot be modified",;       "-interlace type    None, Line, Plane, or Partition", 6       "-label name        assign a label to an image",F       "-map type          display image using this Standard Colormap",D       "-matte             store matte channel if the image has one",>       "-monochrome        transform image to black and white",M       "-negate            replace every pixel with its complementary color ", @       "-page geometry     size and location of an image canvas",;       "-quality value     JPEG/MIFF/PNG compression level", M       "-raise value       lighten/darken image edges to create a 3-D effect", J       "-remote command    execute a command in an remote display process",D       "-roll geometry     roll an image vertically or horizontally",=       "-rotate degrees    apply Paeth rotation to the image", .       "-scene value       image scene number",,       "-segment value     segment an image",;       "-sample geometry   scale image with pixel sampling", ?       "-sharpen factor    apply a filter to sharpen the image", 5       "-size geometry     width and height of image", M       "-texture filename  name of texture to tile onto the image background", B       "-treedepth value   depth of the color classification tree",L       "-update seconds    detect when image file is modified and redisplay",F       "-verbose           print detailed information about the image",@       "-visual type       display image using this visual type",F       "-window id         display image to background of this window",I       "-window_group id   exit program when this window id is destroyed", 1       "-write filename    write image to a file",        (char *) NULL      };  4   (void) printf("Version: %.1024s\n",MagickVersion);:   (void) printf("Copyright: %.1024s\n\n",MagickCopyright);   (void) printf(F     "Usage: %.1024s [-options ...] file [ [-options ...] file ...]\n",     client_name); /   (void) printf("\nWhere options include: \n"); +   for (p=options; *p != (char *) NULL; p++) $     (void) printf("  %.1024s\n",*p);   (void) printf(O     "\nIn addition to those listed above, you can specify these standard X\n");    (void) printf(H     "resources as command line options:  -background, -bordercolor,\n");   (void) printf(P     "-borderwidth, -font, -foreground, -iconGeometry, -iconic, -mattecolor,\n");C   (void) printf("-name, -shared_memory, -usePixmap, or -title.\n");    (void) printf(M     "\nBy default, the image format of `file' is determined by its magic\n");    (void) printf(M     "number.  To specify a particular image format, precede the filename\n");    (void) printf(N     "with an image format name and a colon (i.e. ps:image) or specify the\n");   (void) printf(O     "image type as the filename suffix (i.e. image.ps).  Specify 'file' as\n"); 7   (void) printf("'-' for standard input or output.\n"); !   (void) printf("\nButtons: \n"); +   for (p=buttons; *p != (char *) NULL; p++) $     (void) printf("  %.1024s\n",*p);
   Exit(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %    M a i n                                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   #if defined(WIN32)M int WINAPI WinMain(HINSTANCE instance,HINSTANCE last,LPSTR command,int state)  {    char     **argv;      int 	     argc,      main(int,char **);  #   argv=StringToArgv(command,&argc);    return(main(argc,argv)); }  #endif   int main(int argc,char **argv) {  #if defined(HasX11)    char     *client_name,      *option,     *resource_value,     *server_name;   	   Display 
     *display;      double	     sans;      Image      *image,      *next_image;     ImageInfo      *image_info;     int      image_number,      status,      x;     QuantizeInfo     *quantize_info;      register int     i,     j;     unsigned int     first_scene,     *image_marker,     last_image,      last_scene, 
     scene;     unsigned long 
     state;     XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     /*&     Initialize command line arguments.   */   SetNotifyHandlers;   ReadCommandlLine(argc,&argv); #   client_name=SetClientName(*argv); &   (void) ExpandFilenames(&argc,&argv);   /*     Set defaults.    */   display=(Display *) NULL;    first_scene=0;   image_number=0;    last_image=0;    last_scene=0; N   image_marker=(unsigned int *) AllocateMemory((argc+1)*sizeof(unsigned int));,   if (image_marker == (unsigned int *) NULL)=     MagickError(ResourceLimitError,"Unable to display image", "       "Memory allocation failed");   for (i=0; i <= argc; i++)      image_marker[i]=argc; '   resource_database=(XrmDatabase) NULL; 
   state=0;   /*8     Check for server name specified on the command line.   */   server_name=(char *) NULL;   for (i=1; i < argc; i++)   {      /*)       Check command line for server name.      */     option=argv[i]; H     if ((Extent(option) == 1) || ((*option != '-') && (*option != '+')))       continue; /     if (Latin1Compare("display",option+1) == 0)        { 
         /*%           User specified server name. 
         */         i++;         if (i == argc)@           MagickError(OptionError,"Missing server name",option);         server_name=argv[i];         break;       } (     if (strncmp("help",option+1,2) == 0)       Usage(client_name);    }    /*/     Get user defaults from X resource database.    */$   display=XOpenDisplay(server_name);"   if (display == (Display *) NULL)=     MagickError(XServerError,"Unable to connect to X server", !       XDisplayName(server_name));    XSetErrorHandler(XError); >   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info); &   image_info=resource_info.image_info;#   image_info->coalesce_frames=True; ,   quantize_info=resource_info.quantize_info;   image_info->density=P     XGetResourceInstance(resource_database,client_name,"density",(char *) NULL);+   if (image_info->density == (char *) NULL) 3     image_info->density=XGetScreenDensity(display);    resource_value= K     XGetResourceInstance(resource_database,client_name,"interlace","none"); +   image_info->interlace=UndefinedInterlace; 0   if (Latin1Compare("None",resource_value) == 0)&     image_info->interlace=NoInterlace;0   if (Latin1Compare("Line",resource_value) == 0)(     image_info->interlace=LineInterlace;1   if (Latin1Compare("Plane",resource_value) == 0) )     image_info->interlace=PlaneInterlace; 5   if (Latin1Compare("Partition",resource_value) == 0) -     image_info->interlace=PartitionInterlace; 2   if (image_info->interlace == UndefinedInterlace)N     MagickWarning(OptionWarning,"Unrecognized interlace type",resource_value);F   image_info->page=XGetResourceInstance(resource_database,client_name,"     "pageGeometry",(char *) NULL);   resource_value= G     XGetResourceInstance(resource_database,client_name,"quality","75"); +   image_info->quality=atoi(resource_value);    resource_value= J     XGetResourceInstance(resource_database,client_name,"verbose","False");-   image_info->verbose=IsTrue(resource_value);    resource_value= H     XGetResourceInstance(resource_database,client_name,"dither","True");/   quantize_info->dither=IsTrue(resource_value);    /*     Parse command line.    */7   for (i=1; ((i <= argc) && !(state & ExitState)); i++)    {      if (i < argc)        option=argv[i];      else       if (image_number != 0)         break;
       else"         if (!isatty(STDIN_FILENO))           option="-";          else!           option="logo:Untitled"; G     if ((Extent(option) > 1) && ((*option == '-') || (*option == '+')))        switch (*(option+1))       {          case 'b': 	         { 2           if (strncmp("backdrop",option+1,5) == 0)
             { 6               resource_info.backdrop=(*option == '-');               break;
             } 8           if ((strncmp("background",option+1,5) == 0) ||.               (strncmp("bg",option+1,2) == 0))
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)D                     MagickError(OptionError,"Missing color",option);N                   (void) CloneString(&resource_info.background_color,argv[i]);4                   (void) QueryColorDatabase(argv[i],3                     &image_info->background_color);                  }                break;
             } 4           if (Latin1Compare("border",option+1) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } 5           if (strncmp("bordercolor",option+1,7) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)D                     MagickError(OptionError,"Missing color",option);J                   (void) CloneString(&resource_info.border_color,argv[i]);O                   (void) QueryColorDatabase(argv[i],&image_info->border_color);                  }                break;
             } 5           if (strncmp("borderwidth",option+1,7) == 0) 
             { +               resource_info.border_width=0; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing width",option);;                   resource_info.border_width=atoi(argv[i]);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'c': 	         { /           if (strncmp("cache",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))H                     MagickError(OptionError,"Missing threshold",option);                 }                break;
             } 2           if (strncmp("colormap",option+1,6) == 0)
             { 5               resource_info.colormap=PrivateColormap; !               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; ;                   resource_info.colormap=UndefinedColormap; ;                   if (Latin1Compare("private",option) == 0) ;                     resource_info.colormap=PrivateColormap; :                   if (Latin1Compare("shared",option) == 0):                     resource_info.colormap=SharedColormap;B                   if (resource_info.colormap == UndefinedColormap)L                     MagickError(OptionError,"Invalid colormap type",option);                 }                break;
             } 0           if (strncmp("colors",option+1,7) == 0)
             { -               quantize_info->number_colors=0; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing colors",option); =                   quantize_info->number_colors=atoi(argv[i]);                  }                break;
             } 4           if (strncmp("colorspace",option+1,7) == 0)
             { 6               quantize_info->colorspace=RGBColorspace;!               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; @                   quantize_info->colorspace=UndefinedColorspace;8                   if (Latin1Compare("cmyk",option) == 0)=                     quantize_info->colorspace=CMYKColorspace; 8                   if (Latin1Compare("gray",option) == 0)                     { ?                       quantize_info->colorspace=GRAYColorspace; 7                       quantize_info->number_colors=256; 2                       quantize_info->tree_depth=8;                     } 8                   if (Latin1Compare("ohta",option) == 0)=                     quantize_info->colorspace=OHTAColorspace; 7                   if (Latin1Compare("rgb",option) == 0) <                     quantize_info->colorspace=RGBColorspace;8                   if (Latin1Compare("srgb",option) == 0)=                     quantize_info->colorspace=sRGBColorspace; ?                   if (Latin1Compare("transparent",option) == 0) D                     quantize_info->colorspace=TransparentColorspace;7                   if (Latin1Compare("xyz",option) == 0) <                     quantize_info->colorspace=XYZColorspace;9                   if (Latin1Compare("ycbcr",option) == 0) >                     quantize_info->colorspace=YCbCrColorspace;7                   if (Latin1Compare("ycc",option) == 0) <                     quantize_info->colorspace=YCCColorspace;7                   if (Latin1Compare("yiq",option) == 0) <                     quantize_info->colorspace=YIQColorspace;9                   if (Latin1Compare("ypbpr",option) == 0) >                     quantize_info->colorspace=YPbPrColorspace;7                   if (Latin1Compare("yuv",option) == 0) <                     quantize_info->colorspace=YUVColorspace;G                   if (quantize_info->colorspace == UndefinedColorspace) N                     MagickError(OptionError,"Invalid colorspace type",option);                 }                break;
             } 1           if (strncmp("comment",option+1,4) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)F                     MagickError(OptionError,"Missing comment",option);                 }                break;
             } 2           if (strncmp("compress",option+1,5) == 0)
             { 4               image_info->compression=NoCompression;!               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; ?                   image_info->compression=UndefinedCompression; 8                   if (Latin1Compare("None",option) == 0):                     image_info->compression=NoCompression;8                   if (Latin1Compare("BZip",option) == 0)<                     image_info->compression=BZipCompression;7                   if (Latin1Compare("Fax",option) == 0) ;                     image_info->compression=FaxCompression; :                   if (Latin1Compare("Group4",option) == 0)>                     image_info->compression=Group4Compression;8                   if (Latin1Compare("JPEG",option) == 0)<                     image_info->compression=JPEGCompression;7                   if (Latin1Compare("LZW",option) == 0) ;                     image_info->compression=LZWCompression; D                   if (Latin1Compare("RunlengthEncoded",option) == 0)H                     image_info->compression=RunlengthEncodedCompression;7                   if (Latin1Compare("Zip",option) == 0) ;                     image_info->compression=ZipCompression; F                   if (image_info->compression == UndefinedCompression)O                     MagickError(OptionError,"Invalid compression type",option);                  }                break;
             } 2           if (strncmp("contrast",option+1,3) == 0)             break;.           if (strncmp("crop",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'd': 	         { /           if (strncmp("debug",option+1,3) == 0) 
             { 3               resource_info.debug=(*option == '-');                break;
             } /           if (strncmp("delay",option+1,3) == 0) 
             { $               resource_info.delay=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     MagickError(OptionError,"Missing seconds",option);4                   resource_info.delay=atoi(argv[i]);                 }                break;
             } 1           if (strncmp("density",option+1,3) == 0) 
             { 0               image_info->density=(char *) NULL;!               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option); C                   (void) CloneString(&image_info->density,argv[i]);                  }                break;
             } 3           if (strncmp("despeckle",option+1,3) == 0)              break;5           if (Latin1Compare("display",option+1) == 0) 
             { 4               image_info->server_name=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)J                     MagickError(OptionError,"Missing server name",option);2                   image_info->server_name=argv[i];                 }                break;
             } 1           if (strncmp("dispose",option+1,5) == 0) 
             { 0               image_info->dispose=(char *) NULL;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     MagickError(OptionError,"Missing method",option); B                   image_info->dispose=PostscriptGeometry(argv[i]);                 }                break;
             } 0           if (strncmp("dither",option+1,3) == 0)
             { 5               quantize_info->dither=(*option == '-');                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'e': 	         { .           if (strncmp("edge",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))E                     MagickError(OptionError,"Missing factor",option);                  }                break;
             } 1           if (strncmp("enhance",option+1,2) == 0)              break;@           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'f': 	         { 0           if (strncmp("filter",option+1,3) == 0)
             { !               if (*option == '-')                  {                    FilterType                     filter;                      i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; )                   filter=UndefinedFilter; 9                   if (Latin1Compare("Point",option) == 0) '                     filter=PointFilter; 7                   if (Latin1Compare("Box",option) == 0) %                     filter=BoxFilter; <                   if (Latin1Compare("Triangle",option) == 0)*                     filter=TriangleFilter;;                   if (Latin1Compare("Hermite",option) == 0) )                     filter=HermiteFilter; ;                   if (Latin1Compare("Hanning",option) == 0) )                     filter=HanningFilter; ;                   if (Latin1Compare("Hamming",option) == 0) )                     filter=HammingFilter; <                   if (Latin1Compare("Blackman",option) == 0)*                     filter=BlackmanFilter;<                   if (Latin1Compare("Gaussian",option) == 0)*                     filter=GaussianFilter;=                   if (Latin1Compare("Quadratic",option) == 0) +                     filter=QuadraticFilter; 9                   if (Latin1Compare("Cubic",option) == 0) '                     filter=CubicFilter; :                   if (Latin1Compare("Catrom",option) == 0)(                     filter=CatromFilter;<                   if (Latin1Compare("Mitchell",option) == 0)*                     filter=MitchellFilter;;                   if (Latin1Compare("Lanczos",option) == 0) )                     filter=LanczosFilter; :                   if (Latin1Compare("Bessel",option) == 0)(                     filter=BesselFilter;8                   if (Latin1Compare("Sinc",option) == 0)&                     filter=SincFilter;0                   if (filter == UndefinedFilter)J                     MagickError(OptionError,"Invalid filter type",option);                 }                break;
             } .           if (strncmp("flip",option+1,3) == 0)             break;.           if (strncmp("flop",option+1,3) == 0)             break;.           if (strncmp("font",option+1,3) == 0)
             { -               image_info->font=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     MagickError(OptionError,"Missing font name",option);+                   image_info->font=argv[i];                  } 8               if ((image_info->font == (char *) NULL) ||-                   (*image_info->font != '@')) 4                 resource_info.font=image_info->font;               break;
             } 8           if ((strncmp("foreground",option+1,3) == 0) ||.               (strncmp("fg",option+1,2) == 0))            {               if (*option == '-')                {                  i++;                   if (i == argc) H                    MagickError(OptionError,"Missing foreground",option);M                  (void) CloneString(&resource_info.foreground_color,argv[i]);                 }               break;            }/           if (strncmp("frame",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'g': 	         { /           if (strncmp("gamma",option+1,2) == 0) 
             {                i++;>               if ((i == argc) || !sscanf(argv[i],"%lf",&sans))@                 MagickError(OptionError,"Missing value",option);               break;
             } 2           if (strncmp("geometry",option+1,2) == 0)
             { 9               resource_info.image_geometry=(char *) NULL; !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option); 7                   resource_info.image_geometry=argv[i];                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'h': 	         { .           if (strncmp("help",option+1,2) == 0)             Usage(client_name); @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'i': 	         { 6           if (strncmp("iconGeometry",option+1,5) == 0)
             { 8               resource_info.icon_geometry=(char *) NULL;!               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option); 6                   resource_info.icon_geometry=argv[i];                 }                break;
             } 0           if (strncmp("iconic",option+1,5) == 0)
             { 4               resource_info.iconic=(*option == '-');               break;
             } 3           if (strncmp("immutable",option+1,5) == 0) 
             { 7               resource_info.immutable=(*option == '-');                break;
             } 3           if (strncmp("interlace",option+1,3) == 0) 
             { 0               image_info->interlace=NoInterlace;!               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing type",option); !                   option=argv[i]; ;                   image_info->interlace=UndefinedInterlace; 8                   if (Latin1Compare("None",option) == 0)6                     image_info->interlace=NoInterlace;8                   if (Latin1Compare("Line",option) == 0)8                     image_info->interlace=LineInterlace;9                   if (Latin1Compare("Plane",option) == 0) 9                     image_info->interlace=PlaneInterlace; =                   if (Latin1Compare("Partition",option) == 0) =                     image_info->interlace=PartitionInterlace; B                   if (image_info->interlace == UndefinedInterlace)M                     MagickError(OptionError,"Invalid interlace type",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'l': 	         { /           if (strncmp("label",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)I                     MagickError(OptionError,"Missing label name",option);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'm': 	         { 1           if (strncmp("magnify",option+1,3) == 0) 
             { &               resource_info.magnify=2;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing level",option);6                   resource_info.magnify=atoi(argv[i]);                 }                break;
             } -           if (strncmp("map",option+1,3) == 0) 
             {                argv[i]="+sans";3               resource_info.map_type=(char *) NULL; !               if (*option == '-')                  { "                   argv[i]="-sans";                   i++;                    if (i == argc)G                     MagickError(OptionError,"Missing map type",option); 1                   resource_info.map_type=argv[i];                  }                break;
             } 3           if (Latin1Compare("matte",option+1) == 0)              break;4           if (strncmp("mattecolor",option+1,6) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)D                     MagickError(OptionError,"Missing color",option);I                   (void) CloneString(&resource_info.matte_color,argv[i]); N                   (void) QueryColorDatabase(argv[i],&image_info->matte_color);                 }                break;
             } 4           if (strncmp("monochrome",option+1,3) == 0)
             { 6               image_info->monochrome=(*option == '-');)               if (image_info->monochrome)                  { 1                   quantize_info->number_colors=2; .                   quantize_info->tree_depth=8;;                   quantize_info->colorspace=GRAYColorspace;                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'n': 	         { .           if (strncmp("name",option+1,2) == 0)
             { /               resource_info.name=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)C                     MagickError(OptionError,"Missing name",option); -                   resource_info.name=argv[i];                  }                break;
             } 0           if (strncmp("negate",option+1,2) == 0)             break;@           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'p': 	         { .           if (strncmp("page",option+1,3) == 0)
             { -               image_info->page=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)L                     MagickError(OptionError,"Missing page geometry",option);?                   image_info->page=PostscriptGeometry(argv[i]);                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'q': 	         { 1           if (strncmp("quality",option+1,2) == 0) 
             { %               image_info->quality=75; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     MagickError(OptionError,"Missing quality",option);4                   image_info->quality=atoi(argv[i]);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'r': 	         { /           if (strncmp("raise",option+1,2) == 0) 
             {                i++;:               if ((i == argc) || !sscanf(argv[i],"%d",&x))F                 MagickError(OptionError,"Missing bevel width",option);               break;
             } 0           if (strncmp("remote",option+1,3) == 0)
             {                i++;               if (i == argc)B                 MagickError(OptionError,"Missing command",option);F               XRemoteCommand(display,resource_info.window_id,argv[i]);               Exit(0);
             } .           if (strncmp("roll",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } 0           if (strncmp("rotate",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))F                     MagickError(OptionError,"Missing degrees",option);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 's': 	         { 0           if (strncmp("sample",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option);                  }                break;
             } /           if (strncmp("scene",option+1,3) == 0) 
             {                first_scene=0;               last_scene=0; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))K                     MagickError(OptionError,"Missing scene number",option); ,                   first_scene=atoi(argv[i]);)                   last_scene=first_scene; J                   (void) sscanf(argv[i],"%u-%u",&first_scene,&last_scene);                 }                break;
             } 1           if (strncmp("segment",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))H                     MagickError(OptionError,"Missing threshold",option);                 }                break;
             } 1           if (strncmp("sharpen",option+1,5) == 0) 
             { !               if (*option == '-')                  {                    i++;B                   if ((i == argc) || !sscanf(argv[i],"%lf",&sans))E                     MagickError(OptionError,"Missing factor",option);                  }                break;
             } 7           if (strncmp("shared_memory",option+1,5) == 0) 
             { ?               resource_info.use_shared_memory=(*option == '-');                break;
             } .           if (strncmp("size",option+1,2) == 0)
             { -               image_info->size=(char *) NULL; !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     MagickError(OptionError,"Missing geometry",option); +                   image_info->size=argv[i];                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 't': 	         { 3           if (strncmp("text_font",option+1,5) == 0) 
             { 4               resource_info.text_font=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)H                     MagickError(OptionError,"Missing font name",option);2                   resource_info.text_font=argv[i];                 }                break;
             } 1           if (strncmp("texture",option+1,5) == 0) 
             { 0               image_info->texture=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)G                     MagickError(OptionError,"Missing filename",option); .                   image_info->texture=argv[i];                 }                break;
             } /           if (strncmp("title",option+1,2) == 0) 
             { 0               resource_info.title=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)D                     MagickError(OptionError,"Missing title",option);.                   resource_info.title=argv[i];                 }                break;
             } 3           if (strncmp("treedepth",option+1,3) == 0) 
             { *               quantize_info->tree_depth=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     MagickError(OptionError,"Missing depth",option);:                   quantize_info->tree_depth=atoi(argv[i]);                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'u': 	         { 0           if (strncmp("update",option+1,2) == 0)
             { 4               resource_info.update=(*option == '-');!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     MagickError(OptionError,"Missing seconds",option);4                   resource_info.delay=atoi(argv[i]);                 }                break;
             } 4           if (strncmp("use_pixmap",option+1,2) == 0)
             { 8               resource_info.use_pixmap=(*option == '-');               break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'v': 	         { 1           if (strncmp("verbose",option+1,2) == 0) 
             { 3               image_info->verbose=(*option == '-');                break;
             } 0           if (strncmp("visual",option+1,3) == 0)
             { 6               resource_info.visual_type=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)K                     MagickError(OptionError,"Missing visual class",option); 4                   resource_info.visual_type=argv[i];                 }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case 'w': 	         { 4           if (Latin1Compare("window",option+1) == 0)
             { 4               resource_info.window_id=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)J                     MagickError(OptionError,"Missing id, name, or 'root'",                       option);2                   resource_info.window_id=argv[i];                 }                break;
             } 6           if (strncmp("window_group",option+1,7) == 0)
             { 7               resource_info.window_group=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)J                     MagickError(OptionError,"Missing id, name, or 'root'",                       option);5                   resource_info.window_group=argv[i];                  }                break;
             } /           if (strncmp("write",option+1,2) == 0) 
             { 9               resource_info.write_filename=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     MagickError(OptionError,"Missing file name",option);7                   resource_info.write_filename=argv[i]; A                   if (IsAccessible(resource_info.write_filename))                      {                        char"                         answer[2];  B                       (void) fprintf(stderr,"Overwrite %.1024s? ",6                         resource_info.write_filename);@                       (void) fgets(answer,sizeof(answer),stdin);B                       if (!((*answer == 'y') || (*answer == 'Y')))                          Exit(0);                     }                  }                break;
             } @           MagickError(OptionError,"Unrecognized option",option);           break;	         }          case '?': 	         {            Usage(client_name);            break;	         }          default:	         { @           MagickError(OptionError,"Unrecognized option",option);           break;	         }        }      else       { 
         /*            Option is a file name.
         */>         for (scene=first_scene; scene <= last_scene ; scene++)	         {            /*             Read image.            */5           (void) strcpy(image_info->filename,option); (           if (first_scene != last_scene)
             {                char(                 filename[MaxTextExtent];                 /*4                 Form filename for multi-part images.               */@               FormatString(filename,image_info->filename,scene);D               if (Latin1Compare(filename,image_info->filename) == 0)O                 FormatString(filename,"%.1024s.%u",image_info->filename,scene); ;               (void) strcpy(image_info->filename,filename); 
             } 3           (void) strcpy(image_info->magick,"MIFF"); ;           image_info->colorspace=quantize_info->colorspace; 3           image_info->dither=quantize_info->dither; &           image=ReadImage(image_info);&           if (image == (Image *) NULL)
             { 9               if ((i < (argc-1)) || (scene < last_scene))                  continue;                else                 { #                   state|=ExitState;                    break;                 } 
             }            do           {              /*L               Transmogrify image as defined by the image processing options.             */$             resource_info.quantum=1;3             MogrifyImage(image_info,i,argv,&image); *             if (first_scene != last_scene)!               image->scene=scene;              /*(               Display image to X server.             */9             if (resource_info.window_id != (char *) NULL)                {                  /*8                   Display image to a specified X window.                 */M                 status=XDisplayBackgroundImage(display,&resource_info,image);                  if (status) +                   state|=RetainColorsState; -                 if (resource_info.delay == 0) #                   state|=ExitState;                }              else               do               {                  Image                     *loaded_image;                   /*,                   Display image to X server.                 */                 loaded_image= P                   XDisplayImage(display,&resource_info,argv,argc,&image,&state);3                 if (loaded_image == (Image *) NULL)                    break;:                 while ((loaded_image != (Image *) NULL) &&.                        (!(state & ExitState)))                 { =                   if (loaded_image->montage != (char *) NULL)                      {                        /*I                         User selected a visual directory image (montage).                        */+                       DestroyImages(image); )                       image=loaded_image;                        break;                     } @                   MogrifyImage(image_info,i,argv,&loaded_image);0                   if (first_scene != last_scene)'                     image->scene=scene; L                   next_image=XDisplayImage(display,&resource_info,argv,argc,*                     &loaded_image,&state);7                   if ((next_image == (Image *) NULL) && =                       (loaded_image->next != (Image *) NULL))                      { +                       DestroyImages(image); /                       image=loaded_image->next; 2                       loaded_image=(Image *) NULL;                     }                    else                     { 0                       if (loaded_image != image)4                         DestroyImages(loaded_image);.                       loaded_image=next_image;                     }                  } -               } while (!(state & ExitState)); >             if (resource_info.write_filename != (char *) NULL)               {                  /*                   Write image.                 */L                 (void) strcpy(image->filename,resource_info.write_filename);.                 SetImageInfo(image_info,True);4                 (void) WriteImage(image_info,image);               } $             if (image_info->verbose)0               DescribeImage(image,stderr,False);             /*-               Proceed to next/previous image.              */             next_image=image; )             if (state & FormerImageState) 7               for (j=0; j < resource_info.quantum; j++)                { 0                 next_image=next_image->previous;1                 if (next_image == (Image *) NULL)                    break;               }              else7               for (j=0; j < resource_info.quantum; j++)                { ,                 next_image=next_image->next;1                 if (next_image == (Image *) NULL)                    break;               } -             if (next_image != (Image *) NULL)                image=next_image; K           } while ((next_image != (Image *) NULL) && !(state & ExitState));            /*!             Free image resources.            */           DestroyImages(image); *           if (!(state & FormerImageState))
             { &               last_image=image_number;-               image_marker[i]=image_number++; 
             }            else
             {                /**                 Proceed to previous image.               */#               for (i--; i > 0; i--) 8                 if (image_marker[i] == (image_number-2))                   break;               image_number--; 
             }             if (state & ExitState)             break;	         }        }      /*8       Determine if we should proceed to the first image.     */     if (image_number < 0)        { %         if (state & FormerImageState)            { (             for (i=1; i < (argc-2); i++)0               if (image_marker[i] == last_image)                 break;+             image_number=image_marker[i]+1;            }          continue;        }      if (image_number > 0) )       if ((i == (argc-1)) || (argc == 1)) !         if (!(state & ExitState)) 7           if (resource_info.window_id == (char *) NULL) 
             {                i=0;               image_number=0; 
             }    }     if (state & RetainColorsState)     { P       XRetainWindowColors(display,XRootWindow(display,XDefaultScreen(display)));       XSync(display,False);      }    DestroyDelegateInfo();   DestroyMagickInfo();   FreeMemory(argv); 
   Exit(0); #endif   return(False); } 