 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %           IIIII  DDDD   EEEEE  N   N  TTTTT  IIIII  FFFFF  Y   Y            % O %             I    D   D  E      NN  N    T      I    F       Y Y             % O %             I    D   D  EEE    N N N    T      I    FFF      Y              % O %             I    D   D  E      N  NN    T      I    F        Y              % O %           IIIII  DDDD   EEEEE  N   N    T    IIIII  F        Y              % O %                                                                             % O %                                                                             % O %               Identify an Image Format and Characteristics.                 % O %                                                                             % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                            September 1994                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Identify describes the format and characteristics of one or more image D %  files.  It will also report if an image is incomplete or corrupt. % " %  The identify program syntax is: % 2 %  Usage: identify [options ...] file [ files... ] %  %  Where options include: G %    -cache threshold  megabytes of memory available to the pixel cache B %    -ping             efficiently determine image characteristics0 %    -size geometry    width and height of imageA %    -verbose          print detailed information about the image  %  %  */   /*   Include declarations.  */ #include "magick/magick.h" #include "magick/defines.h"    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % . %  Procedure Usage displays the program usage; % % %  The format of the Usage method is:  % * %      void Usage(const char *client_name) % J %    o client_name: a character string representing the name of the client %      program.  %  %  */* static void Usage(const char *client_name) {    const char     **p;     static const char      *options[]=      { K       "-cache threshold  megabytes of memory available to the pixel cache", F       "-ping             efficiently determine image characteristics",4       "-size geometry    width and height of image",E       "-verbose          print detailed information about the image",        (char *) NULL      };  4   (void) printf("Version: %.1024s\n",MagickVersion);:   (void) printf("Copyright: %.1024s\n\n",MagickCopyright);R   (void) printf("Usage: %.1024s [ options ... ] file [ file ... ]\n",client_name);.   (void) printf("\nWhere options include:\n");+   for (p=options; *p != (char *) NULL; p++) $     (void) printf("  %.1024s\n",*p);
   Exit(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %    M a i n                                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */ int main(int argc,char **argv) {    char     *client_name,      *option;     double	     sans;      Image      *image,      *p;      ImageInfo      image_info;      int      number_images;     register int     i;     unsigned int
     count;     /*&     Initialize command line arguments.   */   ReadCommandlLine(argc,&argv); #   client_name=SetClientName(*argv); &   (void) ExpandFilenames(&argc,&argv);   if (argc < 2)      Usage(client_name);    /*     Set defaults.    */
   count=0;   GetImageInfo(&image_info);   number_images=0;   /*     Identify an image.   */   for (i=1; i < argc; i++)   {      option=argv[i]; H     if ((Extent(option) >= 2) && ((*option == '-') || (*option == '+')))       {          switch(*(option+1)) 	         {            case 'c':            { 1             if (strncmp("cache",option+1,3) == 0)                { #                 if (*option == '-')                    {                      i++;D                     if ((i == argc) || !sscanf(argv[i],"%lf",&sans))J                       MagickError(OptionError,"Missing threshold",option);                   }                  break;               } B             MagickError(OptionError,"Unrecognized option",option);             break;           }            case 'h':            { 0             if (strncmp("help",option+1,2) == 0)               { #                 Usage(client_name);                  break;               } B             MagickError(OptionError,"Unrecognized option",option);             break;           }            case 'p':            { 0             if (strncmp("ping",option+1,2) == 0)               { 1                 image_info.ping=(*option == '-');                  break;               } B             MagickError(OptionError,"Unrecognized option",option);             break;           }            case 's':            { 0             if (strncmp("size",option+1,2) == 0)               { .                 image_info.size=(char *) NULL;#                 if (*option == '-')                    {                      i++;<                     if ((i == argc) || !IsGeometry(argv[i]))I                       MagickError(OptionError,"Missing geometry",option); A                     (void) CloneString(&image_info.size,argv[i]);                    }                  break;               } B             MagickError(OptionError,"Unrecognized option",option);             break;           }            case 'v':            { 3             if (strncmp("verbose",option+1,2) == 0)                { 4                 image_info.verbose=(*option == '-');                 break;               } B             MagickError(OptionError,"Unrecognized option",option);             break;           }            case '?':            {              Usage(client_name);              break;           }            default:           { B             MagickError(OptionError,"Unrecognized option",option);             break;           } 	         }          continue;        }      /*       Identify image.      *//     (void) strcpy(image_info.filename,argv[i]);      if (image_info.ping)       {           image_info.verbose=True;%         image=PingImage(&image_info);          number_images++;         continue;        } !     image=ReadImage(&image_info);       if (image == (Image *) NULL)       continue; 1     for (p=image; p != (Image *) NULL; p=p->next)      {        if (p->scene == 0)         p->scene=count++; 1       DescribeImage(p,stdout,image_info.verbose);      }      DestroyImages(image);      number_images++;   }    if (number_images == 0) H     MagickError(OptionError,"Missing an image file name",(char *) NULL);   DestroyDelegateInfo();   DestroyMagickInfo();   FreeMemory(argv); 
   Exit(0);   return(False); } 