 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                         BBBB   L       OOO   BBBB                           % O %                         B   B  L      O   O  B   B                          % O %                         BBBB   L      O   O  BBBB                           % O %                         B   B  L      O   O  B   B                          % O %                         BBBB   LLLLL   OOO   BBBB                           % O %                                                                             % O %                                                                             % O %                    ImageMagick Binary Large OBjectS Methods                 % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1999                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h" #if defined(HAVE_MMAP) #include <sys/mman.h>  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   B l o b T o I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method BlobToImage implements direct to memory image formats.  It returns %  the blob as an image. % + %  The format of the BlobToImage method is:  % G %      Image *BlobToImage(const ImageInfo *image_info,const char *blob,  %        const size_t length)  % + %  A description of each parameter follows:  % J %    o image:  Method BlobToImage returns an image from the supplied blob.+ %      If an error occurs NULL is returned.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % J %    o blob: The address of a character stream in one of the image formats! %      understood by ImageMagick.  % N %    o length: This unsigned integer reflects the length in bytes of the blob. %  %  */G Export Image *BlobToImage(const ImageInfo *image_info,const char *blob,    const size_t length) {    FILE
     *file;     Image      *image;      ImageInfo      *local_info;     MagickInfo     *magick_info;      size_t
     count;  (   local_info=CloneImageInfo(image_info);+   local_info->blob_info.data=(char *) blob; !   local_info->blob_info.offset=0; &   local_info->blob_info.length=length;&   local_info->blob_info.extent=length;!   SetImageInfo(local_info,False); ?   magick_info=(MagickInfo *) GetMagickInfo(local_info->magick); )   if (magick_info == (MagickInfo *) NULL)      { <       MagickWarning(BlobWarning,"Unrecognized image format",         local_info->magick);#       DestroyImageInfo(local_info);        return((Image *) NULL);      } (   GetBlobInfo(&(local_info->blob_info));    if (magick_info->blob_support)     {        /*2         Native blob support for this image format.       */!       *local_info->filename='\0'; /       local_info->blob_info.data=(char *) blob; *       local_info->blob_info.length=length;*       local_info->blob_info.extent=length;"       image=ReadImage(local_info);#       DestroyImageInfo(local_info); "       if (image != (Image *) NULL))         GetBlobInfo(&(image->blob_info));        return(image);     }    /*+     Write blob to a temporary file on disk.    */*   TemporaryFilename(local_info->filename);'   file=fopen(local_info->filename,"w");    if (file == (FILE *) NULL)     { E       MagickWarning(BlobWarning,"Unable to convert blob to an image",          local_info->filename);#       DestroyImageInfo(local_info);        return((Image *) NULL);      } #   count=fwrite(blob,1,length,file);    (void) fclose(file);   if (count != length)     { E       MagickWarning(BlobWarning,"Unable to convert blob to an image",          local_info->filename);#       DestroyImageInfo(local_info);        return((Image *) NULL);      }    image=ReadImage(local_info);&   (void) remove(local_info->filename);   DestroyImageInfo(local_info);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   C l o s e B l o b                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Method CloseBlob closes a file associated with the image.  If theK %  filename prefix is '|', the file is a pipe and is closed with PipeClose.  % ) %  The format of the CloseBlob method is:  % # %      void CloseBlob(Image *image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */# Export void CloseBlob(Image *image)  {    /*     Close image file.    */"   assert(image != (Image *) NULL);&   ClosePixelCache(&image->cache_info);-   if (image->blob_info.data != (char *) NULL)      { .       image->filesize=image->blob_info.length;6       image->blob_info.extent=image->blob_info.length;
       return;      } #   if (image->file == (FILE *) NULL)      return;    (void) SyncBlob(image); $   image->status=ferror(image->file);%   (void) SeekBlob(image,0L,SEEK_END); "   image->filesize=TellBlob(image);
   errno=0;   image->tainted=False;    if (image->exempt)     return; ; #if !defined(vms) && !defined(macintosh) && !defined(WIN32)    if (image->pipe)     (void) pclose(image->file);    else #endif     (void) fclose(image->file);    image->file=(FILE *) NULL;   if (!image->orphan)      { /       while (image->previous != (Image *) NULL)          image=image->previous;9       for ( ; image != (Image *) NULL; image=image->next) "         image->file=(FILE *) NULL;     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y B l o b I n f o                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method DestroyBlobInfo deallocates memory associated with an BlobInfo
 %  structure.  % / %  The format of the DestroyBlobInfo method is:  % 0 %      void DestroyBlobInfo(BlobInfo *blob_info) % + %  A description of each parameter follows:  % > %    o blob_info: Specifies a pointer to a BlobInfo structure. %  %  */0 Export void DestroyBlobInfo(BlobInfo *blob_info) { )   assert(blob_info != (BlobInfo *) NULL);    if (blob_info->mapped)1     UnmapBlob(blob_info->data,blob_info->length);    GetBlobInfo(blob_info);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  E O F B l o b                                                              % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method EOFBlob returns a non-zero value when EOF has been detected reading  %  from a blob or file.  % ' %  The format of the EOFBlob method is:  % & %      int EOFBlob(const Image *image) % + %  A description of each parameter follows:  % C %    o status:  Method EOFBlob returns 0 on success; otherwise,  it 6 %      returns -1 and set errno to indicate the error. % 7 %    o image: The address of a structure of type Image.  %  %  */& Export int EOFBlob(const Image *image) { "   assert(image != (Image *) NULL);-   if (image->blob_info.data == (char *) NULL)      return(feof(image->file));<   return(image->blob_info.offset > image->blob_info.length); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t B l o b I n f o                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 9 %  Method GetBlobInfo initializes the BlobInfo structure.  % + %  The format of the GetBlobInfo method is:  % , %      void GetBlobInfo(BlobInfo *blob_info) % + %  A description of each parameter follows:  % > %    o blob_info: Specifies a pointer to a BlobInfo structure. %  %  */, Export void GetBlobInfo(BlobInfo *blob_info) { )   assert(blob_info != (BlobInfo *) NULL);    blob_info->mapped=False;    blob_info->data=(char *) NULL;   blob_info->offset=0;   blob_info->length=0;   blob_info->extent=0;!   blob_info->quantum=BlobQuantum;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   G e t S t r i n g B l o b                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method GetStringBlob reads characters from a blob or file until a newlineA %  character is read or an end-of-file  condition is encountered.  %  from a blob or file.  % - %  The format of the GetStringBlob method is:  % 5 %      char *GetStringBlob(Image *image,char *string)  % + %  A description of each parameter follows:  % N %    o status:  Method GetStringBlob returns the string on success, otherwise, %      a null is returned. % 7 %    o image: The address of a structure of type Image.  % 1 %    o string: The address of a character buffer.  %  %  */5 Export char *GetStringBlob(Image *image,char *string)  {    int      c;     register int     i;  "   assert(image != (Image *) NULL);-   if (image->blob_info.data == (char *) NULL) =     return(fgets((char *) string,MaxTextExtent,image->file)); '   for (i=0; i < (MaxTextExtent-1); i++)    {      c=ReadByte(image);     if (c == EOF)        return((char *) NULL);     string[i]=c;3     if ((string[i] == '\n') || (string[i] == '\r'))        break;   }    string[i]='\0';    return(string);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I m a g e T o B l o b                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method ImageToBlob implements direct to memory image formats.  It returnsF %  the image as a blob and its length.  The magick member of the ImageO %  structure determines the format of the returned blob (GIG, JPEG, PNG, etc.).  % + %  The format of the ImageToBlob method is:  % B %      char *ImageToBlob(const ImageInfo *image_info,Image *image, %        unsigned long *length)  % + %  A description of each parameter follows:  % I %    o blob:  Method ImageToBlob returns a chunk of memory written in the G %      desired image format (e.g. JPEG, GIF, etc.).  If an error occurs  %      NULL is returned. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % 7 %    o image: The address of a structure of type Image.  % M %    o length: This pointer to an unsigned int sets the initial length of the C %      blob.  On return, it reflects the actual length of the blob.  %  %  */B Export void *ImageToBlob(const ImageInfo *image_info,Image *image,   size_t *length)  {    char
     *blob,     filename[MaxTextExtent];     FILE
     *file;     ImageInfo      *local_info;     MagickInfo     *magick_info;      off_t      offset;      register int     i;     size_t
     count;     unsigned int     status;   (   local_info=CloneImageInfo(image_info);2   (void) strcpy(local_info->magick,image->magick);?   magick_info=(MagickInfo *) GetMagickInfo(local_info->magick); )   if (magick_info == (MagickInfo *) NULL)       {E        MagickWarning(BlobWarning,"No delegate for this image format",           local_info->magick);         return((char *) NULL);       }    if (magick_info->blob_support)     {        /*2         Native blob support for this image format.       */       *image->filename='\0';O       local_info->blob_info.extent=Max((int) *length,image->blob_info.quantum); )       local_info->blob_info.data=(char *) 5         AllocateMemory(local_info->blob_info.extent); 6       if (local_info->blob_info.data == (char *) NULL)	         { <           MagickWarning(BlobWarning,"Unable to create blob",(             "Memory allocation failed");            return((char *) NULL);	         } %       local_info->blob_info.offset=0; %       local_info->blob_info.length=0; *       status=WriteImage(local_info,image);       if (status == False)	         { P           MagickWarning(BlobWarning,"Unable to create blob",local_info->magick);'           DestroyImageInfo(local_info);             return((char *) NULL);	         } #       DestroyImageInfo(local_info); &       *length=image->blob_info.length;!       blob=image->blob_info.data; '       GetBlobInfo(&(image->blob_info));        return(blob);      }    /*,     Write file to disk in blob image format.   */   *length=0;(   local_info=CloneImageInfo(image_info);*   (void) strcpy(filename,image->filename);?   FormatString(image->filename,"%.1024s:%.1024s",image->magick,      local_info->unique);&   status=WriteImage(local_info,image);   if (status == False)     { I       MagickWarning(BlobWarning,"Unable to create blob",image->filename);        return((char *) NULL);     }    /*!     Read image from disk as blob.    */#   file=fopen(image->filename,"rb"); !   (void) remove(image->filename); *   (void) strcpy(image->filename,filename);   DestroyImageInfo(local_info);    if (file == (FILE *) NULL)     { I       MagickWarning(BlobWarning,"Unable to create blob",image->filename);        return((char *) NULL);     } !   (void) fseek(file,0L,SEEK_END);    *length=ftell(file);!   (void) fseek(file,0L,SEEK_SET); 5   blob=(char *) AllocateMemory(*length*sizeof(char));    if (blob == (char *) NULL)     { 8       MagickWarning(BlobWarning,"Unable to create blob",$         "Memory allocation failed");       return((char *) NULL);     }    offset=0; $   for (i=(*length); i > 0; i-=count)   { /     count=fread((char *) blob+offset,1,i,file);      if (count <= 0)        break;     offset+=count;   }    (void) fclose(file);   return(blob);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  L S B F i r s t R e a d L o n g                                            % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method LSBFirstReadLong reads a long value as a 32 bit quantity in & %  least-significant byte first order. % 0 %  The format of the LSBFirstReadLong method is: % 3 %      unsigned long LSBFirstReadLong(Image *image)  % + %  A description of each parameter follows.  % I %    o value:  Method LSBFirstReadLong returns an unsigned long read from  %      the file. % 7 %    o image: The address of a structure of type Image.  %  %  */3 Export unsigned long LSBFirstReadLong(Image *image)  {    unsigned char      buffer[4];     unsigned long 
     value;  "   assert(image != (Image *) NULL);*   value=ReadBlob(image,4,(char *) buffer);   if (value == 0)      return((unsigned long) ~0);    value=buffer[3] << 24;   value|=buffer[2] << 16;    value|=buffer[1] << 8;   value|=buffer[0];    return(value); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  L S B F i r s t R e a d S h o r t                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method LSBFirstReadShort reads a short value as a 16 bit quantity in & %  least-significant byte first order. % 1 %  The format of the LSBFirstReadShort method is:  % 5 %      unsigned short LSBFirstReadShort(Image *image)  % + %  A description of each parameter follows.  % K %    o value:  Method LSBFirstReadShort returns an unsigned short read from  %      the file. % 7 %    o image: The address of a structure of type Image.  %  %  */5 Export unsigned short LSBFirstReadShort(Image *image)  {    unsigned char      buffer[2];     unsigned short
     value;  "   assert(image != (Image *) NULL);*   value=ReadBlob(image,2,(char *) buffer);   if (value == 0)       return((unsigned short) ~0);   value=buffer[1] << 8;    value|=buffer[0];    return(value); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  L S B F i r s t W r i t e L o n g                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method LSBFirstWriteLong writes a long value as a 32 bit quantity in & %  least-significant byte first order. % 1 %  The format of the LSBFirstWriteLong method is:  % G %      size_t LSBFirstWriteLong(Image *image,const unsigned long value)  % + %  A description of each parameter follows.  % K %    o count: Method LSBFirstWriteLong returns the number of unsigned longs  %      written.  % 7 %    o image: The address of a structure of type Image.  % + %    o value: Specifies the value to write.  %  %  */G Export size_t LSBFirstWriteLong(Image *image,const unsigned long value)  {    unsigned char      buffer[4];  "   assert(image != (Image *) NULL);   buffer[0]=value;   buffer[1]=value >> 8;    buffer[2]=value >> 16;   buffer[3]=value >> 24;$   return(WriteBlob(image,4,buffer)); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  L S B F i r s t W r i t e S h o r t                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method LSBFirstWriteShort writes a long value as a 16 bit quantity in& %  least-significant byte first order. % 2 %  The format of the LSBFirstWriteShort method is: % G %      size_t LSBFirstWriteShort(Image *image,const unsigned int value)  % + %  A description of each parameter follows.  % L %    o count: Method LSBFirstWriteShort returns the number of unsigned longs %      written.  % 7 %    o image: The address of a structure of type Image.  % , %    o value:  Specifies the value to write. %  %  */G Export size_t LSBFirstWriteShort(Image *image,const unsigned int value)  {    unsigned char      buffer[2];  "   assert(image != (Image *) NULL);   buffer[0]=value;   buffer[1]=(value) >> 8; $   return(WriteBlob(image,2,buffer)); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  M a p B l o b                                                              % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method MapBlob creates a mapping from a file to a binary large object.  % ' %  The format of the MapBlob method is:  % L %      void *MapBlob(const char *filename,const MapMode mode,size_t *length) % + %  A description of each parameter follows:  % I %    o status:  Method MapBlob returns the address of the blob as well as  %      its length in bytes.  % < %    o filename: this string is the name of the file to map. % , %    o mode: ReadMode, WriteMode, or IOMode. % E %    o length: the length of the mapping is returned in this pointer.  %  %  */L Export void *MapBlob(const char *filename,const MapMode mode,size_t *length) { ( #if defined(HAVE_MMAP) || defined(WIN32)   int      descriptor;   
   struct stat      status;      void	     *map;      /*     Open file.   */$   assert(filename != (char *) NULL);$   assert(length != (size_t *) NULL);   switch (mode)    {      default:=     case ReadMode: descriptor=open(filename,O_RDONLY); break; >     case WriteMode: descriptor=open(filename,O_WRONLY); break;9     case IOMode: descriptor=open(filename,O_RDWR); break;    }    if (descriptor == -1)      return((void *) NULL);&   if (fstat(descriptor,&status) == -1)     return((void *) NULL);   *length=status.st_size;    /*
     Map file.    */   switch (mode)    {      case ReadMode:     default:     { H       map=mmap((char *) NULL,*length,PROT_READ,MAP_SHARED,descriptor,0);       break;     }      case WriteMode:      { I       map=mmap((char *) NULL,*length,PROT_WRITE,MAP_SHARED,descriptor,0);        break;     }      case IOMode:     { G       map=mmap((char *) NULL,*length,PROT_READ | PROT_WRITE,MAP_SHARED,          descriptor,0);       break;     }    }    (void) close(descriptor);    if (map == MAP_FAILED)     { C       MagickWarning(FileOpenWarning,"Unable to map file",filename);        return((void *) NULL);     }    return((void *) map);  #else    return((void *) NULL); #endif }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  M S B F i r s t O r d e r L o n g                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method MSBFirstOrderLong converts a least-significant byte first buffer. %  of integers to most-significant byte first. % 1 %  The format of the MSBFirstOrderLong method is:  % I %      void MSBFirstOrderLong(register char *p,const unsigned int length)  % + %  A description of each parameter follows.  % 7 %   o  p:  Specifies a pointer to a buffer of integers.  % 3 %   o  length:  Specifies the length of the buffer.  %  %  */C Export void MSBFirstOrderLong(register char *p,const size_t length)  {    register char      c,     *q,      *sp;     assert(p != (char *) NULL); 
   q=p+length;    while (p < q)    {      sp=p+3;      c=(*sp);
     *sp=(*p);      *p++=c;      sp=p+1;      c=(*sp);
     *sp=(*p);      *p++=c; 	     p+=2;    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  M S B F i r s t O r d e r S h o r t                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method MSBFirstOrderShort converts a least-significant byte first buffer . %  of integers to most-significant byte first. % 2 %  The format of the MSBFirstOrderShort method is: % D %      void MSBFirstOrderShort(register char *p,const size_t length) % + %  A description of each parameter follows.  % 7 %   o  p:  Specifies a pointer to a buffer of integers.  % 3 %   o  length:  Specifies the length of the buffer.  %  %  */D Export void MSBFirstOrderShort(register char *p,const size_t length) {    register char      c,     *q;      assert(p != (char *) NULL); 
   q=p+length;    while (p < q)    {      c=(*p);      *p=(*(p+1));     p++;     *p++=c;    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  M S B F i r s t R e a d S h o r t                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method MSBFirstReadShort reads a short value as a 16 bit quantity in % %  most-significant byte first order.  % 1 %  The format of the MSBFirstReadShort method is:  % 5 %      unsigned short MSBFirstReadShort(Image *image)  % + %  A description of each parameter follows.  % K %    o value:  Method MSBFirstReadShort returns an unsigned short read from  %      the file. % 7 %    o image: The address of a structure of type Image.  %  %  */5 Export unsigned short MSBFirstReadShort(Image *image)  {    unsigned char      buffer[2];     unsigned short
     value;  "   assert(image != (Image *) NULL);*   value=ReadBlob(image,2,(char *) buffer);   if (value == 0)       return((unsigned short) ~0);   value=buffer[0] << 8;    value|=buffer[1];    return(value); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  M S B F i r s t R e a d L o n g                                            % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method MSBFirstReadLong reads a long value as a 32 bit quantity in % %  most-significant byte first order.  % 0 %  The format of the MSBFirstReadLong method is: % 3 %      unsigned long MSBFirstReadLong(Image *image)  % + %  A description of each parameter follows.  % I %    o value:  Method MSBFirstReadLong returns an unsigned long read from  %      the file. % 7 %    o image: The address of a structure of type Image.  %  %  %  */3 Export unsigned long MSBFirstReadLong(Image *image)  {    unsigned char      buffer[4];     unsigned long 
     value;  "   assert(image != (Image *) NULL);*   value=ReadBlob(image,4,(char *) buffer);   if (value == 0)      return((unsigned long) ~0);    value=buffer[0] << 24;   value|=buffer[1] << 16;    value|=buffer[2] << 8;   value|=buffer[3];    return(value); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  M S B F i r s t W r i t e L o n g                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method MSBFirstWriteLong writes a long value as a 32 bit quantity in % %  most-significant byte first order.  % 1 %  The format of the MSBFirstWriteLong method is:  % G %      size_t MSBFirstWriteLong(Image *image,const unsigned long value)  % + %  A description of each parameter follows.  % K %    o count: Method MSBFirstWriteLong returns the number of unsigned longs  %      written.  % , %    o value:  Specifies the value to write. % 7 %    o image: The address of a structure of type Image.  %  %  */G Export size_t MSBFirstWriteLong(Image *image,const unsigned long value)  {    unsigned char      buffer[4];  "   assert(image != (Image *) NULL);   buffer[0]=value >> 24;   buffer[1]=value >> 16;   buffer[2]=value >> 8;    buffer[3]=value;$   return(WriteBlob(image,4,buffer)); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  M S B F i r s t W r i t e S h o r t                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method MSBFirstWriteShort writes a long value as a 16 bit quantity in% %  most-significant byte first order.  % 2 %  The format of the MSBFirstWriteShort method is: % I %      size_t MSBFirstWriteShort(Image *image,const unsigned short value)  % + %  A description of each parameter follows.  % , %   o  value:  Specifies the value to write. % 6 %   o  file:  Specifies the file to write the data to. %  %  */G Export size_t MSBFirstWriteShort(Image *image,const unsigned int value)  {    unsigned char      buffer[2];  "   assert(image != (Image *) NULL);   buffer[0]=(value) >> 8;    buffer[1]=value;$   return(WriteBlob(image,2,buffer)); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   O p e n B l o b                                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method OpenBlob open a file associated with the image.  A file name of K %  '-' sets the file to stdin for type 'r' and stdout for type 'w'.  If the K %  filename suffix is '.gz' or '.Z', the image is decompressed for type 'r' K %  and compressed for type 'w'.  If the filename prefix is '|', it is piped  %  to or from a system command.  % ( %  The format of the OpenBlob method is: % F %      unsigned int OpenBlob(const ImageInfo *image_info,Image *image, %        const char *type) % + %  A description of each parameter follows:  % H %    o status:  Method OpenBlob returns True if the file is successfully %      opened otherwise False. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % 7 %    o image: The address of a structure of type Image.  % . %    o type: 'r' for reading; 'w' for writing. %  */F Export unsigned int OpenBlob(const ImageInfo *image_info,Image *image,   const char *type)  {    char     filename[MaxTextExtent];     register char      *p;   +   assert(image_info != (ImageInfo *) NULL); "   assert(image != (Image *) NULL);    assert(type != (char *) NULL);2   if (image_info->blob_info.data != (char *) NULL)     { -       image->blob_info=image_info->blob_info;        return(True);      } !   GetBlobInfo(&image->blob_info);    image->exempt=False;(   if (image_info->file != (FILE *) NULL)     {        /*)         Use previously opened filehandle.        */#       image->file=image_info->file;        image->exempt=True;        return(True);      } *   (void) strcpy(filename,image->filename);   p=(char *) NULL;   if (*filename != '|')      { #       if ((Extent(filename) > 4) && C           (Latin1Compare(filename+Extent(filename)-4,".pgp") == 0)) 	         {            /*=             Decrypt image file with PGP encryption utilities.            */           if (*type == 'r') G             p=GetDelegateCommand(image_info,image,"pgp",(char *) NULL); 	         } 
       else%         if ((Extent(filename) > 4) && E             (Latin1Compare(filename+Extent(filename)-4,".bz2") == 0))            {              /*J               Uncompress/compress image file with BZIP compress utilities.             */             if (*type == 'r') J               p=GetDelegateCommand(image_info,image,"bzip",(char *) NULL);             elseJ               p=GetDelegateCommand(image_info,image,(char *) NULL,"bzip");           }          else'           if ((Extent(filename) > 3) && F               (Latin1Compare(filename+Extent(filename)-3,".gz") == 0))
             {                /*K                 Uncompress/compress image file with GNU compress utilities.                */               if (*type == 'r') K                 p=GetDelegateCommand(image_info,image,"zip",(char *) NULL);                elseK                 p=GetDelegateCommand(image_info,image,(char *) NULL,"zip"); 
             }            else)             if ((Extent(filename) > 2) && G                 (Latin1Compare(filename+Extent(filename)-2,".Z") == 0))                {                  /*N                   Uncompress/compress image file with UNIX compress utilities.                 */!                 if (*type == 'r') C                   p=GetDelegateCommand(image_info,image,"compress", #                     (char *) NULL);                  elseF                   p=GetDelegateCommand(image_info,image,(char *) NULL,                      "compress");               }      }    if (p != (char *) NULL)      {         (void) strcpy(filename,p);       FreeMemory(p);     }    /*     Open image file.   */   image->pipe=False;'   if (Latin1Compare(filename,"-") == 0)      { 2       image->file=(*type == 'r') ? stdin : stdout; #if defined(_VISUALC_),       if (strchr(type,'b') != (char *) NULL)1         _setmode(_fileno(image->file),_O_BINARY);  #endif       image->exempt=True;      }    else; #if !defined(vms) && !defined(macintosh) && !defined(WIN32)      if (*filename == '|')        {          char           mode[MaxTextExtent];  
         /*1           Pipe image to or from a system command. 
         */         if (*type == 'w') )           (void) signal(SIGPIPE,SIG_IGN); $         (void) strncpy(mode,type,1);         mode[1]='\0'; 4         image->file=(FILE *) popen(filename+1,mode);         image->pipe=True;          image->exempt=True;        }      else #endif       {          if (*type == 'w')            {              /*2               Form filename for multi-part images.             */@             FormatString(filename,image->filename,image->scene);$             if (!image_info->adjoin)8               if ((image->previous != (Image *) NULL) ||2                   (image->next != (Image *) NULL))                 { G                   if ((Latin1Compare(filename,image->filename) == 0) || >                       (strchr(filename,'%') != (char *) NULL))G                     FormatString(filename,"%.1024s.%u",image->filename, $                       image->scene);4                   if (image->next != (Image *) NULL)E                     (void) strcpy(image->next->magick,image->magick);                  } 4             (void) strcpy(image->filename,filename);           }  #if defined(macintosh)         if (*type == 'w') A           SetApplicationType(filename,image_info->magick,'8BIM');  #endif         if (*type == 'r')            {              MagickInfo               *magick_info;   I             magick_info=(MagickInfo *) GetMagickInfo(image_info->magick); 3             if (magick_info != (MagickInfo *) NULL)                { .                 if (magick_info->blob_support)                   {                      /*D                       Format supports blobs-- try memory-mapped I/O.                     */.                     image->blob_info.length=0;2                     image->blob_info.data=(char *)J                       MapBlob(filename,ReadMode,&image->blob_info.length);,                     image->blob_info.mapped==                       image->blob_info.data != (void *) NULL;                    }                }            } %         if (!image->blob_info.mapped) 4           image->file=(FILE *) fopen(filename,type);)         if (image->file != (FILE *) NULL)            { /             (void) SeekBlob(image,0L,SEEK_END); ,             image->filesize=TellBlob(image);/             (void) SeekBlob(image,0L,SEEK_SET);            }        }    image->status=False;   if (*type == 'r')      { !       image->next=(Image *) NULL; %       image->previous=(Image *) NULL;      } L   return((image->file != (FILE *) NULL) || (image->blob_info.data != NULL)); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  R e a d B l o b                                                            % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method ReadBlob reads data from the blob or image file and returns it.  It $ %  returns the number of bytes read. % ( %  The format of the ReadBlob method is: % I %      size_t ReadBlob(Image *image,const size_t number_bytes,char *data)  % + %  A description of each parameter follows:  % @ %    o count:  Method ReadBlob returns the number of items read. % 7 %    o image: The address of a structure of type Image.  % K %    o number_bytes:  Specifies an integer representing the number of bytes  %      to read from the file.  % G %    o data:  Specifies an area to place the information requested from  %      the file. %  %  */I Export size_t ReadBlob(Image *image,const size_t number_bytes,void *data)  {    off_t      offset;      register int     i;     size_t
     count;  "   assert(image != (Image *) NULL);    assert(data != (char *) NULL);-   if (image->blob_info.data != (char *) NULL)      {        /*         Read bytes from blob.        */-       offset=Min(number_bytes,(unsigned long) ;         (image->blob_info.length-image->blob_info.offset));        if (offset > 0) I         (void) memcpy(data,image->blob_info.data+image->blob_info.offset,            offset);&       image->blob_info.offset+=offset;       return(offset);      }    /*"     Read bytes from a file handle.   */   offset=0; '   for (i=number_bytes; i > 0; i-=count)    { 6     count=fread((char *) data+offset,1,i,image->file);     if (count <= 0)        break;     offset+=count;   }    return(offset);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  R e a d B y t e                                                            % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method ReadByte reads a single byte from the image file and returns it. % ( %  The format of the ReadByte method is: % ! %      int ReadByte(Image *image)  % + %  A description of each parameter follows.  % D %    o value: Method ReadByte returns an integer read from the file. % 7 %    o image: The address of a structure of type Image.  %  %  */! Export int ReadByte(Image *image)  {    int 
     count;     unsigned char 
     value;  "   assert(image != (Image *) NULL);*   count=ReadBlob(image,1,(char *) &value);   if (count == 0)      return(EOF);   return(value); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  R e a d D a t a B l o c k                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method ReadBlobBlock reads data from the image file and returns it.  The J %  amount of data is determined by first reading a count byte.  The number %  or bytes read is returned.  % - %  The format of the ReadBlobBlock method is:  % 4 %      size_t ReadBlobBlock(Image *image,char *data) % + %  A description of each parameter follows:  % E %    o count:  Method ReadBlobBlock returns the number of bytes read.  % 7 %    o image: The address of a structure of type Image.  % G %    o data:  Specifies an area to place the information requested from  %      the file. %  %  */4 Export size_t ReadBlobBlock(Image *image,char *data) {    size_t
     count;     unsigned char      block_count;  "   assert(image != (Image *) NULL);    assert(data != (char *) NULL);0   count=ReadBlob(image,1,(char *) &block_count);   if (count == 0)      return(0);2   count=ReadBlob(image,(size_t) block_count,data);   return(count); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  S e e k B l o b                                                            % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method SeekBlob sets the offset in bytes from the beginning of a blob or  %  file. % ( %  The format of the SeekBlob method is: % E %      int SeekBlob(Image *image,const off_t offset,const int whence)  % + %  A description of each parameter follows:  % D %    o status:  Method SeekBlob returns 0 on success; otherwise,  it7 %      returned -1 and set errno to indicate the error.  % 7 %    o image: The address of a structure of type Image.  % F %    o offset:  Specifies an integer representing the offset in bytes. % C %    o whence:  Specifies an integer representing how the offset is @ %      treated relative to the beginning of the blob as follows: % 6 %        SEEK_SET  Set position equal to offset bytes.@ %        SEEK_CUR  Set position to current location plus offset.3 %        SEEK_END  Set position to EOF plus offset.  %  %  */E Export int SeekBlob(Image *image,const off_t offset,const int whence)  { "   assert(image != (Image *) NULL);-   if (image->blob_info.data == (char *) NULL) -     return(fseek(image->file,offset,whence));    switch (whence)    {      case SEEK_SET:     default:     {        if (offset < 0)          return(-1); %       image->blob_info.offset=offset;        break;     }      case SEEK_CUR:     { /       if ((image->blob_info.offset+offset) < 0)          return(-1); &       image->blob_info.offset+=offset;       break;     }      case SEEK_END:     { G       if ((image->blob_info.offset+image->blob_info.length+offset) < 0)          return(-1); =       image->blob_info.offset=image->blob_info.length+offset;        break;     }    } 8   if (image->blob_info.offset > image->blob_info.length)     { 6       image->blob_info.length=image->blob_info.offset;$       image->blob_info.data=(char *)H         ReallocateMemory(image->blob_info.data,image->blob_info.length);1       if (image->blob_info.data == (char *) NULL) 	         { $           image->blob_info.length=0;           return(-1); 	         } 6       image->blob_info.extent=image->blob_info.length;     }    return(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  S e t B l o b Q u a n t u m                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method SetBlobQuantum set the current value of the blob quantum.  This K %  is the size in bytes to add to a blob when writing to a blob exceeds its  %  current length. % . %  The format of the SetBlobQuantum method is: % D %      void SetBlobQuantum(BlobInfo *blob_info,const size_t quantum) % + %  A description of each parameter follows:  % 5 %    o blob_info:  A pointer to a BlobInfo structure.  % N %    o quantum: A size_t that reflects the number of bytes to increase a blob. %  %  */D Export void SetBlobQuantum(BlobInfo *blob_info,const size_t quantum) { )   assert(blob_info != (BlobInfo *) NULL);    blob_info->quantum=quantum;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  S y n c B l o b                                                            % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % : %  Method SyncBlob flushes the datastream if it is a file. % ( %  The format of the SyncBlob method is: % ' %      int SyncBlob(const Image *image)  % + %  A description of each parameter follows:  % D %    o status:  Method SyncBlob returns 0 on success; otherwise,  it6 %      returns -1 and set errno to indicate the error. % 7 %    o image: The address of a structure of type Image.  %  %  */' Export int SyncBlob(const Image *image)  { "   assert(image != (Image *) NULL);-   if (image->blob_info.data == (char *) NULL)       return(fflush(image->file));   return(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  T e l l B l o b                                                            % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method TellBlob obtains the current value of the blob or file position. % ( %  The format of the TellBlob method is: % ) %      off_t TellBlob(const Image *image)  % + %  A description of each parameter follows:  % H %    o status:  Method TellBlob returns the current value of the blob orH %      file position success; otherwise, it returns -1 and sets errno to %      indicate the error. % 7 %    o image: The address of a structure of type Image.  %  %  */) Export off_t TellBlob(const Image *image)  { "   assert(image != (Image *) NULL);#   if (image->file != (FILE *) NULL)      return(ftell(image->file)); "   return(image->blob_info.offset); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  U n m a p B l o b                                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method UnmapBlob deallocates the binary large object previously allocated %  with the MapBlob method.  % ) %  The format of the UnmapBlob method is:  % < %      unsigned int UnmapBlob(void *map,const size_t length) % + %  A description of each parameter follows:  % H %    o status:  Method UnmapBlob returns True on success; otherwise,  it9 %      returns False and set errno to indicate the error.  % 4 %    o map: The address  of the binary large object. % 5 %    o length: The length of the binary large object.  %  %  */< Export unsigned int UnmapBlob(void *map,const size_t length) { ( #if defined(HAVE_MMAP) || defined(WIN32)   int      status;      status=munmap(map,length);   if (status == -1) B     MagickError(BlobWarning,"Unable to unmap file",(char *) NULL);   return(status);  #else 
   return(-1);  #endif }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  W r i t e B l o b                                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method WriteBlob writes data to a blob or image file.  It returns the %  number of items written.  % ) %  The format of the WriteBlob method is:  % P %      size_t WriteBlob(Image *image,const size_t number_bytes,const void *data) % + %  A description of each parameter follows:  % G %    o status:  Method WriteBlob returns True if all the data requested 2 %      is obtained without error, otherwise False. % 7 %    o image: The address of a structure of type Image.  % @ %    o size:  Specifies an integer representing the length of an1 %      individual item to be written to the file.  % K %    o number_items:  Specifies an integer representing the number of items  %      to write to the file. % C %    o data:  The address of the data to write to the blob or file.  %  %  */P Export size_t WriteBlob(Image *image,const size_t number_bytes,const void *data) {    size_t
     count;  "   assert(image != (Image *) NULL);&   assert(data != (const char *) NULL);-   if (image->blob_info.data == (char *) NULL)      { =       count=fwrite((char *) data,1,number_bytes,image->file);        return(count);     } G   if (number_bytes > (image->blob_info.extent-image->blob_info.offset))      { E       image->blob_info.extent+=number_bytes+image->blob_info.quantum; $       image->blob_info.data=(char *)H         ReallocateMemory(image->blob_info.data,image->blob_info.extent);1       if (image->blob_info.data == (char *) NULL) 	         { $           image->blob_info.extent=0;           return(0);	         }      } C   (void) memcpy(image->blob_info.data+image->blob_info.offset,data,      number_bytes);(   image->blob_info.offset+=number_bytes;8   if (image->blob_info.offset > image->blob_info.length)4     image->blob_info.length=image->blob_info.offset;   return(number_bytes);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  W r i t e B y t e                                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method WriteByte write an integer to a file.  It returns the number of ! %  bytes written (either 0 or 1);  % ) %  The format of the WriteByte method is:  % 5 %      size_t WriteByte(Image *image,const int value)  % + %  A description of each parameter follows.  % D %    o count:  Method WriteByte returns the number of bytes written. % 7 %    o image: The address of a structure of type Image.  % + %    o value: Specifies the value to write.  %  %  */5 Export size_t WriteByte(Image *image,const int value)  {    char     c;     size_t
     count;  "   assert(image != (Image *) NULL);   c=(char) value;    count=WriteBlob(image,1,&c);   return(count); } 