 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            BBBB   M   M  PPPP                               % O %                            B   B  MM MM  P   P                              % O %                            BBBB   M M M  PPPP                               % O %                            B   B  M   M  P                                  % O %                            BBBB   M   M  P                                  % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e c o d e I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method DecodeImage unpacks the packed image pixels into runlength-encoded %  pixel packets.  % + %  The format of the DecodeImage method is:  % L %      unsigned int DecodeImage(Image *image,const unsigned int compression,J %        const unsigned int number_columns,const unsigned int number_rows, %        unsigned char *pixels)  % + %  A description of each parameter follows:  % E %    o status:  Method DecodeImage returns True if all the pixels are 3 %      uncompressed without error, otherwise False.  % 7 %    o image: The address of a structure of type Image.  % K %    o compression:  A value of 1 means the compressed pixels are runlength M %      encoded for a 256-color bitmap.  A value of 2 means a 16-color bitmap.  % I %    o number_columns:  An integer value that is the number of columns or , %      width in pixels of your source image. % C %    o number_rows:  An integer value that is the number of rows or - %      heigth in pixels of your source image.  % M %    o pixels:  The address of a byte (8 bits) array of pixel data created by  %      the decoding process. %  %  */L static unsigned int DecodeImage(Image *image,const unsigned int compression,C   const unsigned int number_columns,const unsigned int number_rows,    unsigned char *pixels) {    int 	     byte, 
     count,     y;     register int     i,     x;     register unsigned char     *q;   "   assert(image != (Image *) NULL);+   assert(pixels != (unsigned char *) NULL); 8   for (i=0; i < (int) (number_columns*number_rows); i++)     pixels[i]=0;	   byte=0;    x=0;   q=pixels; $   for (y=0; y < (int) number_rows; )   {      count=ReadByte(image);     if (count == EOF)        break;     if (count != 0)        { 
         /*           Encoded mode. 
         */         byte=ReadByte(image); !         for (i=0; i < count; i++) 	         {            if (compression == 1) &             *q++=(unsigned char) byte;           elseC             *q++=(i & 0x01) ? (byte & 0x0f) : ((byte >> 4) & 0x0f);            x++;	         }        }      else       { 
         /*           Escape mode.
         */         count=ReadByte(image);         if (count == 0x01)           return(True);          switch (count)	         {            case 0x00:           {              /*               End of line.             */             x=0;             y++;&             q=pixels+y*number_columns;             break;           }            case 0x02:           {              /*               Delta mode.              */             x+=ReadByte(image);              y+=ReadByte(image); (             q=pixels+y*number_columns+x;             break;           }            default:           {              /*               Absolute mode.             */%             for (i=0; i < count; i++) 
             { #               if (compression == 1) %                 *q++=ReadByte(image);                else                 { &                   if ((i & 0x01) == 0))                     byte=ReadByte(image); I                   *q++=(i & 0x01) ? (byte & 0x0f) : ((byte >> 4) & 0x0f);                  }                x++;
             }              /*               Read pad byte.             */!             if (compression == 1)                { !                 if (count & 0x01) )                   (void) ReadByte(image);                }              elseA               if (((count & 0x03) == 1) || ((count & 0x03) == 2)) '                 (void) ReadByte(image);              break;           } 	         }        } #     if (QuantumTick(y,number_rows)) 3       ProgressMonitor(LoadImageText,y,number_rows);    } ,   (void) ReadByte(image);  /* end of line */   (void) ReadByte(image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   E n c o d e I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method EncodeImage compresses pixels using a runlength encoded format.  % + %  The format of the EncodeImage method is:  % < %      status=EncodeImage(pixels,number_columns,number_rows, %        compressed_pixels)  % + %  A description of each parameter follows:  % E %    o status:  Method EncodeImage returns the number of bytes in the / %      runlength encoded compress_pixels array.  % M %    o pixels:  The address of a byte (8 bits) array of pixel data created by  %      the compression process.  % I %    o number_columns:  An integer value that is the number of columns or , %      width in pixels of your source image. % C %    o number_rows:  An integer value that is the number of rows or - %      heigth in pixels of your source image.  % M %    o compressed_pixels:  The address of a byte (8 bits) array of compressed  %      pixel data. %  %  */< static unsigned int EncodeImage(const unsigned char *pixels,C   const unsigned int number_columns,const unsigned int number_rows, #   unsigned char *compressed_pixels)  {    int      y;     register const unsigned char     *p;      register int     i,     x;     register unsigned char     *q;      unsigned int     bytes_per_line;      /*     Runlength encode pixels.   */+   assert(pixels != (unsigned char *) NULL); 6   assert(compressed_pixels != (unsigned char *) NULL);   p=pixels;    q=compressed_pixels;   i=0;=   bytes_per_line=number_columns+(number_columns % 2 ? 1 : 0); '   for (y=0; y < (int) number_rows; y++)    { -     for (x=0; x < (int) bytes_per_line; x+=i)      {        /*         Determine runlength.       */4       for (i=1; ((x+i) < (int) bytes_per_line); i++))         if ((*(p+i) != *p) || (i == 255))            break;       *q++=(unsigned char) i;        *q++=(*p);       p+=i;      }      /*       End of line.     */     *q++=0x00;     *q++=0x00;#     if (QuantumTick(y,number_rows)) 3       ProgressMonitor(SaveImageText,y,number_rows);    }    /*     End of bitmap.   */	   *q++=0;    *q++=0x01;/   return((unsigned int) (q-compressed_pixels));  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s B M P                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method IsBMP returns True if the image format type, identified by the %  magick string, is BMP.  % , %  The format of the ReadBMPImage method is: % 6 %      unsigned int IsBMP(const unsigned char *magick,# %        const unsigned int length)  % + %  A description of each parameter follows:  % J %    o status:  Method IsBMP returns True if the image format type is BMP. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */P Export unsigned int IsBMP(const unsigned char *magick,const unsigned int length) {    if (length < 2)      return(False);+   if (strncmp((char *) magick,"BM",2) == 0)      return(True); +   if (strncmp((char *) magick,"IC",2) == 0)      return(True); +   if (strncmp((char *) magick,"PI",2) == 0)      return(True); +   if (strncmp((char *) magick,"CI",2) == 0)      return(True); +   if (strncmp((char *) magick,"CP",2) == 0)      return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d B M P I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method ReadBMPImage reads a Microsoft Windows bitmap image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % , %  The format of the ReadBMPImage method is: % % %      image=ReadBMPImage(image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadBMPImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadBMPImage(const ImageInfo *image_info)  {    typedef struct _BMPHeader    {      unsigned long        file_size;       unsigned short       reserved[2];       unsigned long        offset_bits,       size;        long       width,
       height;        unsigned short
       planes,        bits_per_pixel;        unsigned long        compression,       image_size,        x_pixels,        y_pixels,        number_colors,       colors_important;        unsigned short       red_mask,        green_mask,        blue_mask,       alpha_mask;        long       colorspace;   
     PointInfo        red_primary,       green_primary,       blue_primary,        gamma_scale;   } BMPHeader;     BMPHeader      bmp_header;      Image      *image;   
   IndexPacket 
     index;     int      bit,     y;     long     start_position;      register int     i,     x;     register PixelPacket     *q;      register unsigned char     *p;      unsigned char      *bmp_pixels,     magick[12];      unsigned int     bytes_per_line,      image_size,      status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*$     Determine if this is a BMP file.   */+   status=ReadBlob(image,2,(char *) magick);    do   {      /*       Verify BMP identifier.     */%     start_position=TellBlob(image)-2; D     if ((status == False) || (strncmp((char *) magick,"BM",2) != 0))C       ReaderExit(CorruptImageWarning,"Not a BMP image file",image); 1     bmp_header.file_size=LSBFirstReadLong(image); 4     bmp_header.reserved[0]=LSBFirstReadShort(image);4     bmp_header.reserved[1]=LSBFirstReadShort(image);3     bmp_header.offset_bits=LSBFirstReadLong(image); ,     bmp_header.size=LSBFirstReadLong(image);     if (image->filesize)I       if ((int) (bmp_header.file_size-bmp_header.size) > image->filesize) E         ReaderExit(CorruptImageWarning,"Not a BMP image file",image);      if (bmp_header.size == 12)       { 
         /*           OS/2 BMP image file.
         */2         bmp_header.width=LSBFirstReadShort(image);3         bmp_header.height=LSBFirstReadShort(image); 3         bmp_header.planes=LSBFirstReadShort(image); ;         bmp_header.bits_per_pixel=LSBFirstReadShort(image);          bmp_header.x_pixels=0;         bmp_header.y_pixels=0;#         bmp_header.number_colors=0; !         bmp_header.compression=0;           bmp_header.image_size=0;       }      else       { 
         /*+           Microsoft Windows BMP image file. 
         */1         bmp_header.width=LSBFirstReadLong(image); 2         bmp_header.height=LSBFirstReadLong(image);3         bmp_header.planes=LSBFirstReadShort(image); ;         bmp_header.bits_per_pixel=LSBFirstReadShort(image); 7         bmp_header.compression=LSBFirstReadLong(image); 6         bmp_header.image_size=LSBFirstReadLong(image);4         bmp_header.x_pixels=LSBFirstReadLong(image);4         bmp_header.y_pixels=LSBFirstReadLong(image);9         bmp_header.number_colors=LSBFirstReadLong(image); <         bmp_header.colors_important=LSBFirstReadLong(image);6         for (i=0; i < ((int) bmp_header.size-40); i++)!           (void) ReadByte(image); ,         if ((bmp_header.compression == 3) &&1             ((bmp_header.bits_per_pixel == 16) || 0              (bmp_header.bits_per_pixel == 32)))           { 9             bmp_header.red_mask=LSBFirstReadShort(image); ;             bmp_header.green_mask=LSBFirstReadShort(image); :             bmp_header.blue_mask=LSBFirstReadShort(image);%             if (bmp_header.size > 40)                {                  /*4                   Read color management information.                 */?                 bmp_header.alpha_mask=LSBFirstReadShort(image); >                 bmp_header.colorspace=LSBFirstReadLong(image);A                 bmp_header.red_primary.x=LSBFirstReadLong(image); A                 bmp_header.red_primary.y=LSBFirstReadLong(image); A                 bmp_header.red_primary.z=LSBFirstReadLong(image); C                 bmp_header.green_primary.x=LSBFirstReadLong(image); C                 bmp_header.green_primary.y=LSBFirstReadLong(image); C                 bmp_header.green_primary.z=LSBFirstReadLong(image); B                 bmp_header.blue_primary.x=LSBFirstReadLong(image);B                 bmp_header.blue_primary.y=LSBFirstReadLong(image);B                 bmp_header.blue_primary.z=LSBFirstReadLong(image);B                 bmp_header.gamma_scale.x=LSBFirstReadShort(image);B                 bmp_header.gamma_scale.y=LSBFirstReadShort(image);B                 bmp_header.gamma_scale.z=LSBFirstReadShort(image);               }            }        } 1     image->matte=bmp_header.bits_per_pixel == 32; 3     image->columns=(unsigned int) bmp_header.width; @     image->rows=(unsigned int) AbsoluteValue(bmp_header.height);L     if ((bmp_header.number_colors != 0) && (bmp_header.bits_per_pixel < 16))       { !         image->class=PseudoClass; >         image->colors=(unsigned int) bmp_header.number_colors;         if (image->colors == 0) 7           image->colors=1 << bmp_header.bits_per_pixel;        }      if (image_info->ping)        {          CloseBlob(image);          return(image);       } $     if (image->class == PseudoClass)       {          unsigned char            *bmp_colormap;           unsigned int           packet_size;  
         /*"           Allocate image colormap.
         */'         image->colormap=(PixelPacket *) <           AllocateMemory(image->colors*sizeof(PixelPacket));4         if (image->colormap == (PixelPacket *) NULL)L           ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);
         /*#           Read BMP raster colormap. 
         */&         bmp_colormap=(unsigned char *)@           AllocateMemory(4*image->colors*sizeof(unsigned char));3         if (bmp_colormap == (unsigned char *) NULL) L           ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);         packet_size=4;"         if (bmp_header.size == 12)           packet_size=3;8         (void) ReadBlob(image,packet_size*image->colors,!           (char *) bmp_colormap);          p=bmp_colormap; /         for (i=0; i < (int) image->colors; i++) 	         { 0           image->colormap[i].blue=UpScale(*p++);1           image->colormap[i].green=UpScale(*p++); /           image->colormap[i].red=UpScale(*p++); $           if (bmp_header.size != 12)             p++;	         } !         FreeMemory(bmp_colormap);        } K     while (TellBlob(image) < (int) (start_position+bmp_header.offset_bits))        (void) ReadByte(image);      /*       Read image data.     */$     if (bmp_header.compression == 2)$       bmp_header.bits_per_pixel<<=1;H     bytes_per_line=((image->columns*bmp_header.bits_per_pixel+31)/32)*4;*     image_size=bytes_per_line*image->rows;      bmp_pixels=(unsigned char *)7       AllocateMemory(image_size*sizeof(unsigned char)); -     if (bmp_pixels == (unsigned char *) NULL) H       ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);G     if ((bmp_header.compression == 0) || (bmp_header.compression == 3)) <       (void) ReadBlob(image,image_size,(char *) bmp_pixels);     else       { 
         /*3           Convert run-length encoded raster pixels. 
         */G         status=DecodeImage(image,(unsigned int) bmp_header.compression, B           (unsigned int) bmp_header.width,image->rows,bmp_pixels);         if (status == False)L           ReaderExit(CorruptImageWarning,"runlength decoding failed",image);       }      /*!       Initialize image structure.      *//     image->units=PixelsPerCentimeterResolution; 2     image->x_resolution=bmp_header.x_pixels/100.0;2     image->y_resolution=bmp_header.y_pixels/100.0;     /*0       Convert BMP raster image to pixel packets.     */&     switch (bmp_header.bits_per_pixel)     { 
       case 1:        { 
         /*E           Convert bitmap scanline to runlength-encoded color packets. 
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;7           for (x=0; x < ((int) image->columns-7); x+=8)            { '             for (bit=0; bit < 8; bit++) 
             { 9               index=((*p) & (0x80 >> bit) ? 0x00 : 0x01); *               image->indexes[x+bit]=index;*               *q++=image->colormap[index];
             }              p++;           } (           if ((image->columns % 8) != 0)
             { B               for (bit=0; bit < (int) (image->columns % 8); bit++)               { ;                 index=((*p) & (0x80 >> bit) ? 0x00 : 0x01); ,                 image->indexes[x+bit]=index;,                 *q++=image->colormap[index];               }                p++;
             } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) I               ProgressMonitor(LoadImageText,image->rows-y-1,image->rows); 	         }          break;       } 
       case 4:        { 
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;7           for (x=0; x < ((int) image->columns-1); x+=2)            { "             index=(*p >> 4) & 0xf;$             image->indexes[x]=index;(             *q++=image->colormap[index];             index=(*p) & 0xf; &             image->indexes[x+1]=index;(             *q++=image->colormap[index];             p++;           } (           if ((image->columns % 2) != 0)
             { $               index=(*p >> 4) & 0xf;&               image->indexes[x]=index;*               *q++=image->colormap[index];               p++;
             } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) I               ProgressMonitor(LoadImageText,image->rows-y-1,image->rows); 	         }          break;       } 
       case 8:        { 
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */K         if ((bmp_header.compression == 1) || (bmp_header.compression == 2)) (           bytes_per_line=image->columns;*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           {              index=(*p++); $             image->indexes[x]=index;(             *q++=image->colormap[index];           } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) I               ProgressMonitor(LoadImageText,image->rows-y-1,image->rows); 	         }          break;       }        case 16:       {          unsigned char            h,           l;  
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */(         if (bmp_header.compression == 1)-           bytes_per_line=image->columns << 1; *         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           {              h=(*p++);              l=(*p++); C             q->red=(Quantum) ((MaxRGB*((int) (l & 0x7c) >> 2))/31);              q->green=(Quantum)N               ((MaxRGB*(((int) (l & 0x03) << 3)+((int) (h & 0xe0) >> 5)))/31);?             q->blue=(Quantum) ((MaxRGB*((int) (h & 0x1f)))/31);              q++;           } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) I               ProgressMonitor(LoadImageText,image->rows-y-1,image->rows); 	         }          break;       }        case 24:       case 32:       { 
         /*J           Convert DirectColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { "             q->blue=UpScale(*p++);#             q->green=UpScale(*p++); !             q->red=UpScale(*p++);              if (image->matte) .               q->opacity=Opaque-UpScale(*p++);             q++;           } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) I               ProgressMonitor(LoadImageText,image->rows-y-1,image->rows); 	         }          break;       }        default:E         ReaderExit(CorruptImageWarning,"Not a BMP image file",image);      }      FreeMemory(bmp_pixels);      if (bmp_header.height < 0)       { 
         Image            *flipped_image;   
         /*$           Correct image orientation.
         */'         flipped_image=FlipImage(image); ,         if (flipped_image != (Image *) NULL)           {               DestroyImage(image);              image=flipped_image;           }        }      /*       Proceed to next image.     */"     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;     *magick='\0'; -     (void) ReadBlob(image,2,(char *) magick); -     if (strncmp((char *) magick,"BM",2) == 0)        { 
         /*(           Allocate next image structure.
         */,         AllocateNextImage(image_info,image);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            }          image=image->next;F         ProgressMonitor(LoadImagesText,(unsigned int) TellBlob(image),*           (unsigned int) image->filesize);       } 1   } while (strncmp((char *) magick,"BM",2) == 0); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e B M P I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method WriteBMPImage writes an image in Microsoft Windows bitmap encoded  %  image format. % - %  The format of the WriteBMPImage method is:  % K %      unsigned int WriteBMPImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % H %    o status: Method WriteBMPImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K Export unsigned int WriteBMPImage(const ImageInfo *image_info,Image *image)  {    typedef struct _BMPHeader    {      unsigned long        file_size;       unsigned short       reserved[2];       unsigned long        offset_bits,       size,        width,
       height;        unsigned short
       planes,        bit_count;       unsigned long        compression,       image_size,        x_pixels,        y_pixels,        number_colors,       colors_important;    } BMPHeader;     BMPHeader      bmp_header;      int      y;     register int     i,     x;     register PixelPacket     *p;      register unsigned char     *q;      unsigned char      *bmp_data,     *bmp_pixels;     unsigned int     bytes_per_line, 
     scene,     status;      /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);
   scene=0;   do   {      /*(       Initialize BMP raster file header.     */+     TransformRGBImage(image,RGBColorspace);      bmp_header.file_size=14+40; !     bmp_header.offset_bits=14+40; ;     if ((Latin1Compare(image_info->magick,"BMP24") == 0) || 7         (!IsPseudoClass(image) && !IsGrayImage(image)))        { 
         /*            Full color BMP raster.
         */!         image->class=DirectClass; #         bmp_header.number_colors=0; 4         bmp_header.bit_count=image->matte ? 32 : 24;G         bytes_per_line=4*((image->columns*bmp_header.bit_count+31)/32);        }      else       { 
         /*!           Colormapped BMP raster. 
         */         bmp_header.bit_count=8; C         bytes_per_line=image->columns+(image->columns % 2 ? 1 : 0); %         if (IsMonochromeImage(image))            { #             bmp_header.bit_count=1; K             bytes_per_line=4*((image->columns*bmp_header.bit_count+31)/32);            } <         bmp_header.file_size+=4*(1 << bmp_header.bit_count);>         bmp_header.offset_bits+=4*(1 << bmp_header.bit_count);;         bmp_header.number_colors=1 << bmp_header.bit_count;        }      bmp_header.reserved[0]=0;      bmp_header.reserved[1]=0;      bmp_header.size=40; $     bmp_header.width=image->columns;"     bmp_header.height=image->rows;     bmp_header.planes=1;     bmp_header.compression=0; 5     bmp_header.image_size=bytes_per_line*image->rows; 0     bmp_header.file_size+=bmp_header.image_size;     bmp_header.x_pixels=75*39;     bmp_header.y_pixels=75*39;0     if (image->units == PixelsPerInchResolution)       { M         bmp_header.x_pixels=(unsigned long) (100.0*image->x_resolution/2.54); M         bmp_header.y_pixels=(unsigned long) (100.0*image->y_resolution/2.54);        } 6     if (image->units == PixelsPerCentimeterResolution)       { H         bmp_header.x_pixels=(unsigned long) (100.0*image->x_resolution);H         bmp_header.y_pixels=(unsigned long) (100.0*image->y_resolution);       } 9     bmp_header.colors_important=bmp_header.number_colors;      /*(       Convert MIFF to BMP raster pixels.     */      bmp_pixels=(unsigned char *)B       AllocateMemory(bmp_header.image_size*sizeof(unsigned char));-     if (bmp_pixels == (unsigned char *) NULL) H       WriterExit(ResourceLimitWarning,"Memory allocation failed",image);!     switch (bmp_header.bit_count)      { 
       case 1:        {          register unsigned char           bit,           byte,            polarity;   
         /*>           Convert PseudoClass image to a BMP monochrome image.
         */?         polarity=Intensity(image->colormap[0]) < (MaxRGB >> 1);          if (image->colors == 2)            polarity= J             Intensity(image->colormap[1]) < Intensity(image->colormap[0]);-         for (y=0; y < (int) image->rows; y++) 	         { 6           p=GetPixelCache(image,0,y,image->columns,1);(           if (p == (PixelPacket *) NULL)             break;8           q=bmp_pixels+(image->rows-y-1)*bytes_per_line;           bit=0;           byte=0; 2           for (x=0; x < (int) image->columns; x++)           {              byte<<=1; .             if (image->indexes[x] == polarity)               byte|=0x01;              bit++;             if (bit == 8)                {                  *q++=byte;                 bit=0;                 byte=0;                }               p++;             }          if (bit != 0)             *q++=byte << (8-bit);/          if (image->previous == (Image *) NULL) *            if (QuantumTick(y,image->rows)):              ProgressMonitor(SaveImageText,y,image->rows);	         }          break;       } 
       case 8:        { 
         /*2           Convert PseudoClass packet to BMP pixel.
         */-         for (y=0; y < (int) image->rows; y++) 	         { 6           p=GetPixelCache(image,0,y,image->columns,1);(           if (p == (PixelPacket *) NULL)             break;8           q=bmp_pixels+(image->rows-y-1)*bytes_per_line;2           for (x=0; x < (int) image->columns; x++)           { #             *q++=image->indexes[x];              p++;           } 0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(SaveImageText,y,image->rows); 	         }          break;       }        case 24:       case 32:       { 
         /*6           Convert DirectClass packet to BMP RGB pixel.
         */-         for (y=0; y < (int) image->rows; y++) 	         { 6           p=GetPixelCache(image,0,y,image->columns,1);(           if (p == (PixelPacket *) NULL)             break;8           q=bmp_pixels+(image->rows-y-1)*bytes_per_line;2           for (x=0; x < (int) image->columns; x++)           { $             *q++=DownScale(p->blue);%             *q++=DownScale(p->green); #             *q++=DownScale(p->red);              if (image->matte) 0               *q++=Opaque-DownScale(p->opacity);             p++;           } 0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(SaveImageText,y,image->rows); 	         }          break;       }      } "     if (bmp_header.bit_count == 8)3       if (image_info->compression != NoCompression) 	         {            unsigned int             packets;             /*5             Convert run-length encoded raster pixels.            */            packets=(unsigned int)<             ((bytes_per_line*(bmp_header.height+2)+1) << 1);$           bmp_data=(unsigned char *):             AllocateMemory(packets*sizeof(unsigned char));3           if (bmp_pixels == (unsigned char *) NULL) 
             { %               FreeMemory(bmp_pixels); P               WriterExit(ResourceLimitWarning,"Memory allocation failed",image);
             } 6           bmp_header.file_size-=bmp_header.image_size;            bmp_header.image_size=H             EncodeImage(bmp_pixels,image->columns,image->rows,bmp_data);6           bmp_header.file_size+=bmp_header.image_size;!           FreeMemory(bmp_pixels);            bmp_pixels=bmp_data;#           bmp_header.compression=1; 	         }      /*       Write BMP header.      */#     (void) WriteBlob(image,2,"BM"); 9     (void) LSBFirstWriteLong(image,bmp_header.file_size); <     (void) LSBFirstWriteShort(image,bmp_header.reserved[0]);<     (void) LSBFirstWriteShort(image,bmp_header.reserved[1]);;     (void) LSBFirstWriteLong(image,bmp_header.offset_bits); 4     (void) LSBFirstWriteLong(image,bmp_header.size);5     (void) LSBFirstWriteLong(image,bmp_header.width); 6     (void) LSBFirstWriteLong(image,bmp_header.height);7     (void) LSBFirstWriteShort(image,bmp_header.planes); :     (void) LSBFirstWriteShort(image,bmp_header.bit_count);;     (void) LSBFirstWriteLong(image,bmp_header.compression); :     (void) LSBFirstWriteLong(image,bmp_header.image_size);8     (void) LSBFirstWriteLong(image,bmp_header.x_pixels);8     (void) LSBFirstWriteLong(image,bmp_header.y_pixels);=     (void) LSBFirstWriteLong(image,bmp_header.number_colors); @     (void) LSBFirstWriteLong(image,bmp_header.colors_important);$     if (image->class == PseudoClass)       {          unsigned char            *bmp_colormap;  
         /*            Dump colormap to file.
         */&         bmp_colormap=(unsigned char *)N           AllocateMemory(4*(1 << bmp_header.bit_count)*sizeof(unsigned char));3         if (bmp_colormap == (unsigned char *) NULL) L           WriterExit(ResourceLimitWarning,"Memory allocation failed",image);         q=bmp_colormap; /         for (i=0; i < (int) image->colors; i++) 	         { 2           *q++=DownScale(image->colormap[i].blue);3           *q++=DownScale(image->colormap[i].green); 1           *q++=DownScale(image->colormap[i].red);            *q++=(Quantum) 0x0; 	         } ;         for ( ; i < (int) (1 << bmp_header.bit_count); i++) 	         {            *q++=(Quantum) 0x0;            *q++=(Quantum) 0x0;            *q++=(Quantum) 0x0;            *q++=(Quantum) 0x0; 	         } =         (void) WriteBlob(image,4*(1 << bmp_header.bit_count), !           (char *) bmp_colormap); !         FreeMemory(bmp_colormap);        } F     (void) WriteBlob(image,bmp_header.image_size,(char *) bmp_pixels);     FreeMemory(bmp_pixels); &     if (image->next == (Image *) NULL)       break;     image=GetNextImage(image);C     ProgressMonitor(SaveImagesText,scene++,GetNumberScenes(image));    } while (image_info->adjoin);    if (image_info->adjoin) -     while (image->previous != (Image *) NULL)        image=image->previous;   CloseBlob(image);    return(True);  } 