 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                      CCCC   AAA    CCCC  H   H  EEEEE                       % O %                     C      A   A  C      H   H  E                           % O %                     C      AAAAA  C      HHHHH  EEE                         % O %                     C      A   A  C      H   H  E                           % O %                      CCCC  A   A   CCCC  H   H  EEEEE                       % O %                                                                             % O %                                                                             % O %                      ImageMagick Pixel Cache Methods                        % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1999                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t P i x e l C a c h e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method GetPixelCache gets pixels from the in-memory or disk pixel cache as O %  defined by the geometry parameters.   A pointer to the pixels is returned if < %  the pixels are transferred, otherwise a NULL is returned. % B %  This example illustrates the use of the GetPixelCache() method: % * %    for (y=0; y < (int) image->rows; y++) %    {3 %      q=GetPixelCache(image,0,y,image->columns,1); % %      if (q == (PixelPacket *) NULL)  %        break; / %      for (x=0; x < (int) image->columns; x++)  %      {) %        if (image->class == PseudoClass) # %          index=image->indexes[x];  %        red=q->red; %        green=q->green; %        blue=q->blue;
 %        q++;  %      }- %      if (image->previous == (Image *) NULL) ( %        if (QuantumTick(y,image->rows))8 %          ProgressMonitor(LoadImageText,y,image->rows); %    } % - %  The format of the GetPixelCache method is:  % G %      PixelPacket *GetPixelCache(Image *image,const int x,const int y, < %        const unsigned int columns,const unsigned int rows) % + %  A description of each parameter follows:  % F %    o status: Method GetPixelCache returns a pointer to the pixels isL %      returned if the pixels are transferred, otherwise a NULL is returned. % 7 %    o image: The address of a structure of type Image.  % J %    o x,y,columns,rows:  These values define the perimeter of a region of %      pixels. %  %  */  : inline unsigned int MatchesLastRegionRequest(Image *image,5   const int x,const int y,const unsigned int columns,    const unsigned int rows) { A   if ((x == image->cache_info.x) && (y == image->cache_info.y) && -       (columns == image->cache_info.width) && )       (rows == image->cache_info.height))      return(True);    return(False); }   G Export PixelPacket *GetPixelCache(Image *image,const int x,const int y, 5   const unsigned int columns,const unsigned int rows)  {    RectangleInfo      region_info;     unsigned int     status;      /*)     Transfer pixels from the pixel cache.    */"   assert(image != (Image *) NULL);7   if (MatchesLastRegionRequest(image,x,y,columns,rows))      return(image->pixels);-   if (!SetPixelCache(image,x,y,columns,rows)) !     return((PixelPacket *) NULL);    region_info.x=x;   region_info.y=y;   region_info.height=rows;   region_info.width=columns;I   status=ReadCachePixels(image->cache_handle,&region_info,image->pixels);    if (status == False)     { D       MagickWarning(CacheWarning,"Unable to read pixels from cache",         (char *) NULL); #       return((PixelPacket *) NULL);      } "   if (image->class == PseudoClass)     {        /*7         Transfer colormap indexes from the pixel cache.        */O       status=ReadCacheIndexes(image->cache_handle,&region_info,image->indexes);        if (status == False)	         { I           MagickWarning(CacheWarning,"Unable to read indexes from cache",              (char *) NULL); '           return((PixelPacket *) NULL); 	         }      }    return(image->pixels); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   O p e n P i x e l C a c h e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Method OpenPixelCache returns True if the pixel cache is already C %  opened.  Otherwise the pixel cache is created in memory or disk. B %  False is returned if there is not enough memory or a disk error
 %  occurs. % . %  The format of the OpenPixelCache method is: % 0 %      unsigned int OpenPixelCache(Image *image) % + %  A description of each parameter follows:  % D %    o status: Method OpenPixelCache returns True if the image pixelF %      cache is already created or succesfully created in memory or on %      disk. % 7 %    o image: The address of a structure of type Image.  %  %  */0 static unsigned int OpenPixelCache(Image *image) {    unsigned int     status;   "   assert(image != (Image *) NULL);N   status=InitializePixelCache(image->cache_handle,image->class,image->columns,     image->rows);    return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d P i x e l C a c h e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method ReadPixelCache transfers one or more pixel components from a buffer 3 %  or file into the image pixel buffer of an image.  % . %  The format of the ReadPixelCache method is: % = %      void ReadPixelCache(Image *image,QuantumTypes quantum,  %        unsigned char *source)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % M %    o quantum: Declare which pixel components to transfer (red, green, blue,  %      opacity, RGB, or RGBA). % F %    o source:  The pixel components are transferred from this buffer. %  */L void ReadPixelCache(Image *image,QuantumTypes quantum,unsigned char *source) {    register IndexPacket
     index;     register int     x;     register PixelPacket     *q;      unsigned char      *p;   "   assert(image != (Image *) NULL);   p=source;    q=image->pixels;   switch (quantum)   {      case IndexQuantum:     {        if (image->colors <= 256) 	         { /           if (source == (unsigned char *) NULL) 
             { 6               for (x=0; x < (int) image->columns; x++)               { &                 index=ReadByte(image);(                 image->indexes[x]=index;,                 *q++=image->colormap[index];               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           {              index=(*p++); $             image->indexes[x]=index;(             *q++=image->colormap[index];           }            break;	         } +       if (source == (unsigned char *) NULL) 	         { 2           for (x=0; x < (int) image->columns; x++)           { +             index=MSBFirstReadShort(image); $             image->indexes[x]=index;(             *q++=image->colormap[index];           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {          index=(*p++ << 8); 	index|=(*p++);           image->indexes[x]=index;$         *q++=image->colormap[index];       }        break;     }      case IndexOpacityQuantum:      {        if (image->colors <= 256) 	         { /           if (source == (unsigned char *) NULL) 
             { 6               for (x=0; x < (int) image->columns; x++)               { &                 index=ReadByte(image);(                 image->indexes[x]=index;*                 *q=image->colormap[index];4                 q->opacity=UpScale(ReadByte(image));                 q++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           {              index=(*p++); $             image->indexes[x]=index;&             *q=image->colormap[index];%             q->opacity=UpScale(*p++);              q++;           }            break;	         } +       if (source == (unsigned char *) NULL) 	         { 2           for (x=0; x < (int) image->columns; x++)           { +             index=MSBFirstReadShort(image); $             image->indexes[x]=index;&             *q=image->colormap[index];O             q->opacity=MSBFirstReadShort(image) >> (image->depth-QuantumDepth);              q++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {          index=(*p++ << 8); 	index|=(*p++);           image->indexes[x]=index;"         *q=image->colormap[index];         q->opacity=(*p++ << 8);  	q->opacity|=(*p++);         q++;       }        break;     }      case GrayQuantum:      {        if (image->colors <= 256) 	         { /           if (source == (unsigned char *) NULL) 
             { 6               for (x=0; x < (int) image->columns; x++)               { /                 index=UpScale(ReadByte(image)); (                 image->indexes[x]=index;,                 *q++=image->colormap[index];               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           {               index=UpScale(*p++);$             image->indexes[x]=index;(             *q++=image->colormap[index];           }            break;	         } +       if (source == (unsigned char *) NULL) 	         { 2           for (x=0; x < (int) image->columns; x++)           { J             index=MSBFirstReadShort(image) >> (image->depth-QuantumDepth);$             image->indexes[x]=index;(             *q++=image->colormap[index];           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {          index=(*p++ << 8); 	index|=(*p++);           image->indexes[x]=index;$         *q++=image->colormap[index];       }        break;     }      case GrayOpacityQuantum:     {        if (image->colors <= 256) 	         { /           if (source == (unsigned char *) NULL) 
             { 6               for (x=0; x < (int) image->columns; x++)               { /                 index=UpScale(ReadByte(image)); (                 image->indexes[x]=index;*                 *q=image->colormap[index];4                 q->opacity=UpScale(ReadByte(image));                 q++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           {               index=UpScale(*p++);$             image->indexes[x]=index;&             *q=image->colormap[index];%             q->opacity=UpScale(*p++);              q++;           }            break;	         } +       if (source == (unsigned char *) NULL) 	         { 2           for (x=0; x < (int) image->columns; x++)           { J             index=MSBFirstReadShort(image) >> (image->depth-QuantumDepth);$             image->indexes[x]=index;&             *q=image->colormap[index];O             q->opacity=MSBFirstReadShort(image) >> (image->depth-QuantumDepth);              q++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {          index=(*p++ << 8); 	index|=(*p++);           image->indexes[x]=index;"         *q=image->colormap[index];         q->opacity=(*p++ << 8);  	q->opacity|=(*p++);         q++;       }        break;     }      case RedQuantum:     case CyanQuantum:      {        if (image->depth <= 8)	         { /           if (source == (unsigned char *) NULL) 
             { 6               for (x=0; x < (int) image->columns; x++)               { 0                 q->red=UpScale(ReadByte(image));                 q++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           { !             q->red=UpScale(*p++);              q++;           }            break;	         } +       if (source == (unsigned char *) NULL) 	         { 2           for (x=0; x < (int) image->columns; x++)           { K             q->red=MSBFirstReadShort(image) >> (image->depth-QuantumDepth);              q++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {          q->red=(*p++ << 8);          q->red|=(*p++);          q++;       }        break;     }      case GreenQuantum:     case YellowQuantum:      {        if (image->depth <= 8)	         { /           if (source == (unsigned char *) NULL) 
             { 6               for (x=0; x < (int) image->columns; x++)               { 2                 q->green=UpScale(ReadByte(image));                 q++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           { #             q->green=UpScale(*p++);              q++;           }            break;	         } +       if (source == (unsigned char *) NULL) 	         { 2           for (x=0; x < (int) image->columns; x++)           { M             q->green=MSBFirstReadShort(image) >> (image->depth-QuantumDepth);              q++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {          q->green=(*p++ << 8);          q->green|=(*p++);          q++;       }        break;     }      case BlueQuantum:      case MagentaQuantum:     {        if (image->depth <= 8)	         { /           if (source == (unsigned char *) NULL) 
             { 6               for (x=0; x < (int) image->columns; x++)               { 1                 q->blue=UpScale(ReadByte(image));                  q++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           { "             q->blue=UpScale(*p++);             q++;           }            break;	         } +       if (source == (unsigned char *) NULL) 	         { 2           for (x=0; x < (int) image->columns; x++)           { L             q->blue=MSBFirstReadShort(image) >> (image->depth-QuantumDepth);             q++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {          q->blue=(*p++ << 8);         q->blue|=(*p++);         q++;       }        break;     }      case OpacityQuantum:     case BlackQuantum:     {        if (image->depth <= 8)	         { /           if (source == (unsigned char *) NULL) 
             { 6               for (x=0; x < (int) image->columns; x++)               { 4                 q->opacity=UpScale(ReadByte(image));                 q++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           { %             q->opacity=UpScale(*p++);              q++;           }            break;	         } +       if (source == (unsigned char *) NULL) 	         { 2           for (x=0; x < (int) image->columns; x++)           { O             q->opacity=MSBFirstReadShort(image) >> (image->depth-QuantumDepth);              q++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {          q->opacity=(*p++ << 8);          q->opacity|=(*p++);          q++;       }        break;     }      case RGBQuantum:     default:     {        if (image->depth <= 8)	         { /           if (source == (unsigned char *) NULL) 
             { 6               for (x=0; x < (int) image->columns; x++)               { 0                 q->red=UpScale(ReadByte(image));2                 q->green=UpScale(ReadByte(image));1                 q->blue=UpScale(ReadByte(image));                  q++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           { !             q->red=UpScale(*p++); #             q->green=UpScale(*p++); "             q->blue=UpScale(*p++);             q++;           }            break;	         } +       if (source == (unsigned char *) NULL) 	         { 2           for (x=0; x < (int) image->columns; x++)           { K             q->red=MSBFirstReadShort(image) >> (image->depth-QuantumDepth); M             q->green=MSBFirstReadShort(image) >> (image->depth-QuantumDepth); L             q->blue=MSBFirstReadShort(image) >> (image->depth-QuantumDepth);             q++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {          q->red=(*p++ << 8);          q->red|=(*p++);          q->green=(*p++ << 8);          q->green|=(*p++);          q->blue=(*p++ << 8);         q->blue|=(*p++);         q++;       }        break;     }      case RGBAQuantum:      case CMYKQuantum:      {        if (image->depth <= 8)	         { /           if (source == (unsigned char *) NULL) 
             { 6               for (x=0; x < (int) image->columns; x++)               { 0                 q->red=UpScale(ReadByte(image));2                 q->green=UpScale(ReadByte(image));1                 q->blue=UpScale(ReadByte(image)); 4                 q->opacity=UpScale(ReadByte(image));                 q++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           { !             q->red=UpScale(*p++); #             q->green=UpScale(*p++); "             q->blue=UpScale(*p++);%             q->opacity=UpScale(*p++);              q++;           }            break;	         } +       if (source == (unsigned char *) NULL) 	         { 2           for (x=0; x < (int) image->columns; x++)           { K             q->red=MSBFirstReadShort(image) >> (image->depth-QuantumDepth); M             q->green=MSBFirstReadShort(image) >> (image->depth-QuantumDepth); L             q->blue=MSBFirstReadShort(image) >> (image->depth-QuantumDepth);O             q->opacity=MSBFirstReadShort(image) >> (image->depth-QuantumDepth);              q++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {          q->red=(*p++ << 8);          q->red|=(*p++);          q->green=(*p++ << 8);          q->green|=(*p++);          q->blue=(*p++ << 8);         q->blue|=(*p++);         q->opacity=(*p++ << 8);          q->opacity|=(*p++);          q++;       }        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S e t P i x e l C a c h e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method SetPixelCache allocates an area to store image pixels as definedK %  by the region rectangle and returns a pointer to the area.  This area is I %  subsequently transferred from the pixel cache with the SyncPixelCache. E %  A pointer to the pixels is returned if the pixels are transferred,   %  otherwise a NULL is returned. % @ %  This example illustrates the use of the SetPixelCache method: % * %    for (y=0; y < (int) image->rows; y++) %    {3 %      q=SetPixelCache(image,0,y,image->columns,1); % %      if (q == (PixelPacket *) NULL)  %        break; / %      for (x=0; x < (int) image->columns; x++)  %      {) %        if (image->class == PseudoClass)  %          image->indexes[x]=0;  %        q->red=0; %        q->green=0; %        q->blue=0; 
 %        q++;  %      }" %      if (!SyncPixelCache(image)) %        break; - %      if (image->previous == (Image *) NULL) ( %        if (QuantumTick(y,image->rows))8 %          ProgressMonitor(LoadImageText,y,image->rows); %    } % - %  The format of the SetPixelCache method is:  % G %      PixelPacket *SetPixelCache(Image *image,const int x,const int y, < %        const unsigned int columns,const unsigned int rows) % + %  A description of each parameter follows:  % F %    o status: Method SetPixelCache returns a pointer to the pixels isL %      returned if the pixels are transferred, otherwise a NULL is returned. % 7 %    o image: The address of a structure of type Image.  % J %    o x,y,columns,rows:  These values define the perimeter of a region of %      pixels. %  %  */  > inline unsigned int MatchesLastRegionRequestSize(Image *image,   const size_t number_pixels)  { I   if ((image->cache_info.width*image->cache_info.height) < number_pixels)      return(True);    return(False); }   G Export PixelPacket *SetPixelCache(Image *image,const int x,const int y, 5   const unsigned int columns,const unsigned int rows)  {    size_t     number_pixels;     /*"     Validate pixel cache geometry.   */"   assert(image != (Image *) NULL);C   if ((x < 0) || (y < 0) || ((x+columns) > (int) image->columns) || F       ((y+rows) > (int) image->rows) || (columns == 0) || (rows == 0))     { =       MagickWarning(CacheWarning,"Unable to set pixel cache", 5         "image does not contain the cache geometry"); #       return((PixelPacket *) NULL);      }    if (!OpenPixelCache(image))      { D       MagickWarning(CacheWarning,"Unable to initialize pixel cache",         (char *) NULL); #       return((PixelPacket *) NULL);      }    /*;     Allocate buffer to get/put pixels from the pixel cache.    */   number_pixels=columns*rows; ,   if (image->pixels == (PixelPacket *) NULL)!     image->pixels=(PixelPacket *) 8       AllocateMemory(number_pixels*sizeof(PixelPacket));   else:     if (MatchesLastRegionRequestSize(image,number_pixels))#       image->pixels=(PixelPacket *) J         ReallocateMemory(image->pixels,number_pixels*sizeof(PixelPacket));   /*E     Allocate buffer to get/put colormap indexes from the pixel cache.    */"   if (image->class == PseudoClass)/     if (image->indexes == (IndexPacket *) NULL) $       image->indexes=(IndexPacket *):         AllocateMemory(number_pixels*sizeof(IndexPacket));-   if (image->indexes != (IndexPacket *) NULL) :     if (MatchesLastRegionRequestSize(image,number_pixels))E       image->indexes=(IndexPacket *) ReallocateMemory(image->indexes, +         number_pixels*sizeof(IndexPacket)); '   if (((image->class == PseudoClass) && 3        (image->indexes == (IndexPacket *) NULL)) || .       (image->pixels == (PixelPacket *) NULL))     { =       MagickWarning(CacheWarning,"Unable to set pixel cache", $         "Memory allocation failed");#       return((PixelPacket *) NULL);      }    /*!     Set the pixel cache geometry.    */   image->cache_info.x=x;   image->cache_info.y=y;"   image->cache_info.width=columns;    image->cache_info.height=rows;   return(image->pixels); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S y n c P i x e l C a c h e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method SyncPixelCache saves the image pixels to the in-memory or diskO %  cache.  The method returns True if the pixel region is set, otherwise False. G %  See the SetPixelCache method for an example usage of SyncPixelCache.  % . %  The format of the SyncPixelCache method is: % 0 %      unsigned int SyncPixelCache(Image *image) % + %  A description of each parameter follows:  % I %    o status: Method SyncPixelCache returns True if the image pixels are B %      transferred to the in-memory or disk cache otherwise False. % 7 %    o image: The address of a structure of type Image.  %  %  */0 Export unsigned int SyncPixelCache(Image *image) {    register PixelPacket     *p;      unsigned int     status;   "   assert(image != (Image *) NULL);@   p=SetPixelCache(image,image->cache_info.x,image->cache_info.y,6     image->cache_info.width,image->cache_info.height);    if (p == (PixelPacket *) NULL)     return(False);   /*#     Transfer pixels to pixel cache.    */   image->tainted=True;D   status=WriteCachePixels(image->cache_handle,&image->cache_info,p);   if (status == False)     { M       MagickWarning(CacheWarning,"Unable to sync pixel cache",(char *) NULL);        return(False);     } "   if (image->class == PseudoClass)     {        /*1         Transfer colormap indexes to pixel cache.        */F       status=WriteCacheIndexes(image->cache_handle,&image->cache_info,         image->indexes);       if (status == False)	         { B           MagickWarning(CacheWarning,"Unable to sync pixel cache",             (char *) NULL);            return(False);	         }      }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P i x e l C a c h e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Method WritePixelCache transfers one or more pixel components from the image $ %  pixel buffer to a buffer or file. % / %  The format of the WritePixelCache method is:  % 9 %      void WritePixelCache(Image *,QuantumTypes quantum, $ %        unsigned char *destination) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % M %    o quantum: Declare which pixel components to transfer (red, green, blue,  %      opacity, RGB, or RGBA). % C %    o destination:  The components are transferred to this buffer.  %  %  */7 void WritePixelCache(Image *image,QuantumTypes quantum,    unsigned char *destination)  {    register int     x;     register PixelPacket     *p;      unsigned char      *q;   "   assert(image != (Image *) NULL);   p=image->pixels;   q=destination;   switch (quantum)   {      case IndexQuantum:     {        if (image->colors <= 256) 	         { 4           if (destination == (unsigned char *) NULL)
             { 6               for (x=0; x < (int) image->columns; x++):                 (void) WriteByte(image,image->indexes[x]);               break;
             } 2           for (x=0; x < (int) image->columns; x++)#             *q++=image->indexes[x];            break;	         } 0       if (destination == (unsigned char *) NULL)	         { 2           for (x=0; x < (int) image->columns; x++)8             MSBFirstWriteShort(image,image->indexes[x]);           break;	         } .       for (x=0; x < (int) image->columns; x++)       { $         *q++=image->indexes[x] >> 8;         *q++=image->indexes[x];        }        break;     }      case IndexOpacityQuantum:      {        if (image->depth <= 8)	         { 4           if (destination == (unsigned char *) NULL)
             { 6               for (x=0; x < (int) image->columns; x++)               { :                 (void) WriteByte(image,image->indexes[x]);3                 (void) WriteByte(image,p->opacity);                  p++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           { #             *q++=image->indexes[x];              *q++=p->opacity;             p++;           }            break;	         } 0       if (destination == (unsigned char *) NULL)	         { 2           for (x=0; x < (int) image->columns; x++)           { 0             if ((QuantumDepth-image->depth) > 0)>               MSBFirstWriteShort(image,257*image->indexes[x]);             else:               MSBFirstWriteShort(image,image->indexes[x]);0             if ((QuantumDepth-image->depth) > 0)7               MSBFirstWriteShort(image,257*p->opacity);              else3               MSBFirstWriteShort(image,p->opacity);              p++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       { $         *q++=image->indexes[x] >> 8;         *q++=image->indexes[x];          *q++=p->opacity >> 8;          *q++=p->opacity;         p++;       }        break;     }      case GrayQuantum:      {        if (image->depth <= 8)	         { 4           if (destination == (unsigned char *) NULL)
             { 6               for (x=0; x < (int) image->columns; x++)               { 6                 (void) WriteByte(image,Intensity(*p));                 p++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           {              *q++=Intensity(*p);              p++;           }            break;	         } 0       if (destination == (unsigned char *) NULL)	         { 2           for (x=0; x < (int) image->columns; x++)           { 0             if ((QuantumDepth-image->depth) > 0):               MSBFirstWriteShort(image,257*Intensity(*p));             else6               MSBFirstWriteShort(image,Intensity(*p));             p++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {           *q++=Intensity(*p) >> 8;         *q++=Intensity(*p);          p++;       }        break;     }      case GrayOpacityQuantum:     {        if (image->depth <= 8)	         { 4           if (destination == (unsigned char *) NULL)
             { 6               for (x=0; x < (int) image->columns; x++)               { 6                 (void) WriteByte(image,Intensity(*p));3                 (void) WriteByte(image,p->opacity);                  p++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           {              *q++=Intensity(*p);              *q++=p->opacity;             p++;           }            break;	         } 0       if (destination == (unsigned char *) NULL)	         { 2           for (x=0; x < (int) image->columns; x++)           { 0             if ((QuantumDepth-image->depth) > 0):               MSBFirstWriteShort(image,257*Intensity(*p));             else6               MSBFirstWriteShort(image,Intensity(*p));0             if ((QuantumDepth-image->depth) > 0)7               MSBFirstWriteShort(image,257*p->opacity);              else3               MSBFirstWriteShort(image,p->opacity);              p++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {           *q++=Intensity(*p) >> 8;         *q++=Intensity(*p);          *q++=p->opacity >> 8;          *q++=p->opacity;         p++;       }        break;     }      case RedQuantum:     case CyanQuantum:      {        if (image->depth <= 8)	         { 4           if (destination == (unsigned char *) NULL)
             { 6               for (x=0; x < (int) image->columns; x++)               { :                 (void) WriteByte(image,DownScale(p->red));                 p++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           { #             *q++=DownScale(p->red);              p++;           }            break;	         } 0       if (destination == (unsigned char *) NULL)	         { 2           for (x=0; x < (int) image->columns; x++)           { 0             if ((QuantumDepth-image->depth) > 0)3               MSBFirstWriteShort(image,257*p->red);              else/               MSBFirstWriteShort(image,p->red);              p++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {          *q++=p->red >> 8;          *q++=p->red;         p++;       }        break;     }      case GreenQuantum:     case YellowQuantum:      {        if (image->depth <= 8)	         { 4           if (destination == (unsigned char *) NULL)
             { 6               for (x=0; x < (int) image->columns; x++)               { <                 (void) WriteByte(image,DownScale(p->green));                 p++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           { %             *q++=DownScale(p->green);              p++;           }            break;	         } 0       if (destination == (unsigned char *) NULL)	         { 2           for (x=0; x < (int) image->columns; x++)           { 0             if ((QuantumDepth-image->depth) > 0)5               MSBFirstWriteShort(image,257*p->green);              else1               MSBFirstWriteShort(image,p->green);              p++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {          *q++=p->green >> 8;          *q++=p->green;         p++;       }        break;     }      case BlueQuantum:      case MagentaQuantum:     {        if (image->depth <= 8)	         { 4           if (destination == (unsigned char *) NULL)
             { 6               for (x=0; x < (int) image->columns; x++)               { ;                 (void) WriteByte(image,DownScale(p->blue));                  p++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           { $             *q++=DownScale(p->blue);             p++;           }            break;	         } 0       if (destination == (unsigned char *) NULL)	         { 2           for (x=0; x < (int) image->columns; x++)           { 0             if ((QuantumDepth-image->depth) > 0)4               MSBFirstWriteShort(image,257*p->blue);             else0               MSBFirstWriteShort(image,p->blue);             p++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {          *q++=p->blue >> 8;         *q++=p->blue;          p++;       }        break;     }      case OpacityQuantum:     case BlackQuantum:     {        if (image->depth <= 8)	         { 4           if (destination == (unsigned char *) NULL)
             { 6               for (x=0; x < (int) image->columns; x++)               { >                 (void) WriteByte(image,DownScale(p->opacity));                 p++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           { '             *q++=DownScale(p->opacity);              p++;           }            break;	         } 0       if (destination == (unsigned char *) NULL)	         { 2           for (x=0; x < (int) image->columns; x++)           { 0             if ((QuantumDepth-image->depth) > 0)7               MSBFirstWriteShort(image,257*p->opacity);              else3               MSBFirstWriteShort(image,p->opacity);              p++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {          *q++=p->opacity >> 8;          *q++=p->opacity;         p++;       }        break;     }      case RGBQuantum:     default:     {        if (image->depth <= 8)	         { 4           if (destination == (unsigned char *) NULL)
             { 6               for (x=0; x < (int) image->columns; x++)               { :                 (void) WriteByte(image,DownScale(p->red));<                 (void) WriteByte(image,DownScale(p->green));;                 (void) WriteByte(image,DownScale(p->blue));                  p++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           { #             *q++=DownScale(p->red); %             *q++=DownScale(p->green); $             *q++=DownScale(p->blue);             p++;           }            break;	         } 0       if (destination == (unsigned char *) NULL)	         { 2           for (x=0; x < (int) image->columns; x++)           { 0             if ((QuantumDepth-image->depth) > 0)               { 5                 MSBFirstWriteShort(image,257*p->red); 7                 MSBFirstWriteShort(image,257*p->green); 6                 MSBFirstWriteShort(image,257*p->blue);               }              else               { 1                 MSBFirstWriteShort(image,p->red); 3                 MSBFirstWriteShort(image,p->green); 2                 MSBFirstWriteShort(image,p->blue);               }              p++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {          *q++=p->red >> 8;          *q++=p->red;         *q++=p->green >> 8;          *q++=p->green;         *q++=p->blue >> 8;         *q++=p->blue;          p++;       }        break;     }      case RGBAQuantum:      case CMYKQuantum:      {        if (image->depth <= 8)	         { 4           if (destination == (unsigned char *) NULL)
             { 6               for (x=0; x < (int) image->columns; x++)               { :                 (void) WriteByte(image,DownScale(p->red));<                 (void) WriteByte(image,DownScale(p->green));;                 (void) WriteByte(image,DownScale(p->blue)); >                 (void) WriteByte(image,DownScale(p->opacity));                 p++;               }                break;
             } 2           for (x=0; x < (int) image->columns; x++)           { #             *q++=DownScale(p->red); %             *q++=DownScale(p->green); $             *q++=DownScale(p->blue);'             *q++=DownScale(p->opacity);              p++;           }            break;	         } 0       if (destination == (unsigned char *) NULL)	         { 2           for (x=0; x < (int) image->columns; x++)           { 0             if ((QuantumDepth-image->depth) > 0)               { 5                 MSBFirstWriteShort(image,257*p->red); 7                 MSBFirstWriteShort(image,257*p->green); 6                 MSBFirstWriteShort(image,257*p->blue);9                 MSBFirstWriteShort(image,257*p->opacity);                }              else               { 1                 MSBFirstWriteShort(image,p->red); 3                 MSBFirstWriteShort(image,p->green); 2                 MSBFirstWriteShort(image,p->blue);5                 MSBFirstWriteShort(image,p->opacity);                }              p++;           }            break;	         } .       for (x=0; x < (int) image->columns; x++)       {          *q++=p->red >> 8;          *q++=p->red;         *q++=p->green >> 8;          *q++=p->green;         *q++=p->blue >> 8;         *q++=p->blue;          *q++=p->opacity >> 8;          *q++=p->opacity;         p++;       }        break;     }    }  } 